/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.project.buildfile;

import io.quarkus.devtools.project.extensions.ExtensionInstallPlan;
import io.quarkus.devtools.project.extensions.ExtensionManager;
import io.quarkus.devtools.project.extensions.Extensions;
import io.quarkus.maven.ArtifactCoords;
import io.quarkus.maven.ArtifactKey;
import io.quarkus.registry.catalog.Extension;
import io.quarkus.registry.catalog.ExtensionCatalog;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class BuildFile
implements ExtensionManager {
    private final Path projectDirPath;
    private final ExtensionCatalog catalog;

    public BuildFile(Path projectDirPath, ExtensionCatalog catalog) {
        this.projectDirPath = Objects.requireNonNull(projectDirPath, "projectPath is required");
        this.catalog = Objects.requireNonNull(catalog, "catalog is required");
    }

    @Override
    public final ExtensionManager.InstallResult install(Collection<ArtifactCoords> coords) throws IOException {
        this.refreshData();
        Collection<ArtifactCoords> installed = this.withoutAlreadyInstalled(coords);
        installed.forEach(e -> this.addDependency((ArtifactCoords)e, e.getVersion() == null));
        this.writeToDisk();
        return new ExtensionManager.InstallResult(installed);
    }

    @Override
    public ExtensionManager.InstallResult install(ExtensionInstallPlan plan) throws IOException {
        ArrayList<ArtifactCoords> installed = new ArrayList<ArtifactCoords>();
        for (ArtifactCoords platform : this.withoutAlreadyInstalled(plan.getPlatforms())) {
            if (!this.addDependency(platform, false)) continue;
            installed.add(platform);
        }
        for (ArtifactCoords managedExtension : this.withoutAlreadyInstalled(plan.getManagedExtensions())) {
            if (!this.addDependency(managedExtension, true)) continue;
            installed.add(managedExtension);
        }
        for (ArtifactCoords independentExtension : this.withoutAlreadyInstalled(plan.getIndependentExtensions())) {
            if (!this.addDependency(independentExtension, false)) continue;
            installed.add(independentExtension);
        }
        this.writeToDisk();
        return new ExtensionManager.InstallResult(installed);
    }

    @Override
    public final Collection<ArtifactCoords> getInstalled() throws IOException {
        this.refreshData();
        return this.getDependencies().stream().filter(d -> this.isQuarkusExtension(d.getKey())).collect(Collectors.toList());
    }

    @Override
    public final ExtensionManager.UninstallResult uninstall(Collection<ArtifactKey> keys) throws IOException {
        this.refreshData();
        Set<ArtifactKey> existingKeys = this.getDependenciesKeys();
        List<ArtifactKey> uninstalled = keys.stream().distinct().filter(existingKeys::contains).filter(k -> {
            try {
                this.removeDependency((ArtifactKey)k);
                return true;
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }).collect(Collectors.toList());
        this.writeToDisk();
        return new ExtensionManager.UninstallResult(uninstalled);
    }

    private Collection<ArtifactCoords> withoutAlreadyInstalled(Collection<ArtifactCoords> extensions) throws IOException {
        Set<ArtifactKey> existingKeys = this.getDependenciesKeys();
        return extensions.stream().distinct().filter(a -> !existingKeys.contains(a.getKey())).collect(Collectors.toList());
    }

    protected abstract boolean addDependency(ArtifactCoords var1, boolean var2);

    protected abstract void removeDependency(ArtifactKey var1) throws IOException;

    protected abstract List<ArtifactCoords> getDependencies() throws IOException;

    protected abstract void writeToDisk() throws IOException;

    protected abstract String getProperty(String var1) throws IOException;

    protected abstract void refreshData();

    protected Path getProjectDirPath() {
        return this.projectDirPath;
    }

    protected boolean hasProjectFile(String fileName) throws IOException {
        Path filePath = this.projectDirPath.resolve(fileName);
        return Files.exists(filePath, new LinkOption[0]);
    }

    protected byte[] readProjectFile(String fileName) throws IOException {
        Path filePath = this.projectDirPath.resolve(fileName);
        return Files.readAllBytes(filePath);
    }

    protected void writeToProjectFile(String fileName, byte[] content) throws IOException {
        Files.write(this.projectDirPath.resolve(fileName), content, new OpenOption[0]);
    }

    private boolean isQuarkusExtension(ArtifactKey key) {
        return this.catalog != null ? BuildFile.isDefinedInRegistry(this.catalog.getExtensions(), key) : false;
    }

    private Set<ArtifactKey> getDependenciesKeys() throws IOException {
        return this.getDependencies().stream().map(ArtifactCoords::getKey).collect(Collectors.toSet());
    }

    public static boolean isDefinedInRegistry(Collection<Extension> registry, ArtifactKey key) {
        return Extensions.findInList(registry, key).isPresent();
    }
}

