/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.platform.catalog.processor;

import io.quarkus.platform.catalog.processor.ExtendedKeywords;
import io.quarkus.platform.catalog.processor.MetadataValue;
import io.quarkus.registry.catalog.Extension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class ExtensionProcessor {
    private static final String STABLE_STATS = "stable";
    public static final String PROVIDES_CODE_TAG = "provides-code";
    private final Extension extension;

    private ExtensionProcessor(Extension extension) {
        this.extension = Objects.requireNonNull(extension);
    }

    public static ExtensionProcessor of(Extension extension) {
        return new ExtensionProcessor(extension);
    }

    public static String getShortName(Extension extension) {
        String shortName = ExtensionProcessor.getMetadataValue(extension, "short-name").asString();
        return shortName == null ? extension.getName() : shortName;
    }

    public static String getGuide(Extension extension) {
        return ExtensionProcessor.getMetadataValue(extension, "guide").asString();
    }

    public static List<String> getCategories(Extension extension) {
        return ExtensionProcessor.getMetadataValue(extension, "categories").asStringList();
    }

    public static String getBuiltWithQuarkusCore(Extension extension) {
        return ExtensionProcessor.getMetadataValue(extension, "built-with-quarkus-core").asString();
    }

    public static String getCodestartName(Extension extension) {
        return ExtensionProcessor.getMetadataValue(extension, "codestart.name").asString();
    }

    public static List<String> getCodestartLanguages(Extension extension) {
        return ExtensionProcessor.getMetadataValue(extension, "codestart.languages").asStringList();
    }

    public static String getCodestartArtifact(Extension extension) {
        return ExtensionProcessor.getMetadataValue(extension, "codestart.artifact").asString();
    }

    public static CodestartKind getCodestartKind(Extension extension) {
        if (ExtensionProcessor.getCodestartName(extension) == null) {
            return null;
        }
        return ExtensionProcessor.getMetadataValue(extension, "codestart.kind").toEnum(CodestartKind.class, CodestartKind.EXTENSION_CODESTART);
    }

    public static boolean providesCode(Extension extension) {
        CodestartKind codestartKind = ExtensionProcessor.getCodestartKind(extension);
        return codestartKind != null && codestartKind.providesCode();
    }

    public static boolean isUnlisted(Extension extension) {
        return ExtensionProcessor.getMetadataValue(extension, "unlisted").asBoolean();
    }

    public static List<String> getKeywords(Extension extension) {
        return ExtensionProcessor.getMetadataValue(extension, "keywords").asStringList();
    }

    public static List<String> getExtendedKeywords(Extension extension) {
        return ExtendedKeywords.extendsKeywords(extension.getArtifact().getArtifactId(), extension.getDescription(), ExtensionProcessor.getKeywords(extension));
    }

    public static List<String> getTags(Extension extension) {
        return ExtensionProcessor.getTags(extension, null);
    }

    public static List<String> getTags(Extension extension, String customStatusKey) {
        ArrayList<String> keys = new ArrayList<String>();
        keys.add(customStatusKey != null ? customStatusKey : "status");
        List tags = keys.stream().map(key -> ExtensionProcessor.getMetadataValue(extension, key).asStringList()).flatMap(Collection::stream).filter(tag -> !STABLE_STATS.equals(tag)).map(String::toLowerCase).collect(Collectors.toCollection(ArrayList::new));
        if (ExtensionProcessor.providesCode(extension)) {
            tags.add(PROVIDES_CODE_TAG);
        }
        return tags;
    }

    public Extension getExtension() {
        return this.extension;
    }

    public String getBuiltWithQuarkusCore() {
        return ExtensionProcessor.getBuiltWithQuarkusCore(this.extension);
    }

    public String getGuide() {
        return ExtensionProcessor.getGuide(this.extension);
    }

    public String getShortName() {
        return ExtensionProcessor.getShortName(this.extension);
    }

    public String getCodestartName() {
        return ExtensionProcessor.getCodestartName(this.extension);
    }

    public List<String> getCategories() {
        return ExtensionProcessor.getCategories(this.extension);
    }

    public List<String> getCodestartLanguages() {
        return ExtensionProcessor.getCodestartLanguages(this.extension);
    }

    public String getCodestartArtifact() {
        return ExtensionProcessor.getCodestartArtifact(this.extension);
    }

    public CodestartKind getCodestartKind() {
        return ExtensionProcessor.getCodestartKind(this.extension);
    }

    public boolean providesCode() {
        return ExtensionProcessor.providesCode(this.extension);
    }

    public boolean isUnlisted() {
        return ExtensionProcessor.isUnlisted(this.extension);
    }

    public List<String> getKeywords() {
        return ExtensionProcessor.getKeywords(this.extension);
    }

    public List<String> getExtendedKeywords() {
        return ExtensionProcessor.getExtendedKeywords(this.extension);
    }

    public List<String> getTags() {
        return ExtensionProcessor.getTags(this.extension, null);
    }

    public List<String> getTags(String customStatusKey) {
        ArrayList<String> keys = new ArrayList<String>();
        keys.add(customStatusKey != null ? customStatusKey : "status");
        List tags = keys.stream().map(key -> ExtensionProcessor.getMetadataValue(this.extension, key).asStringList()).flatMap(Collection::stream).filter(tag -> !STABLE_STATS.equals(tag)).map(String::toLowerCase).collect(Collectors.toCollection(ArrayList::new));
        if (this.providesCode()) {
            tags.add(PROVIDES_CODE_TAG);
        }
        return tags;
    }

    public static MetadataValue getMetadataValue(Extension extension, String path) {
        return MetadataValue.get(extension.getMetadata(), path);
    }

    public static enum CodestartKind {
        CORE,
        EXTENSION_CODESTART,
        EXAMPLE;


        public boolean providesCode() {
            return this == EXTENSION_CODESTART || this == EXAMPLE;
        }
    }
}

