/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.project.extensions;

import io.quarkus.maven.dependency.ArtifactCoords;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public class ExtensionInstallPlan {
    public static final ExtensionInstallPlan EMPTY = new ExtensionInstallPlan(Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet());
    private final Set<ArtifactCoords> platforms;
    private final Set<ArtifactCoords> managedExtensions;
    private final Set<ArtifactCoords> independentExtensions;
    private final Collection<String> unmatchedKeywords;

    private ExtensionInstallPlan(Set<ArtifactCoords> platforms, Set<ArtifactCoords> managedExtensions, Set<ArtifactCoords> independentExtensions, Collection<String> unmatchedKeywords) {
        this.platforms = platforms;
        this.managedExtensions = managedExtensions;
        this.independentExtensions = independentExtensions;
        this.unmatchedKeywords = unmatchedKeywords;
    }

    public boolean isNotEmpty() {
        return !this.platforms.isEmpty() || !this.managedExtensions.isEmpty() || !this.independentExtensions.isEmpty();
    }

    public boolean isInstallable() {
        return this.isNotEmpty() && this.unmatchedKeywords.isEmpty();
    }

    public Collection<ArtifactCoords> toCollection() {
        LinkedHashSet<ArtifactCoords> result = new LinkedHashSet<ArtifactCoords>();
        result.addAll(this.getPlatforms());
        result.addAll(this.getManagedExtensions());
        result.addAll(this.getIndependentExtensions());
        return result;
    }

    public Collection<ArtifactCoords> getPlatforms() {
        return this.platforms;
    }

    public Collection<ArtifactCoords> getManagedExtensions() {
        return this.managedExtensions;
    }

    public Collection<ArtifactCoords> getIndependentExtensions() {
        return this.independentExtensions;
    }

    public Collection<String> getUnmatchedKeywords() {
        return this.unmatchedKeywords;
    }

    public String toString() {
        return "InstallRequest{platforms=" + this.platforms + ", managedExtensions=" + this.managedExtensions + ", independentExtensions=" + this.independentExtensions + ", unmatchedKeywords=" + this.unmatchedKeywords + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Set<ArtifactCoords> platforms = new LinkedHashSet<ArtifactCoords>();
        private final Set<ArtifactCoords> extensionsInPlatforms = new LinkedHashSet<ArtifactCoords>();
        private final Set<ArtifactCoords> independentExtensions = new LinkedHashSet<ArtifactCoords>();
        private final Collection<String> unmatchedKeywords = new ArrayList<String>();

        public ExtensionInstallPlan build() {
            return new ExtensionInstallPlan(this.platforms, this.extensionsInPlatforms, this.independentExtensions, this.unmatchedKeywords);
        }

        public Builder addIndependentExtension(ArtifactCoords artifactCoords) {
            this.independentExtensions.add(artifactCoords);
            return this;
        }

        public Builder addManagedExtension(ArtifactCoords artifactCoords) {
            this.extensionsInPlatforms.add(artifactCoords);
            return this;
        }

        public Builder addPlatform(ArtifactCoords artifactCoords) {
            this.platforms.add(artifactCoords);
            return this;
        }

        public Builder addUnmatchedKeyword(String unmatchedKeyword) {
            this.unmatchedKeywords.add(unmatchedKeyword);
            return this;
        }

        public boolean hasExtensionInPlatform() {
            return !this.extensionsInPlatforms.isEmpty();
        }
    }
}

