/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.exec;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class ExecSupport {
    private final PrintWriter out;
    private final PrintWriter err;
    private final boolean verbose;
    private final boolean cliTest;

    public ExecSupport() {
        this(System.out, System.err, false, false);
    }

    public ExecSupport(PrintStream out, PrintStream err, boolean verbose, boolean cliTest) {
        this(new PrintWriter(out), new PrintWriter(err), verbose, cliTest);
    }

    public ExecSupport(PrintWriter out, PrintWriter err, boolean verbose, boolean cliTest) {
        this.out = out;
        this.err = err;
        this.verbose = verbose;
        this.cliTest = cliTest;
    }

    public int executeProcess(String[] args, File parentDir) throws IOException, InterruptedException {
        int exit = 0;
        if (this.isVerbose()) {
            this.out.println(String.join((CharSequence)" ", args));
            this.out.println();
        }
        if (this.isCliTest()) {
            Process process = new ProcessBuilder(new String[0]).command(args).redirectInput(ProcessBuilder.Redirect.INHERIT).directory(parentDir).start();
            ExecutorService service = Executors.newFixedThreadPool(2);
            service.submit(() -> new BufferedReader(new InputStreamReader(process.getInputStream())).lines().forEach(this.out::println));
            service.submit(() -> new BufferedReader(new InputStreamReader(process.getErrorStream())).lines().forEach(this.err::println));
            process.waitFor(5L, TimeUnit.MINUTES);
            service.shutdown();
            exit = process.exitValue();
        } else {
            Process process = new ProcessBuilder(new String[0]).command(args).inheritIO().directory(parentDir).start();
            exit = process.waitFor();
        }
        return exit;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public boolean isCliTest() {
        return this.cliTest;
    }
}

