/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry.json;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import io.quarkus.registry.json.JsonBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class JsonEntityWithAnySupport {
    private final Map<String, Object> metadata;

    protected JsonEntityWithAnySupport(Builder builder) {
        this.metadata = builder.metadata == null || builder.metadata.isEmpty() ? Collections.emptyMap() : Map.copyOf(builder.metadata);
    }

    @JsonAnyGetter
    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    protected static abstract class Builder {
        protected Map<String, Object> metadata;

        protected Builder() {
        }

        @JsonAnyGetter
        public Map<String, Object> getMetadata() {
            return this.metadata == null ? (this.metadata = new HashMap<String, Object>()) : this.metadata;
        }

        public Builder setMetadata(Map<String, Object> newValues) {
            this.metadata = JsonBuilder.modifiableMapOrNull(newValues, HashMap::new);
            return this;
        }

        @JsonAnySetter
        public Builder setMetadata(String key, Object value) {
            this.getMetadata().put(key, value);
            return this;
        }

        public Builder removeMetadata(String key) {
            this.getMetadata().remove(key);
            return this;
        }
    }
}

