/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.elytron.security.common.runtime.graal;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import java.util.Arrays;
import org.wildfly.common.Assert;

@TargetClass(className="org.wildfly.security.password.interfaces.BCryptPassword")
public final class Target_org_wildfly_security_password_interfaces_BCryptPassword {
    @Substitute
    static Target_org_wildfly_security_password_interfaces_BCryptPassword createRaw(String algorithm, byte[] hash, byte[] salt, int iterationCount) {
        Assert.checkNotNullParam((String)"hash", (Object)hash);
        Assert.checkNotNullParam((String)"salt", (Object)salt);
        Assert.checkNotNullParam((String)"algorithm", (Object)algorithm);
        return (Target_org_wildfly_security_password_interfaces_BCryptPassword)((Object)new RawBCryptPassword(algorithm, Arrays.copyOf(hash, hash.length), Arrays.copyOf(salt, salt.length), iterationCount));
    }

    @TargetClass(className="org.wildfly.security.password.interfaces.RawBCryptPassword")
    private static final class RawBCryptPassword {
        @Alias
        RawBCryptPassword(String algorithm, byte[] hash, byte[] salt, int iterationCount) {
        }
    }
}

