/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.funqy.runtime.bindings.http;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import io.quarkus.arc.Arc;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.funqy.runtime.FunctionConstructor;
import io.quarkus.funqy.runtime.FunctionInvoker;
import io.quarkus.funqy.runtime.FunctionRecorder;
import io.quarkus.funqy.runtime.bindings.http.VertxRequestHandler;
import io.quarkus.funqy.runtime.query.QueryObjectMapper;
import io.quarkus.funqy.runtime.query.QueryReader;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.web.RoutingContext;
import java.lang.annotation.Annotation;
import java.util.concurrent.Executor;
import java.util.function.Supplier;

@Recorder
public class FunqyHttpBindingRecorder {
    private static ObjectMapper objectMapper;
    private static QueryObjectMapper queryMapper;

    public void init() {
        objectMapper = this.getObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true);
        queryMapper = new QueryObjectMapper();
        for (FunctionInvoker invoker : FunctionRecorder.registry.invokers()) {
            if (invoker.hasInput()) {
                JavaType javaInputType = objectMapper.constructType(invoker.getInputType());
                ObjectReader reader = objectMapper.readerFor(javaInputType);
                QueryReader queryReader = queryMapper.readerFor(invoker.getInputType());
                invoker.getBindingContext().put(ObjectReader.class.getName(), reader);
                invoker.getBindingContext().put(QueryReader.class.getName(), queryReader);
            }
            if (!invoker.hasOutput()) continue;
            JavaType javaOutputType = objectMapper.constructType(invoker.getOutputType());
            ObjectWriter writer = objectMapper.writerFor(javaOutputType);
            invoker.getBindingContext().put(ObjectWriter.class.getName(), writer);
        }
    }

    private ObjectMapper getObjectMapper() {
        InstanceHandle instance = Arc.container().instance(ObjectMapper.class, new Annotation[0]);
        if (instance.isAvailable()) {
            return ((ObjectMapper)instance.get()).copy();
        }
        return new ObjectMapper();
    }

    public Handler<RoutingContext> start(String contextPath, Supplier<Vertx> vertx, ShutdownContext shutdown, BeanContainer beanContainer, Executor executor) {
        shutdown.addShutdownTask(new Runnable(){

            @Override
            public void run() {
                FunctionConstructor.CONTAINER = null;
                objectMapper = null;
            }
        });
        FunctionConstructor.CONTAINER = beanContainer;
        return new VertxRequestHandler(vertx.get(), beanContainer, contextPath, executor);
    }
}

