/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.funqy.runtime.bindings.knative.events;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import io.netty.buffer.ByteBufInputStream;
import io.quarkus.arc.ManagedContext;
import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.funqy.knative.events.CloudEvent;
import io.quarkus.funqy.runtime.FunctionInvoker;
import io.quarkus.funqy.runtime.FunctionRecorder;
import io.quarkus.funqy.runtime.FunqyServerRequest;
import io.quarkus.funqy.runtime.FunqyServerResponse;
import io.quarkus.funqy.runtime.RequestContext;
import io.quarkus.funqy.runtime.RequestContextImpl;
import io.quarkus.funqy.runtime.bindings.knative.events.FunqyKnativeEventsConfig;
import io.quarkus.funqy.runtime.bindings.knative.events.FunqyRequestImpl;
import io.quarkus.funqy.runtime.bindings.knative.events.FunqyResponseImpl;
import io.quarkus.funqy.runtime.bindings.knative.events.HeaderCloudEventImpl;
import io.quarkus.funqy.runtime.bindings.knative.events.JsonCloudEventImpl;
import io.quarkus.funqy.runtime.query.QueryReader;
import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.vertx.http.runtime.CurrentVertxRequest;
import io.quarkus.vertx.http.runtime.security.QuarkusHttpUser;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executor;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.CDI;
import org.jboss.logging.Logger;

public class VertxRequestHandler
implements Handler<RoutingContext> {
    private static final Logger log = Logger.getLogger((String)"io.quarkus.funqy");
    protected final Vertx vertx;
    protected final ObjectMapper mapper;
    protected final BeanContainer beanContainer;
    protected final CurrentIdentityAssociation association;
    protected final CurrentVertxRequest currentVertxRequest;
    protected final Executor executor;
    protected final FunctionInvoker defaultInvoker;
    protected final Map<String, FunctionInvoker> typeTriggers;
    protected final String rootPath;
    private static final ResponseProcessing NOOP = () -> {};

    public VertxRequestHandler(Vertx vertx, String rootPath, BeanContainer beanContainer, ObjectMapper mapper, FunqyKnativeEventsConfig config, FunctionInvoker defaultInvoker, Map<String, FunctionInvoker> typeTriggers, Executor executor) {
        this.rootPath = rootPath;
        this.defaultInvoker = defaultInvoker;
        this.vertx = vertx;
        this.beanContainer = beanContainer;
        this.executor = executor;
        this.mapper = mapper;
        this.typeTriggers = typeTriggers;
        Instance association = CDI.current().select(CurrentIdentityAssociation.class, new Annotation[0]);
        this.association = association.isResolvable() ? (CurrentIdentityAssociation)association.get() : null;
        this.currentVertxRequest = (CurrentVertxRequest)CDI.current().select(CurrentVertxRequest.class, new Annotation[0]).get();
    }

    public void handle(RoutingContext routingContext) {
        String mediaType = routingContext.request().getHeader("Content-Type");
        if (mediaType == null || mediaType.startsWith("application/json") || mediaType.trim().equals("")) {
            if (routingContext.request().getHeader("ce-id") != null) {
                this.binaryContentMode(routingContext);
            } else {
                this.regularFunqyHttp(routingContext);
            }
        } else if (mediaType.startsWith("application/cloudevents+json")) {
            this.structuredMode(routingContext);
        } else {
            if (mediaType.startsWith("application/cloudevents-batch+json")) {
                routingContext.fail(406);
                log.error((Object)"Batch mode not supported yet");
                return;
            }
            routingContext.fail(406);
            log.error((Object)("Illegal media type:" + mediaType));
            return;
        }
    }

    private void regularFunqyHttp(RoutingContext routingContext) {
        String path = routingContext.request().path();
        if (path == null) {
            routingContext.fail(404);
            return;
        }
        if (!path.startsWith(this.rootPath)) {
            routingContext.fail(404);
            return;
        }
        FunctionInvoker invoker = !(path = path.substring(this.rootPath.length())).isEmpty() ? FunctionRecorder.registry.matchInvoker(path) : this.defaultInvoker;
        this.processHttpRequest(null, routingContext, NOOP, invoker);
    }

    private void binaryContentMode(RoutingContext routingContext) {
        String ceType = routingContext.request().getHeader("ce-type");
        FunctionInvoker invoker = this.defaultInvoker;
        if (invoker == null && (invoker = this.typeTriggers.get(ceType)) == null) {
            routingContext.fail(404);
            log.error((Object)("Could not map ce-type header: " + ceType + " to a function"));
            return;
        }
        FunctionInvoker targetInvoker = invoker;
        this.processHttpRequest(new HeaderCloudEventImpl(routingContext.request()), routingContext, () -> {
            routingContext.response().putHeader("ce-id", this.getResponseId());
            routingContext.response().putHeader("ce-specversion", "1.0");
            routingContext.response().putHeader("ce-source", (String)targetInvoker.getBindingContext().get("response.cloud.event.source"));
            routingContext.response().putHeader("ce-type", (String)targetInvoker.getBindingContext().get("response.cloud.event.type"));
        }, invoker);
    }

    private void processHttpRequest(CloudEvent event, RoutingContext routingContext, ResponseProcessing handler, FunctionInvoker invoker) {
        if (routingContext.request().method() == HttpMethod.GET) {
            Object input = null;
            if (invoker.hasInput()) {
                QueryReader reader = (QueryReader)invoker.getBindingContext().get(QueryReader.class.getName());
                try {
                    input = reader.readValue(routingContext.request().params().iterator());
                }
                catch (Exception e) {
                    log.error((Object)"Failed to unmarshal input", (Throwable)e);
                    routingContext.fail(400);
                    return;
                }
            }
            try {
                this.execute(event, routingContext, handler, invoker, input);
            }
            catch (Throwable t) {
                log.error((Object)t);
                routingContext.fail(500, t);
            }
        } else if (routingContext.request().method() == HttpMethod.POST) {
            routingContext.request().bodyHandler(buff -> {
                try {
                    Object input = null;
                    if (buff.length() > 0) {
                        ByteBufInputStream in = new ByteBufInputStream(buff.getByteBuf());
                        ObjectReader reader = (ObjectReader)invoker.getBindingContext().get(ObjectReader.class.getName());
                        try {
                            input = reader.readValue((InputStream)in);
                        }
                        catch (JsonProcessingException e) {
                            log.error((Object)"Failed to unmarshal input", (Throwable)e);
                            routingContext.fail(400);
                            return;
                        }
                    }
                    this.execute(event, routingContext, handler, invoker, input);
                }
                catch (Throwable t) {
                    log.error((Object)t);
                    routingContext.fail(500, t);
                }
            });
        } else {
            routingContext.fail(405);
            log.error((Object)("Must be POST or GET for: " + invoker.getName()));
        }
    }

    private void execute(CloudEvent event, RoutingContext routingContext, ResponseProcessing handler, FunctionInvoker invoker, Object finalInput) {
        this.executor.execute(() -> {
            try {
                HttpServerResponse httpResponse = routingContext.response();
                FunqyServerResponse response = this.dispatch(event, routingContext, invoker, finalInput);
                response.getOutput().emitOn(this.executor).subscribe().with(obj -> {
                    if (invoker.hasOutput()) {
                        try {
                            httpResponse.setStatusCode(200);
                            handler.handle();
                            ObjectWriter writer = (ObjectWriter)invoker.getBindingContext().get(ObjectWriter.class.getName());
                            httpResponse.putHeader("Content-Type", "application/json");
                            httpResponse.end(writer.writeValueAsString(obj));
                        }
                        catch (JsonProcessingException jpe) {
                            log.error((Object)"Failed to unmarshal input", (Throwable)jpe);
                            routingContext.fail(400);
                        }
                        catch (Throwable e) {
                            routingContext.fail(e);
                        }
                    } else {
                        httpResponse.setStatusCode(204);
                        httpResponse.end();
                    }
                }, t -> routingContext.fail(t));
            }
            catch (Throwable t2) {
                log.error((Object)t2);
                routingContext.fail(500, t2);
            }
        });
    }

    private void structuredMode(RoutingContext routingContext) {
        if (routingContext.request().method() != HttpMethod.POST) {
            routingContext.fail(405);
            log.error((Object)"Must be POST method");
            return;
        }
        routingContext.request().bodyHandler(buff -> {
            try {
                String eventType;
                JsonNode event;
                ByteBufInputStream in = new ByteBufInputStream(buff.getByteBuf());
                Object input = null;
                try {
                    event = this.mapper.reader().readTree((InputStream)in);
                }
                catch (JsonProcessingException e) {
                    log.error((Object)"Failed to unmarshal input", (Throwable)e);
                    routingContext.fail(400);
                    return;
                }
                FunctionInvoker invoker = this.defaultInvoker;
                if (invoker == null && (invoker = this.typeTriggers.get(eventType = event.get("type").asText())) == null) {
                    routingContext.fail(404);
                    log.error((Object)("Could not map json cloud event to function: " + eventType));
                    return;
                }
                FunctionInvoker targetInvoker = invoker;
                if (invoker.hasInput()) {
                    JsonNode dct = event.get("datacontenttype");
                    if (dct == null) {
                        routingContext.fail(400);
                        return;
                    }
                    String type = dct.asText();
                    if (type != null) {
                        if (!type.equals("application/json")) {
                            routingContext.fail(406);
                            log.error((Object)"Illegal datacontenttype");
                            return;
                        }
                        JsonNode data = event.get("data");
                        if (data != null) {
                            ObjectReader reader = (ObjectReader)invoker.getBindingContext().get(ObjectReader.class.getName());
                            try {
                                input = reader.readValue(data);
                            }
                            catch (JsonProcessingException e) {
                                log.error((Object)"Failed to unmarshal input", (Throwable)e);
                                routingContext.fail(400);
                                return;
                            }
                        }
                    }
                }
                Object finalInput = input;
                this.executor.execute(() -> {
                    try {
                        HttpServerResponse httpResponse = routingContext.response();
                        FunqyServerResponse response = this.dispatch(new JsonCloudEventImpl(event), routingContext, targetInvoker, finalInput);
                        response.getOutput().emitOn(this.executor).subscribe().with(obj -> {
                            if (targetInvoker.hasOutput()) {
                                httpResponse.setStatusCode(200);
                                HashMap<String, Object> responseEvent = new HashMap<String, Object>();
                                responseEvent.put("id", this.getResponseId());
                                responseEvent.put("specversion", "1.0");
                                responseEvent.put("source", targetInvoker.getBindingContext().get("response.cloud.event.source"));
                                responseEvent.put("type", targetInvoker.getBindingContext().get("response.cloud.event.type"));
                                responseEvent.put("datacontenttype", "application/json");
                                responseEvent.put("data", obj);
                                try {
                                    httpResponse.end(this.mapper.writer().writeValueAsString(responseEvent));
                                }
                                catch (JsonProcessingException e) {
                                    log.error((Object)"Failed to marshal", (Throwable)e);
                                    routingContext.fail(400);
                                }
                            } else {
                                httpResponse.setStatusCode(204);
                                httpResponse.end();
                            }
                        }, t -> routingContext.fail(t));
                    }
                    catch (Throwable t2) {
                        log.error((Object)t2);
                        routingContext.fail(500, t2);
                    }
                });
            }
            catch (Throwable t) {
                log.error((Object)t);
                routingContext.fail(500, t);
            }
        });
    }

    private String getResponseId() {
        return UUID.randomUUID().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FunqyServerResponse dispatch(CloudEvent event, RoutingContext routingContext, FunctionInvoker invoker, Object input) {
        ManagedContext requestContext = this.beanContainer.requestContext();
        requestContext.activate();
        if (this.association != null) {
            QuarkusHttpUser existing = (QuarkusHttpUser)routingContext.user();
            if (existing != null) {
                SecurityIdentity identity = existing.getSecurityIdentity();
                this.association.setIdentity(identity);
            } else {
                this.association.setIdentity(QuarkusHttpUser.getSecurityIdentity((RoutingContext)routingContext, null));
            }
        }
        this.currentVertxRequest.setCurrent(routingContext);
        try {
            RequestContextImpl funqContext = new RequestContextImpl();
            if (event != null) {
                funqContext.setContextData(CloudEvent.class, (Object)event);
            }
            FunqyRequestImpl funqyRequest = new FunqyRequestImpl((RequestContext)funqContext, input);
            FunqyResponseImpl funqyResponse = new FunqyResponseImpl();
            invoker.invoke((FunqyServerRequest)funqyRequest, (FunqyServerResponse)funqyResponse);
            FunqyResponseImpl funqyResponseImpl = funqyResponse;
            return funqyResponseImpl;
        }
        finally {
            if (requestContext.isActive()) {
                requestContext.terminate();
            }
        }
    }

    @FunctionalInterface
    static interface ResponseProcessing {
        public void handle();
    }
}

