/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.runtime.supports;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.vertx.core.Context;
import io.vertx.core.Vertx;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.spi.Prioritized;

@ApplicationScoped
public class IOThreadClientInterceptor
implements ClientInterceptor,
Prioritized {
    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        final Context context = Vertx.currentContext();
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                super.start((ClientCall.Listener)new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                    public void onMessage(RespT message) {
                        if (context != null) {
                            context.runOnContext(unused -> super.onMessage(message));
                        } else {
                            super.onMessage(message);
                        }
                    }
                }, headers);
            }
        };
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }
}

