/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.runtime.supports;

import io.grpc.ForwardingServerCall;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import io.quarkus.arc.Arc;
import io.quarkus.arc.ManagedContext;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import org.jboss.logmanager.Logger;

public class RequestScopeHandlerInterceptor
implements ServerInterceptor {
    private final ManagedContext reqContext = Arc.container().requestContext();
    private static final Logger LOGGER = Logger.getLogger((String)RequestScopeHandlerInterceptor.class.getName());

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        final Context capturedVertxContext = Vertx.currentContext();
        if (capturedVertxContext != null) {
            boolean activateAndDeactivateContext;
            boolean bl = activateAndDeactivateContext = !this.reqContext.isActive();
            if (activateAndDeactivateContext) {
                this.reqContext.activate();
            }
            return next.startCall((ServerCall)new ForwardingServerCall.SimpleForwardingServerCall<ReqT, RespT>(call){

                public void close(Status status, Metadata trailers) {
                    super.close(status, trailers);
                    if (activateAndDeactivateContext) {
                        capturedVertxContext.runOnContext((Handler)new Handler<Void>(){

                            public void handle(Void ignored) {
                                RequestScopeHandlerInterceptor.this.reqContext.deactivate();
                            }
                        });
                    }
                }
            }, headers);
        }
        LOGGER.warning("Unable to activate the request scope - interceptor not called on the Vert.x event loop");
        return next.startCall(call, headers);
    }
}

