/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.deployment;

import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigRoot;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;

@ConfigRoot
public class HibernateOrmConfig {
    @ConfigItem
    public Optional<String> dialect;
    @ConfigItem(name="dialect.storage-engine")
    public Optional<String> dialectStorageEngine;
    @ConfigItem(defaultValueDocumentation="import.sql in DEV, TEST ; no-file otherwise")
    public Optional<String> sqlLoadScript;
    @ConfigItem(defaultValue="-1")
    public int batchFetchSize;
    @ConfigItem
    public Optional<String> physicalNamingStrategy;
    @ConfigItem
    public Optional<String> implicitNamingStrategy;
    @ConfigItem
    public Optional<String> multitenant;
    @ConfigItem
    public Optional<String> multitenantSchemaDatasource;
    @ConfigItem
    public HibernateOrmConfigQuery query;
    @ConfigItem
    public HibernateOrmConfigDatabase database;
    @ConfigItem
    public HibernateOrmConfigJdbc jdbc;
    @ConfigItem
    public HibernateOrmConfigLog log;
    public Map<String, HibernateOrmConfigCache> cache;
    @ConfigItem
    public Optional<Boolean> statistics;
    @ConfigItem(name="metrics.enabled")
    public boolean metricsEnabled;
    @ConfigItem(defaultValue="true")
    public boolean secondLevelCachingEnabled;

    public boolean isAnyPropertySet() {
        return this.dialect.isPresent() || this.dialectStorageEngine.isPresent() || this.sqlLoadScript.isPresent() || this.batchFetchSize > 0 || this.statistics.isPresent() || this.query.isAnyPropertySet() || this.database.isAnyPropertySet() || this.jdbc.isAnyPropertySet() || this.log.isAnyPropertySet() || this.multitenant.isPresent() || this.multitenantSchemaDatasource.isPresent() || !this.cache.isEmpty();
    }

    @ConfigGroup
    public static class HibernateOrmConfigCacheMemory {
        @ConfigItem
        public OptionalLong objectCount;
    }

    @ConfigGroup
    public static class HibernateOrmConfigCacheExpiration {
        @ConfigItem
        public Optional<Duration> maxIdle;
    }

    @ConfigGroup
    public static class HibernateOrmConfigCache {
        @ConfigItem
        public HibernateOrmConfigCacheExpiration expiration;
        @ConfigItem
        public HibernateOrmConfigCacheMemory memory;
    }

    @ConfigGroup
    public static class HibernateOrmConfigLog {
        @ConfigItem
        public boolean sql;
        @ConfigItem
        public boolean bindParam;
        @ConfigItem(defaultValueDocumentation="depends on dialect")
        public Optional<Boolean> jdbcWarnings;

        public boolean isAnyPropertySet() {
            return this.sql || this.bindParam || this.jdbcWarnings.isPresent();
        }
    }

    @ConfigGroup
    public static class HibernateOrmConfigJdbc {
        @ConfigItem
        public Optional<String> timezone;
        @ConfigItem
        public OptionalInt statementFetchSize;
        @ConfigItem
        public OptionalInt statementBatchSize;

        public boolean isAnyPropertySet() {
            return this.timezone.isPresent() || this.statementFetchSize.isPresent() || this.statementBatchSize.isPresent();
        }
    }

    @ConfigGroup
    public static class HibernateOrmConfigDatabase {
        private static final String DEFAULT_CHARSET = "UTF-8";
        @ConfigItem(defaultValue="none")
        public String generation;
        @ConfigItem(name="generation.halt-on-error")
        public boolean generationHaltOnError;
        @ConfigItem
        public Optional<String> defaultCatalog;
        @ConfigItem
        public Optional<String> defaultSchema;
        @ConfigItem(defaultValue="UTF-8")
        public Charset charset;
        @ConfigItem
        public boolean globallyQuotedIdentifiers;

        public boolean isAnyPropertySet() {
            return !"none".equals(this.generation) || this.defaultCatalog.isPresent() || this.defaultSchema.isPresent() || this.generationHaltOnError || !DEFAULT_CHARSET.equals(this.charset.name()) || this.globallyQuotedIdentifiers;
        }
    }

    @ConfigGroup
    public static class HibernateOrmConfigQuery {
        @ConfigItem
        public Optional<String> queryPlanCacheMaxSize;
        @ConfigItem
        public Optional<String> defaultNullOrdering;

        public boolean isAnyPropertySet() {
            return this.queryPlanCacheMaxSize.isPresent() || this.defaultNullOrdering.isPresent();
        }
    }
}

