/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.reactive.panache;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.quarkus.hibernate.reactive.panache.PanacheQuery;
import io.quarkus.hibernate.reactive.panache.runtime.JpaOperations;
import io.quarkus.panache.common.Parameters;
import io.quarkus.panache.common.Sort;
import io.quarkus.panache.common.impl.GenerateBridge;
import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Uni;
import jakarta.json.bind.annotation.JsonbTransient;
import jakarta.persistence.LockModeType;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.hibernate.reactive.mutiny.Mutiny;

public abstract class PanacheEntityBase {
    public static Uni<Mutiny.Session> getSession() {
        return JpaOperations.INSTANCE.getSession();
    }

    @CheckReturnValue
    public <T extends PanacheEntityBase> Uni<T> persist() {
        return JpaOperations.INSTANCE.persist(this).map(v -> this);
    }

    @CheckReturnValue
    public <T extends PanacheEntityBase> Uni<T> persistAndFlush() {
        return JpaOperations.INSTANCE.persist(this).flatMap(v -> JpaOperations.INSTANCE.flush()).map(v -> this);
    }

    @CheckReturnValue
    public Uni<Void> delete() {
        return JpaOperations.INSTANCE.delete(this);
    }

    @JsonbTransient
    @JsonIgnore
    public boolean isPersistent() {
        return JpaOperations.INSTANCE.isPersistent(this);
    }

    @CheckReturnValue
    public Uni<Void> flush() {
        return JpaOperations.INSTANCE.flush();
    }

    @GenerateBridge
    public static <T extends PanacheEntityBase> Uni<T> findById(Object id) {
        throw JpaOperations.INSTANCE.implementationInjectionMissing();
    }

    @CheckReturnValue
    @GenerateBridge
    public static <T extends PanacheEntityBase> Uni<T> findById(Object id, LockModeType lockModeType) {
        throw JpaOperations.INSTANCE.implementationInjectionMissing();
    }

    @GenerateBridge
    public static <T extends PanacheEntityBase> PanacheQuery<T> find(String query, Object ... params) {
        throw JpaOperations.INSTANCE.implementationInjectionMissing();
    }

    @GenerateBridge
    public static <T extends PanacheEntityBase> PanacheQuery<T> find(String query, Sort sort, Object ... params) {
        throw JpaOperations.INSTANCE.implementationInjectionMissing();
    }

    @GenerateBridge
    public static <T extends PanacheEntityBase> PanacheQuery<T> find(String query, Map<String, Object> params) {
        throw JpaOperations.INSTANCE.implementationInjectionMissing();
    }

    @GenerateBridge
    public static <T extends PanacheEntityBase> PanacheQuery<T> find(String query, Sort sort, Map<String, Object> params) {
        throw JpaOperations.INSTANCE.implementationInjectionMissing();
    }

    @GenerateBridge
    public static <T extends PanacheEntityBase> PanacheQuery<T> find(String query, Parameters params) {
        throw JpaOperations.INSTANCE.implementationInjectionMissing();
    }

    @GenerateBridge
    public static <T extends PanacheEntityBase> PanacheQuery<T> find(String query, Sort sort, Parameters params) {
        throw JpaOperations.INSTANCE.implementationInjectionMissing();
    }

    @GenerateBridge
    public static <T extends PanacheEntityBase> PanacheQuery<T> findAll() {
        throw JpaOperations.INSTANCE.implementationInjectionMissing();
    }

    @GenerateBridge
    public static <T extends PanacheEntityBase> PanacheQuery<T> findAll(Sort sort) {
        throw JpaOperations.INSTANCE.implementationInjectionMissing();
    }

    @CheckReturnValue
    @GenerateBridge
    public static <T extends PanacheEntityBase> Uni<List<T>> list(String query, Object ... params) {
        throw JpaOperations.INSTANCE.implementationInjectionMissing();
    }

    @CheckReturnValue
    @GenerateBridge
    public static <T extends PanacheEntityBase> Uni<List<T>> list(String query, Sort sort, Object ... params) {
        throw JpaOperations.INSTANCE.implementationInjectionMissing();
    }

    @CheckReturnValue
    @GenerateBridge
    public static <T extends PanacheEntityBase> Uni<List<T>> list(String query, Map<String, Object> params) {
        throw JpaOperations.INSTANCE.implementationInjectionMissing();
    }

    @CheckReturnValue
    @GenerateBridge
    public static <T extends PanacheEntityBase> Uni<List<T>> list(String query, Sort sort, Map<String, Object> params) {
        throw JpaOperations.INSTANCE.implementationInjectionMissing();
    }

    @CheckReturnValue
    @GenerateBridge
    public static <T extends PanacheEntityBase> Uni<List<T>> list(String query, Parameters params) {
        throw JpaOperations.INSTANCE.implementationInjectionMissing();
    }

    @CheckReturnValue
    @GenerateBridge
    public static <T extends PanacheEntityBase> Uni<List<T>> list(String query, Sort sort, Parameters params) {
        throw JpaOperations.INSTANCE.implementationInjectionMissing();
    }

    @CheckReturnValue
    @GenerateBridge
    public static <T extends PanacheEntityBase> Uni<List<T>> listAll() {
        throw JpaOperations.INSTANCE.implementationInjectionMissing();
    }

    @CheckReturnValue
    @GenerateBridge
    public static <T extends PanacheEntityBase> Uni<List<T>> listAll(Sort sort) {
        throw JpaOperations.INSTANCE.implementationInjectionMissing();
    }

    @CheckReturnValue
    @GenerateBridge
    public static Uni<Long> count() {
        throw JpaOperations.INSTANCE.implementationInjectionMissing();
    }

    @CheckReturnValue
    @GenerateBridge
    public static Uni<Long> count(String query, Object ... params) {
        throw JpaOperations.INSTANCE.implementationInjectionMissing();
    }

    @CheckReturnValue
    @GenerateBridge
    public static Uni<Long> count(String query, Map<String, Object> params) {
        throw JpaOperations.INSTANCE.implementationInjectionMissing();
    }

    @CheckReturnValue
    @GenerateBridge
    public static Uni<Long> count(String query, Parameters params) {
        throw JpaOperations.INSTANCE.implementationInjectionMissing();
    }

    @CheckReturnValue
    @GenerateBridge
    public static Uni<Long> deleteAll() {
        throw JpaOperations.INSTANCE.implementationInjectionMissing();
    }

    @CheckReturnValue
    @GenerateBridge
    public static Uni<Boolean> deleteById(Object id) {
        throw JpaOperations.INSTANCE.implementationInjectionMissing();
    }

    @CheckReturnValue
    @GenerateBridge
    public static Uni<Long> delete(String query, Object ... params) {
        throw JpaOperations.INSTANCE.implementationInjectionMissing();
    }

    @CheckReturnValue
    @GenerateBridge
    public static Uni<Long> delete(String query, Map<String, Object> params) {
        throw JpaOperations.INSTANCE.implementationInjectionMissing();
    }

    @CheckReturnValue
    @GenerateBridge
    public static Uni<Long> delete(String query, Parameters params) {
        throw JpaOperations.INSTANCE.implementationInjectionMissing();
    }

    @CheckReturnValue
    @GenerateBridge(callSuperMethod=true)
    public static Uni<Void> persist(Iterable<?> entities) {
        return JpaOperations.INSTANCE.persist(entities);
    }

    @CheckReturnValue
    @GenerateBridge(callSuperMethod=true)
    public static Uni<Void> persist(Stream<?> entities) {
        return JpaOperations.INSTANCE.persist(entities);
    }

    @CheckReturnValue
    @GenerateBridge(callSuperMethod=true)
    public static Uni<Void> persist(Object firstEntity, Object ... entities) {
        return JpaOperations.INSTANCE.persist(firstEntity, entities);
    }

    @CheckReturnValue
    @GenerateBridge
    public static Uni<Integer> update(String query, Object ... params) {
        throw JpaOperations.INSTANCE.implementationInjectionMissing();
    }

    @CheckReturnValue
    @GenerateBridge
    public static Uni<Integer> update(String query, Map<String, Object> params) {
        throw JpaOperations.INSTANCE.implementationInjectionMissing();
    }

    @CheckReturnValue
    @GenerateBridge
    public static Uni<Integer> update(String query, Parameters params) {
        throw JpaOperations.INSTANCE.implementationInjectionMissing();
    }
}

