/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cache.infinispan.runtime;

import io.quarkus.cache.CacheManager;
import io.quarkus.cache.CacheManagerInfo;
import io.quarkus.cache.infinispan.runtime.InfinispanCacheImpl;
import io.quarkus.cache.infinispan.runtime.InfinispanCacheInfo;
import io.quarkus.cache.infinispan.runtime.InfinispanCacheInfoBuilder;
import io.quarkus.cache.infinispan.runtime.InfinispanCachesBuildTimeConfig;
import io.quarkus.cache.infinispan.runtime.InfinispanCachesConfig;
import io.quarkus.cache.runtime.CacheManagerImpl;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.function.Supplier;
import org.jboss.logging.Logger;

@Recorder
public class InfinispanCacheBuildRecorder {
    private static final Logger LOGGER = Logger.getLogger(InfinispanCacheBuildRecorder.class);
    private final InfinispanCachesBuildTimeConfig buildConfig;
    private final RuntimeValue<InfinispanCachesConfig> infinispanCacheConfigRV;

    public InfinispanCacheBuildRecorder(InfinispanCachesBuildTimeConfig buildConfig, RuntimeValue<InfinispanCachesConfig> infinispanCacheConfigRV) {
        this.buildConfig = buildConfig;
        this.infinispanCacheConfigRV = infinispanCacheConfigRV;
    }

    public CacheManagerInfo getCacheManagerSupplier() {
        return new CacheManagerInfo(){

            public boolean supports(CacheManagerInfo.Context context) {
                return context.cacheEnabled() && "infinispan".equals(context.cacheType());
            }

            public Supplier<CacheManager> get(final CacheManagerInfo.Context context) {
                return new Supplier<CacheManager>(){

                    @Override
                    public CacheManager get() {
                        Set<InfinispanCacheInfo> cacheInfos = InfinispanCacheInfoBuilder.build(context.cacheNames(), InfinispanCacheBuildRecorder.this.buildConfig, (InfinispanCachesConfig)InfinispanCacheBuildRecorder.this.infinispanCacheConfigRV.getValue());
                        if (cacheInfos.isEmpty()) {
                            return new CacheManagerImpl(Collections.emptyMap());
                        }
                        HashMap<String, InfinispanCacheImpl> caches = new HashMap<String, InfinispanCacheImpl>(cacheInfos.size() + 1, 1.0f);
                        for (InfinispanCacheInfo cacheInfo : cacheInfos) {
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debugf("Building Infinispan cache [%s] with [lifespan=%s], [maxIdle=%s]", (Object)cacheInfo.name, cacheInfo.lifespan, cacheInfo.maxIdle);
                            }
                            InfinispanCacheImpl cache = new InfinispanCacheImpl(cacheInfo, InfinispanCacheBuildRecorder.this.buildConfig.clientName);
                            caches.put(cacheInfo.name, cache);
                        }
                        return new CacheManagerImpl(caches);
                    }
                };
            }
        };
    }
}

