/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit;

import io.quarkus.bootstrap.app.AugmentAction;
import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.app.QuarkusBootstrap;
import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.bootstrap.resolver.AppModelResolverException;
import io.quarkus.bootstrap.runner.Timing;
import io.quarkus.bootstrap.utils.BuildToolHelper;
import io.quarkus.bootstrap.workspace.ArtifactSources;
import io.quarkus.bootstrap.workspace.SourceDir;
import io.quarkus.bootstrap.workspace.WorkspaceModule;
import io.quarkus.deployment.dev.testing.CurrentTestApplication;
import io.quarkus.paths.PathCollection;
import io.quarkus.paths.PathList;
import io.quarkus.test.common.PathTestHelper;
import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.common.RestorableSystemProperties;
import io.quarkus.test.common.TestClassIndexer;
import io.quarkus.test.junit.AbstractQuarkusTestWithContextExtension;
import io.quarkus.test.junit.QuarkusTestExtension;
import io.quarkus.test.junit.QuarkusTestProfile;
import io.quarkus.test.junit.TestProfile;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.enterprise.inject.Alternative;
import org.jboss.jandex.Index;
import org.junit.jupiter.api.extension.ExtensionContext;

public class AbstractJvmQuarkusTestExtension
extends AbstractQuarkusTestWithContextExtension {
    protected static final String TEST_LOCATION = "test-location";
    protected static final String TEST_CLASS = "test-class";
    protected ClassLoader originalCl;
    protected static Class<? extends QuarkusTestProfile> quarkusTestProfile;
    protected static final Deque<Class<?>> currentTestClassStack;
    protected static Class<?> currentJUnitTestClass;

    /*
     * WARNING - void declaration
     */
    protected PrepareResult createAugmentor(ExtensionContext context, Class<? extends QuarkusTestProfile> profile, Collection<Runnable> shutdownTasks) throws Exception {
        void var12_15;
        CuratedApplication curatedApplication;
        Path testClassLocation;
        Class requiredTestClass;
        PathList.Builder rootBuilder = PathList.builder();
        Consumer<Path> addToBuilderIfConditionMet = path -> {
            if (path != null && Files.exists(path, new LinkOption[0]) && !rootBuilder.contains(path)) {
                rootBuilder.add(path);
            }
        };
        currentJUnitTestClass = requiredTestClass = context.getRequiredTestClass();
        Path projectRoot = Paths.get("", new String[0]).normalize().toAbsolutePath();
        ApplicationModel gradleAppModel = this.getGradleAppModelForIDE(projectRoot);
        if (gradleAppModel != null && gradleAppModel.getApplicationModule() != null) {
            WorkspaceModule module = gradleAppModel.getApplicationModule();
            String string = requiredTestClass.getName().replace('.', '/') + ".class";
            Path testClassesDir = null;
            for (Object classifier : module.getSourceClassifiers()) {
                ArtifactSources sources = module.getSources((String)classifier);
                if (!sources.isOutputAvailable() || !sources.getOutputTree().contains(string)) continue;
                for (SourceDir src : sources.getSourceDirs()) {
                    addToBuilderIfConditionMet.accept(src.getOutputDir());
                    if (!Files.exists(src.getOutputDir().resolve(string), new LinkOption[0])) continue;
                    testClassesDir = src.getOutputDir();
                }
                for (SourceDir src : sources.getResourceDirs()) {
                    addToBuilderIfConditionMet.accept(src.getOutputDir());
                }
                for (SourceDir src : module.getMainSources().getSourceDirs()) {
                    addToBuilderIfConditionMet.accept(src.getOutputDir());
                }
                for (SourceDir src : module.getMainSources().getResourceDirs()) {
                    addToBuilderIfConditionMet.accept(src.getOutputDir());
                }
            }
            if (testClassesDir == null) {
                StringBuilder sb = new StringBuilder();
                sb.append("Failed to locate ").append(requiredTestClass.getName()).append(" in ");
                for (String classifier : module.getSourceClassifiers()) {
                    ArtifactSources sources = module.getSources(classifier);
                    if (!sources.isOutputAvailable()) continue;
                    for (SourceDir d : sources.getSourceDirs()) {
                        if (!Files.exists(d.getOutputDir(), new LinkOption[0])) continue;
                        sb.append(System.lineSeparator()).append(d.getOutputDir());
                    }
                }
                throw new RuntimeException(sb.toString());
            }
            testClassLocation = testClassesDir;
        } else {
            Path appClassLocation;
            if (System.getProperty("OUTPUT_SOURCES_DIR") != null) {
                String[] sourceDirectories;
                for (String sourceDirectory : sourceDirectories = System.getProperty("OUTPUT_SOURCES_DIR").split(",")) {
                    Path directory = Paths.get(sourceDirectory, new String[0]);
                    addToBuilderIfConditionMet.accept(directory);
                }
            }
            if (!(appClassLocation = PathTestHelper.getAppClassLocationForTestLocation((String)(testClassLocation = PathTestHelper.getTestClassesLocation((Class)requiredTestClass)).toString())).equals(testClassLocation)) {
                addToBuilderIfConditionMet.accept(testClassLocation);
                Path testResourcesLocation = PathTestHelper.getResourcesForClassesDirOrNull((Path)testClassLocation, (String)"test");
                addToBuilderIfConditionMet.accept(testResourcesLocation);
            }
            addToBuilderIfConditionMet.accept(appClassLocation);
            Path appResourcesLocation = PathTestHelper.getResourcesForClassesDirOrNull((Path)appClassLocation, (String)"main");
            addToBuilderIfConditionMet.accept(appResourcesLocation);
        }
        this.originalCl = Thread.currentThread().getContextClassLoader();
        System.clearProperty("test.url");
        HashMap<String, String> additional = new HashMap<String, String>();
        Object var12_13 = null;
        if (profile != null) {
            QuarkusTestProfile quarkusTestProfile = profile.getConstructor(new Class[0]).newInstance(new Object[0]);
            additional.putAll(quarkusTestProfile.getConfigOverrides());
            if (!quarkusTestProfile.getEnabledAlternatives().isEmpty()) {
                additional.put("quarkus.arc.selected-alternatives", quarkusTestProfile.getEnabledAlternatives().stream().peek(c -> {
                    if (!c.isAnnotationPresent(Alternative.class)) {
                        throw new RuntimeException("Enabled alternative " + c + " is not annotated with @Alternative");
                    }
                }).map(Class::getName).collect(Collectors.joining(",")));
            }
            if (quarkusTestProfile.disableApplicationLifecycleObservers()) {
                additional.put("quarkus.arc.test.disable-application-lifecycle-observers", "true");
            }
            if (quarkusTestProfile.getConfigProfile() != null) {
                additional.put("quarkus.test.profile", quarkusTestProfile.getConfigProfile());
            }
            shutdownTasks.add(() -> ((RestorableSystemProperties)RestorableSystemProperties.setProperties(additional, (String[])new String[0])).close());
        }
        if (CurrentTestApplication.curatedApplication != null) {
            curatedApplication = CurrentTestApplication.curatedApplication;
        } else {
            curatedApplication = QuarkusBootstrap.builder().setIsolateDeployment(true).setMode(QuarkusBootstrap.Mode.TEST).setTest(true).setTargetDirectory(PathTestHelper.getProjectBuildDir((Path)projectRoot, (Path)testClassLocation)).setProjectRoot(projectRoot).setApplicationRoot((PathCollection)rootBuilder.build()).build().bootstrap();
            shutdownTasks.add(() -> ((CuratedApplication)curatedApplication).close());
        }
        if (curatedApplication.getApplicationModel().getRuntimeDependencies().isEmpty()) {
            throw new RuntimeException("The tests were run against a directory that does not contain a Quarkus project. Please ensure that the test is configured to use the proper working directory.");
        }
        Index testClassesIndex = TestClassIndexer.indexTestClasses((Path)testClassLocation);
        TestClassIndexer.writeIndex((Index)testClassesIndex, (Path)testClassLocation, (Class)requiredTestClass);
        Timing.staticInitStarted((ClassLoader)curatedApplication.getBaseRuntimeClassLoader(), (boolean)curatedApplication.getQuarkusBootstrap().isAuxiliaryApplication());
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put(TEST_LOCATION, testClassLocation);
        props.put(TEST_CLASS, requiredTestClass);
        quarkusTestProfile = profile;
        return new PrepareResult(curatedApplication.createAugmentor(QuarkusTestExtension.TestBuildChainFunction.class.getName(), props), (QuarkusTestProfile)var12_15, curatedApplication, testClassLocation);
    }

    private ApplicationModel getGradleAppModelForIDE(Path projectRoot) throws IOException, AppModelResolverException {
        return System.getProperty("quarkus-internal-test.serialized-app-model.path") == null ? BuildToolHelper.enableGradleAppModelForTest((Path)projectRoot) : null;
    }

    protected Class<? extends QuarkusTestProfile> getQuarkusTestProfile(ExtensionContext extensionContext) {
        for (Class<?> testClass = extensionContext.getRequiredTestClass(); testClass != null; testClass = testClass.getEnclosingClass()) {
            TestProfile annotation = testClass.getAnnotation(TestProfile.class);
            if (annotation == null) continue;
            return annotation.value();
        }
        return null;
    }

    protected static boolean hasPerTestResources(ExtensionContext extensionContext) {
        return AbstractJvmQuarkusTestExtension.hasPerTestResources(extensionContext.getRequiredTestClass());
    }

    public static boolean hasPerTestResources(Class<?> requiredTestClass) {
        while (requiredTestClass != Object.class) {
            for (QuarkusTestResource quarkusTestResource : (QuarkusTestResource[])requiredTestClass.getAnnotationsByType(QuarkusTestResource.class)) {
                if (!quarkusTestResource.restrictToAnnotatedClass()) continue;
                return true;
            }
            for (Annotation annotation : requiredTestClass.getAnnotations()) {
                if (annotation.annotationType() == QuarkusTestResource.class || ((QuarkusTestResource[])annotation.annotationType().getAnnotationsByType(QuarkusTestResource.class)).length <= 0) continue;
                return true;
            }
            requiredTestClass = requiredTestClass.getSuperclass();
        }
        return false;
    }

    static {
        currentTestClassStack = new ArrayDeque();
    }

    protected static class PrepareResult {
        protected final AugmentAction augmentAction;
        protected final QuarkusTestProfile profileInstance;
        protected final CuratedApplication curatedApplication;
        protected final Path testClassLocation;

        public PrepareResult(AugmentAction augmentAction, QuarkusTestProfile profileInstance, CuratedApplication curatedApplication, Path testClassLocation) {
            this.augmentAction = augmentAction;
            this.profileInstance = profileInstance;
            this.curatedApplication = curatedApplication;
            this.testClassLocation = testClassLocation;
        }
    }
}

