/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit.internal;

import io.quarkus.bootstrap.app.RunningQuarkusApplication;
import io.quarkus.test.junit.internal.DeepClone;
import io.quarkus.test.junit.internal.TestInfoImpl;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.lang.reflect.Method;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.jboss.marshalling.cloner.ClassCloner;
import org.jboss.marshalling.cloner.ClonerConfiguration;
import org.jboss.marshalling.cloner.ObjectCloner;
import org.jboss.marshalling.cloner.ObjectCloners;
import org.junit.jupiter.api.TestInfo;

public final class NewSerializingDeepClone
implements DeepClone {
    private final ObjectCloner cloner;
    private static Pattern clonePattern;
    private RunningQuarkusApplication runningQuarkusApplication;

    public NewSerializingDeepClone(ClassLoader sourceLoader, final ClassLoader targetLoader) {
        ClonerConfiguration cc = new ClonerConfiguration();
        cc.setSerializabilityChecker(clazz -> clazz != Object.class);
        cc.setClassCloner(new ClassCloner(){

            public Class<?> clone(Class<?> original) {
                if (NewSerializingDeepClone.isUncloneable(original)) {
                    return original;
                }
                try {
                    return targetLoader.loadClass(original.getName());
                }
                catch (ClassNotFoundException ignored) {
                    return original;
                }
            }

            public Class<?> cloneProxy(Class<?> proxyClass) {
                return proxyClass;
            }
        });
        cc.setCloneTable((original, objectCloner, classCloner) -> {
            Class<?> theClassWeCareAbout = original.getClass();
            while (theClassWeCareAbout.isArray()) {
                theClassWeCareAbout = theClassWeCareAbout.getComponentType();
            }
            if (!clonePattern.matcher(theClassWeCareAbout.getName()).matches()) {
                if (theClassWeCareAbout.isPrimitive()) {
                    return original;
                }
                if (NewSerializingDeepClone.isUncloneable(theClassWeCareAbout)) {
                    if (original instanceof Supplier) {
                        Supplier s = (Supplier)original;
                        return () -> this.lambda$new$1((Supplier)s);
                    }
                    return original;
                }
                if (original instanceof TestInfo) {
                    TestInfo info = (TestInfo)original;
                    return new TestInfoImpl(info.getDisplayName(), info.getTags(), info.getTestClass().map(this::cloneClass), info.getTestMethod().map(this::cloneMethod));
                }
                try {
                    if (this.runningQuarkusApplication != null && this.runningQuarkusApplication.getClassLoader().loadClass(theClassWeCareAbout.getName()) == theClassWeCareAbout) {
                        return original;
                    }
                }
                catch (ClassNotFoundException e) {
                    if (original instanceof Supplier) {
                        Supplier s = (Supplier)original;
                        return () -> this.lambda$new$2((Supplier)s);
                    }
                    throw e;
                }
                if (original == sourceLoader) {
                    return targetLoader;
                }
            }
            return null;
        });
        this.cloner = ObjectCloners.getSerializingObjectClonerFactory().createCloner(cc);
    }

    private static boolean isUncloneable(Class<?> clazz) {
        return clazz.isHidden() && !Serializable.class.isAssignableFrom(clazz);
    }

    private Class<?> cloneClass(Class<?> clazz) {
        try {
            return (Class)this.cloner.clone(clazz);
        }
        catch (IOException | ClassNotFoundException e) {
            return null;
        }
    }

    private Method cloneMethod(Method method) {
        try {
            Class declaring = (Class)this.cloner.clone(method.getDeclaringClass());
            Class[] argTypes = (Class[])this.cloner.clone(method.getParameterTypes());
            return declaring.getDeclaredMethod(method.getName(), argTypes);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Object clone(Object objectToClone) {
        try {
            return this.cloner.clone(objectToClone);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void setRunningQuarkusApplication(RunningQuarkusApplication runningQuarkusApplication) {
        this.runningQuarkusApplication = runningQuarkusApplication;
        String patternString = runningQuarkusApplication.getConfigValue("quarkus.test.class-clone-pattern", String.class).orElse("java\\..*");
        clonePattern = Pattern.compile(patternString);
    }

    private /* synthetic */ Object lambda$new$2(Supplier s) {
        return this.clone(s.get());
    }

    private /* synthetic */ Object lambda$new$1(Supplier s) {
        return this.clone(s.get());
    }
}

