/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.keycloak.pep.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.keycloak.pep.PolicyEnforcerResolver;
import io.quarkus.keycloak.pep.runtime.DefaultPolicyEnforcerResolver;
import io.quarkus.keycloak.pep.runtime.VertxHttpFacade;
import io.quarkus.oidc.AccessTokenCredential;
import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.runtime.BlockingOperationControl;
import io.quarkus.runtime.BlockingOperationNotAllowedException;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.runtime.QuarkusSecurityIdentity;
import io.quarkus.security.spi.runtime.BlockingSecurityExecutor;
import io.quarkus.vertx.http.runtime.CurrentVertxRequest;
import io.quarkus.vertx.http.runtime.security.HttpSecurityPolicy;
import io.smallrye.mutiny.Uni;
import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.security.Permission;
import java.util.function.Function;
import java.util.function.Supplier;
import org.keycloak.AuthorizationContext;
import org.keycloak.adapters.authorization.PolicyEnforcer;
import org.keycloak.adapters.authorization.spi.HttpRequest;
import org.keycloak.adapters.authorization.spi.HttpResponse;
import org.keycloak.authorization.client.AuthzClient;
import org.keycloak.representations.adapters.config.PolicyEnforcerConfig;

@Singleton
public class KeycloakPolicyEnforcerAuthorizer
implements HttpSecurityPolicy {
    private static final String PERMISSIONS_ATTRIBUTE = "permissions";
    private static final String POLICY_ENFORCER = "io.quarkus.keycloak.pep.runtime.KeycloakPolicyEnforcerAuthorizer#POLICY_ENFORCER";
    @Inject
    PolicyEnforcerResolver resolver;
    @Inject
    Instance<SecurityIdentity> identityInstance;
    @Inject
    BlockingSecurityExecutor blockingExecutor;

    public Uni<HttpSecurityPolicy.CheckResult> checkPermission(final RoutingContext routingContext, Uni<SecurityIdentity> identity, HttpSecurityPolicy.AuthorizationRequestContext requestContext) {
        return identity.flatMap((Function)new Function<SecurityIdentity, Uni<? extends HttpSecurityPolicy.CheckResult>>(){

            @Override
            public Uni<? extends HttpSecurityPolicy.CheckResult> apply(final SecurityIdentity identity) {
                if (identity.isAnonymous()) {
                    return KeycloakPolicyEnforcerAuthorizer.this.resolver.resolvePolicyEnforcer(routingContext, null).flatMap((Function)new Function<PolicyEnforcer, Uni<? extends HttpSecurityPolicy.CheckResult>>(){

                        @Override
                        public Uni<HttpSecurityPolicy.CheckResult> apply(final PolicyEnforcer policyEnforcer) {
                            KeycloakPolicyEnforcerAuthorizer.storePolicyEnforcerOnContext(policyEnforcer, routingContext);
                            return KeycloakPolicyEnforcerAuthorizer.this.blockingExecutor.executeBlocking((Supplier)new Supplier<PolicyEnforcerConfig.PathConfig>(){

                                @Override
                                public PolicyEnforcerConfig.PathConfig get() {
                                    return policyEnforcer.getPathMatcher().matches(routingContext.normalizedPath());
                                }
                            }).flatMap((Function)new Function<PolicyEnforcerConfig.PathConfig, Uni<? extends HttpSecurityPolicy.CheckResult>>(){

                                @Override
                                public Uni<HttpSecurityPolicy.CheckResult> apply(PolicyEnforcerConfig.PathConfig pathConfig) {
                                    if (pathConfig != null && pathConfig.getEnforcementMode() == PolicyEnforcerConfig.EnforcementMode.ENFORCING) {
                                        return HttpSecurityPolicy.CheckResult.deny();
                                    }
                                    return KeycloakPolicyEnforcerAuthorizer.this.checkPermissionInternal(routingContext, identity);
                                }
                            });
                        }
                    });
                }
                return KeycloakPolicyEnforcerAuthorizer.this.checkPermissionInternal(routingContext, identity);
            }
        });
    }

    @Produces
    @RequestScoped
    public AuthzClient getAuthzClient() {
        DefaultPolicyEnforcerResolver defaultResolver;
        SecurityIdentity identity = (SecurityIdentity)this.identityInstance.get();
        RoutingContext routingContext = identity.getAttribute(RoutingContext.class.getName()) != null ? (RoutingContext)identity.getAttribute(RoutingContext.class.getName()) : ((CurrentVertxRequest)Arc.container().instance(CurrentVertxRequest.class, new Annotation[0]).get()).getCurrent();
        if (routingContext != null && routingContext.get(POLICY_ENFORCER) != null) {
            return ((PolicyEnforcer)routingContext.get(POLICY_ENFORCER)).getAuthzClient();
        }
        if (BlockingOperationControl.isBlockingAllowed()) {
            OidcTenantConfig tenantConfig = routingContext == null ? null : (OidcTenantConfig)routingContext.get(OidcTenantConfig.class.getName());
            return ((PolicyEnforcer)this.resolver.resolvePolicyEnforcer(routingContext, tenantConfig).await().indefinitely()).getAuthzClient();
        }
        PolicyEnforcerResolver policyEnforcerResolver = this.resolver;
        if (policyEnforcerResolver instanceof DefaultPolicyEnforcerResolver && !(defaultResolver = (DefaultPolicyEnforcerResolver)policyEnforcerResolver).hasDynamicPolicyEnforcers()) {
            return defaultResolver.getStaticPolicyEnforcer((String)identity.getAttribute("tenant-id")).getAuthzClient();
        }
        throw new BlockingOperationNotAllowedException("You have attempted to inject AuthzClient on a IO thread.\nThis is not allowed when PolicyEnforcer is resolved dynamically as blocking operations are required.\nMake sure you are injecting AuthzClient from a worker thread.\n");
    }

    private Uni<HttpSecurityPolicy.CheckResult> checkPermissionInternal(final RoutingContext routingContext, final SecurityIdentity identity) {
        AccessTokenCredential credential = (AccessTokenCredential)identity.getCredential(AccessTokenCredential.class);
        if (credential == null) {
            return HttpSecurityPolicy.CheckResult.permit();
        }
        final VertxHttpFacade httpFacade = new VertxHttpFacade(routingContext, credential.getToken(), this.resolver.getReadTimeout());
        return this.resolver.resolvePolicyEnforcer(routingContext, (OidcTenantConfig)routingContext.get(OidcTenantConfig.class.getName())).flatMap((Function)new Function<PolicyEnforcer, Uni<? extends AuthorizationContext>>(){

            @Override
            public Uni<AuthorizationContext> apply(final PolicyEnforcer policyEnforcer) {
                KeycloakPolicyEnforcerAuthorizer.storePolicyEnforcerOnContext(policyEnforcer, routingContext);
                return KeycloakPolicyEnforcerAuthorizer.this.blockingExecutor.executeBlocking((Supplier)new Supplier<AuthorizationContext>(){

                    @Override
                    public AuthorizationContext get() {
                        return policyEnforcer.enforce((HttpRequest)httpFacade, (HttpResponse)httpFacade);
                    }
                });
            }
        }).map((Function)new Function<AuthorizationContext, HttpSecurityPolicy.CheckResult>(){

            @Override
            public HttpSecurityPolicy.CheckResult apply(AuthorizationContext authorizationContext) {
                if (authorizationContext.isGranted()) {
                    return new HttpSecurityPolicy.CheckResult(true, KeycloakPolicyEnforcerAuthorizer.enhanceSecurityIdentity(identity, authorizationContext));
                }
                return HttpSecurityPolicy.CheckResult.DENY;
            }
        });
    }

    private static void storePolicyEnforcerOnContext(PolicyEnforcer policyEnforcer, RoutingContext routingContext) {
        routingContext.put(POLICY_ENFORCER, (Object)policyEnforcer);
    }

    private static SecurityIdentity enhanceSecurityIdentity(SecurityIdentity current, final AuthorizationContext context) {
        return QuarkusSecurityIdentity.builder((SecurityIdentity)current).addAttribute(PERMISSIONS_ATTRIBUTE, (Object)context.getPermissions()).addPermissionChecker((Function)new Function<Permission, Uni<Boolean>>(){

            @Override
            public Uni<Boolean> apply(Permission permission) {
                String scopes = permission.getActions();
                if (scopes == null || scopes.isEmpty()) {
                    return Uni.createFrom().item((Object)context.hasResourcePermission(permission.getName()));
                }
                for (String scope : scopes.split(",")) {
                    if (context.hasPermission(permission.getName(), scope)) continue;
                    return Uni.createFrom().item((Object)false);
                }
                return Uni.createFrom().item((Object)true);
            }
        }).build();
    }
}

