/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment;

import io.quarkus.kubernetes.deployment.KnativeConfig;
import io.quarkus.kubernetes.deployment.KubernetesConfig;
import io.quarkus.kubernetes.deployment.OpenShiftConfig;
import io.smallrye.config.ConfigMappingInterface;
import io.smallrye.config.ConfigMappingLoader;
import io.smallrye.config.ConfigSourceInterceptor;
import io.smallrye.config.ConfigSourceInterceptorContext;
import io.smallrye.config.ConfigSourceInterceptorFactory;
import io.smallrye.config.ConfigValue;
import io.smallrye.config.FallbackConfigSourceInterceptor;
import io.smallrye.config.NameIterator;
import io.smallrye.config.ProfileConfigSourceInterceptor;
import io.smallrye.config.PropertyName;
import io.smallrye.config.RelocateConfigSourceInterceptor;
import io.smallrye.config.SmallRyeConfigBuilder;
import io.smallrye.config.SmallRyeConfigBuilderCustomizer;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Function;

public class KubernetesConfigBuilderCustomizer
implements SmallRyeConfigBuilderCustomizer {
    private static final Comparator<ConfigValue> CONFIG_SOURCE_COMPARATOR = new Comparator<ConfigValue>(){

        @Override
        public int compare(ConfigValue original, ConfigValue candidate) {
            int result = Integer.compare(original.getConfigSourceOrdinal(), candidate.getConfigSourceOrdinal());
            if (result != 0) {
                return result;
            }
            result = Integer.compare(original.getConfigSourcePosition(), candidate.getConfigSourcePosition()) * -1;
            if (result != 0) {
                return result;
            }
            if (original.getName().charAt(0) == '%' && candidate.getName().charAt(0) == '%') {
                List originalProfiles = ProfileConfigSourceInterceptor.convertProfile((String)new NameIterator(original.getName()).getNextSegment().substring(1));
                List candidateProfiles = ProfileConfigSourceInterceptor.convertProfile((String)new NameIterator(candidate.getName()).getNextSegment().substring(1));
                return Integer.compare(originalProfiles.size(), candidateProfiles.size()) * -1;
            }
            return result;
        }
    };

    public void configBuilder(SmallRyeConfigBuilder builder) {
        final Set<PropertyName> ignoreNames = KubernetesConfigBuilderCustomizer.ignoreNames();
        builder.withInterceptorFactories(new ConfigSourceInterceptorFactory[]{new ConfigSourceInterceptorFactory(){

            public ConfigSourceInterceptor getInterceptor(ConfigSourceInterceptorContext context) {
                return new Fallbacks(new Function<String, String>(){

                    @Override
                    public String apply(String name) {
                        if (name.startsWith("quarkus.openshift.") && !ignoreNames.contains(new PropertyName(name))) {
                            return "quarkus.kubernetes." + name.substring(18);
                        }
                        if (name.startsWith("quarkus.knative.") && !ignoreNames.contains(new PropertyName(name))) {
                            return "quarkus.kubernetes." + name.substring(16);
                        }
                        return name;
                    }
                }){

                    public Iterator<String> iterateNames(ConfigSourceInterceptorContext context) {
                        return context.iterateNames();
                    }
                };
            }

            public OptionalInt getPriority() {
                return OptionalInt.of(3590);
            }
        }});
        builder.withInterceptorFactories(new ConfigSourceInterceptorFactory[]{new ConfigSourceInterceptorFactory(){

            public ConfigSourceInterceptor getInterceptor(ConfigSourceInterceptorContext context) {
                return new RelocateConfigSourceInterceptor(new Function<String, String>(){

                    @Override
                    public String apply(String name) {
                        if (name.startsWith("quarkus.kubernetes.") && !ignoreNames.contains(new PropertyName(name))) {
                            return "quarkus.openshift." + name.substring(19);
                        }
                        return name;
                    }
                }){

                    public ConfigValue getValue(ConfigSourceInterceptorContext context, String name) {
                        return context.proceed(name);
                    }
                };
            }
        }});
        builder.withInterceptorFactories(new ConfigSourceInterceptorFactory[]{new ConfigSourceInterceptorFactory(){

            public ConfigSourceInterceptor getInterceptor(ConfigSourceInterceptorContext context) {
                return new RelocateConfigSourceInterceptor(new Function<String, String>(){

                    @Override
                    public String apply(String name) {
                        if (name.startsWith("quarkus.kubernetes.") && !ignoreNames.contains(new PropertyName(name))) {
                            return "quarkus.knative." + name.substring(19);
                        }
                        return name;
                    }
                }){

                    public ConfigValue getValue(ConfigSourceInterceptorContext context, String name) {
                        return context.proceed(name);
                    }
                };
            }
        }});
    }

    private static Set<PropertyName> ignoreNames() {
        Set kubernetes = ((Map)((Map)ConfigMappingInterface.getProperties((ConfigMappingInterface)ConfigMappingLoader.getConfigMapping(KubernetesConfig.class)).get(KubernetesConfig.class)).get("")).keySet();
        Set openshift = ((Map)((Map)ConfigMappingInterface.getProperties((ConfigMappingInterface)ConfigMappingLoader.getConfigMapping(OpenShiftConfig.class)).get(OpenShiftConfig.class)).get("")).keySet();
        Set knative = ((Map)((Map)ConfigMappingInterface.getProperties((ConfigMappingInterface)ConfigMappingLoader.getConfigMapping(KnativeConfig.class)).get(KnativeConfig.class)).get("")).keySet();
        HashSet<PropertyName> ignored = new HashSet<PropertyName>();
        for (String name : kubernetes) {
            if (openshift.contains(name) && knative.contains(name)) continue;
            ignored.add(new PropertyName("quarkus.kubernetes." + name));
            ignored.add(new PropertyName("quarkus.openshift." + name));
            ignored.add(new PropertyName("quarkus.knative." + name));
        }
        for (String name : openshift) {
            if (kubernetes.contains(name) && knative.contains(name)) continue;
            ignored.add(new PropertyName("quarkus.kubernetes." + name));
            ignored.add(new PropertyName("quarkus.openshift." + name));
            ignored.add(new PropertyName("quarkus.knative." + name));
        }
        for (String name : knative) {
            if (kubernetes.contains(name) && openshift.contains(name)) continue;
            ignored.add(new PropertyName("quarkus.kubernetes." + name));
            ignored.add(new PropertyName("quarkus.openshift." + name));
            ignored.add(new PropertyName("quarkus.knative." + name));
        }
        ignored.add(new PropertyName("quarkus.kubernetes.deploy"));
        ignored.add(new PropertyName("quarkus.openshift.deploy"));
        ignored.add(new PropertyName("quarkus.knative.deploy"));
        ignored.add(new PropertyName("quarkus.kubernetes.deploy-strategy"));
        ignored.add(new PropertyName("quarkus.openshift.deploy-strategy"));
        ignored.add(new PropertyName("quarkus.knative.deploy-strategy"));
        return ignored;
    }

    private static class Fallbacks
    extends FallbackConfigSourceInterceptor {
        public Fallbacks(Function<String, String> mapping) {
            super(mapping);
        }

        public ConfigValue getValue(ConfigSourceInterceptorContext context, String name) {
            ConfigValue configValue = context.proceed(name);
            String map = (String)this.getMapping().apply(name);
            if (name.equals(map)) {
                return configValue;
            }
            ConfigValue fallbackValue = context.restart(map);
            if (configValue != null && fallbackValue != null) {
                return CONFIG_SOURCE_COMPARATOR.compare(configValue, fallbackValue) >= 0 ? configValue : fallbackValue.withName(name);
            }
            if (configValue != null) {
                return configValue;
            }
            if (fallbackValue != null) {
                return fallbackValue.withName(name);
            }
            return null;
        }
    }
}

