/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.liquibase;

import io.quarkus.liquibase.runtime.LiquibaseConfig;
import java.io.Writer;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.Liquibase;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.ChangeSetStatus;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.RanChangeSet;
import liquibase.database.Database;
import liquibase.exception.LiquibaseException;
import liquibase.resource.ResourceAccessor;

public class LiquibaseContext
extends Liquibase
implements AutoCloseable {
    private LiquibaseConfig config;

    public LiquibaseContext(LiquibaseConfig config, ResourceAccessor resourceAccessor, Database database) {
        super(config.changeLog, resourceAccessor, database);
        this.config = config;
    }

    public LiquibaseConfig getConfiguration() {
        return this.config;
    }

    public String getChangeLog() {
        return this.config.changeLog;
    }

    public LabelExpression createLabels() {
        return new LabelExpression(this.config.labels);
    }

    public Contexts createContexts() {
        return new Contexts(this.config.contexts);
    }

    public List<ChangeSetStatus> getChangeSetStatuses() throws LiquibaseException {
        return this.getChangeSetStatuses(this.createContexts(), this.createLabels(), true);
    }

    public void update() throws LiquibaseException {
        this.update(this.createContexts(), this.createLabels());
    }

    public List<ChangeSet> listUnrunChangeSets() throws LiquibaseException {
        return this.listUnrunChangeSets(this.createContexts(), this.createLabels(), true);
    }

    public void update(String tag, Writer output) throws LiquibaseException {
        this.update(tag, this.createContexts(), this.createLabels(), output);
    }

    public void update(int changesToApply) throws LiquibaseException {
        this.update(changesToApply, this.createContexts(), this.createLabels());
    }

    public void update(int changesToApply, Writer output) throws LiquibaseException {
        this.update(changesToApply, this.createContexts(), this.createLabels(), output);
    }

    public void rollback(int changesToRollback, String rollbackScript, Writer output) throws LiquibaseException {
        this.rollback(changesToRollback, rollbackScript, this.createContexts(), this.createLabels(), output);
    }

    public void rollback(int changesToRollback, String rollbackScript) throws LiquibaseException {
        this.rollback(changesToRollback, rollbackScript, this.createContexts(), this.createLabels());
    }

    public void rollback(String tagToRollBackTo, String rollbackScript, Writer output) throws LiquibaseException {
        this.rollback(tagToRollBackTo, rollbackScript, this.createContexts(), this.createLabels(), output);
    }

    public void rollback(String tagToRollBackTo, String rollbackScript) throws LiquibaseException {
        this.rollback(tagToRollBackTo, rollbackScript, this.createContexts(), this.createLabels());
    }

    public void rollback(Date dateToRollBackTo, String rollbackScript, Writer output) throws LiquibaseException {
        this.rollback(dateToRollBackTo, rollbackScript, this.createContexts(), this.createLabels(), output);
    }

    public void rollback(Date dateToRollBackTo, String rollbackScript, Contexts contexts, LabelExpression labelExpression, Writer output) throws LiquibaseException {
        this.rollback(dateToRollBackTo, rollbackScript, this.createContexts(), this.createLabels());
    }

    public void rollback(Date dateToRollBackTo, String rollbackScript) throws LiquibaseException {
        this.rollback(dateToRollBackTo, rollbackScript, this.createContexts(), this.createLabels());
    }

    public void changeLogSync() throws LiquibaseException {
        this.changeLogSync(this.createContexts(), this.createLabels());
    }

    public void changeLogSync(Writer output) throws LiquibaseException {
        this.changeLogSync(this.createContexts(), this.createLabels(), output);
    }

    public void markNextChangeSetRan(Writer output) throws LiquibaseException {
        this.markNextChangeSetRan(this.createContexts(), this.createLabels(), output);
    }

    public void markNextChangeSetRan() throws LiquibaseException {
        this.markNextChangeSetRan(this.createContexts(), this.createLabels());
    }

    public void futureRollbackSQL(String tag, Writer output) throws LiquibaseException {
        this.futureRollbackSQL(tag, this.createContexts(), this.createLabels(), output);
    }

    public void futureRollbackSQL(Integer count, Writer output, boolean checkLiquibaseTables) throws LiquibaseException {
        this.futureRollbackSQL(count, this.createContexts(), this.createLabels(), output, checkLiquibaseTables);
    }

    public void updateTestingRollback() throws LiquibaseException {
        this.updateTestingRollback(null, this.createContexts(), this.createLabels());
    }

    public void checkLiquibaseTables(boolean updateExistingNullChecksums, DatabaseChangeLog databaseChangeLog) throws LiquibaseException {
        this.checkLiquibaseTables(updateExistingNullChecksums, databaseChangeLog, this.createContexts(), this.createLabels());
    }

    public void reportStatus(boolean verbose, Writer output) throws LiquibaseException {
        this.reportStatus(verbose, this.createContexts(), this.createLabels(), output);
    }

    public Collection<RanChangeSet> listUnexpectedChangeSets() throws LiquibaseException {
        return this.listUnexpectedChangeSets(this.createContexts(), this.createLabels());
    }

    public void reportUnexpectedChangeSets(boolean verbose, Writer output) throws LiquibaseException {
        this.reportUnexpectedChangeSets(verbose, this.createContexts(), this.createLabels(), output);
    }

    @Override
    public void close() throws LiquibaseException {
        if (this.getDatabase() != null) {
            this.getDatabase().close();
        }
    }
}

