/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.liquibase.runtime;

import io.agroal.api.AgroalDataSource;
import io.quarkus.agroal.runtime.DataSources;
import io.quarkus.arc.Arc;
import io.quarkus.arc.InjectableInstance;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.liquibase.LiquibaseFactory;
import io.quarkus.liquibase.runtime.LiquibaseFactoryProducer;
import io.quarkus.runtime.annotations.Recorder;
import java.lang.annotation.Annotation;
import java.util.function.Supplier;
import javax.enterprise.inject.Any;
import javax.sql.DataSource;
import liquibase.Liquibase;

@Recorder
public class LiquibaseRecorder {
    public Supplier<LiquibaseFactory> liquibaseSupplier(String dataSourceName) {
        AgroalDataSource dataSource = DataSources.fromName((String)dataSourceName);
        LiquibaseFactoryProducer liquibaseProducer = (LiquibaseFactoryProducer)Arc.container().instance(LiquibaseFactoryProducer.class, new Annotation[0]).get();
        final LiquibaseFactory liquibaseFactory = liquibaseProducer.createLiquibaseFactory((DataSource)dataSource, dataSourceName);
        return new Supplier<LiquibaseFactory>(){

            @Override
            public LiquibaseFactory get() {
                return liquibaseFactory;
            }
        };
    }

    public void doStartActions() {
        try {
            InjectableInstance liquibaseFactoryInstance = Arc.container().select(LiquibaseFactory.class, new Annotation[]{Any.Literal.INSTANCE});
            if (liquibaseFactoryInstance.isUnsatisfied()) {
                return;
            }
            for (InstanceHandle liquibaseFactoryHandle : liquibaseFactoryInstance.handles()) {
                Throwable throwable;
                Liquibase liquibase;
                LiquibaseFactory liquibaseFactory = (LiquibaseFactory)liquibaseFactoryHandle.get();
                if (liquibaseFactory.getConfiguration().cleanAtStart) {
                    liquibase = liquibaseFactory.createLiquibase();
                    throwable = null;
                    try {
                        liquibase.dropAll();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (liquibase != null) {
                            if (throwable != null) {
                                try {
                                    liquibase.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                liquibase.close();
                            }
                        }
                    }
                }
                if (!liquibaseFactory.getConfiguration().migrateAtStart) continue;
                if (liquibaseFactory.getConfiguration().validateOnMigrate) {
                    liquibase = liquibaseFactory.createLiquibase();
                    throwable = null;
                    try {
                        liquibase.validate();
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (liquibase != null) {
                            if (throwable != null) {
                                try {
                                    liquibase.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                liquibase.close();
                            }
                        }
                    }
                }
                liquibase = liquibaseFactory.createLiquibase();
                throwable = null;
                try {
                    liquibase.update(liquibaseFactory.createContexts(), liquibaseFactory.createLabels());
                }
                catch (Throwable throwable6) {
                    throwable = throwable6;
                    throw throwable6;
                }
                finally {
                    if (liquibase == null) continue;
                    if (throwable != null) {
                        try {
                            liquibase.close();
                        }
                        catch (Throwable throwable7) {
                            throwable.addSuppressed(throwable7);
                        }
                        continue;
                    }
                    liquibase.close();
                }
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Error starting Liquibase", e);
        }
    }
}

