/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.logging.json.runtime;

import io.quarkus.logging.json.runtime.AdditionalFieldConfig;
import io.quarkus.logging.json.runtime.JsonFormatter;
import io.quarkus.logging.json.runtime.JsonLogConfig;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Formatter;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logmanager.PropertyValues;
import org.jboss.logmanager.formatters.StructuredFormatter;

@Recorder
public class LoggingJsonRecorder {
    public RuntimeValue<Optional<Formatter>> initializeConsoleJsonLogging(JsonLogConfig config) {
        return this.getFormatter(config.consoleJson);
    }

    public RuntimeValue<Optional<Formatter>> initializeFileJsonLogging(JsonLogConfig config) {
        return this.getFormatter(config.fileJson);
    }

    public RuntimeValue<Optional<Formatter>> initializeSyslogJsonLogging(JsonLogConfig config) {
        return this.getFormatter(config.syslogJson);
    }

    public RuntimeValue<Optional<Formatter>> initializeSocketJsonLogging(JsonLogConfig config) {
        return this.getFormatter(config.socketJson);
    }

    private RuntimeValue<Optional<Formatter>> getFormatter(JsonLogConfig.JsonConfig config) {
        if (config.logFormat == JsonLogConfig.JsonConfig.LogFormat.ECS) {
            this.addEcsFieldOverrides(config);
        }
        return this.getDefaultFormatter(config);
    }

    private RuntimeValue<Optional<Formatter>> getDefaultFormatter(JsonLogConfig.JsonConfig config) {
        if (!config.enable) {
            return new RuntimeValue(Optional.empty());
        }
        JsonFormatter formatter = config.keyOverrides.map(ko -> new JsonFormatter((String)ko)).orElse(new JsonFormatter());
        config.excludedKeys.ifPresent(ek -> formatter.setExcludedKeys((Set<String>)ek));
        Optional.ofNullable(config.additionalField).ifPresent(af -> formatter.setAdditionalFields((Map<String, AdditionalFieldConfig>)af));
        formatter.setPrettyPrint(config.prettyPrint);
        String dateFormat = config.dateFormat;
        if (!dateFormat.equals("default")) {
            formatter.setDateFormat(dateFormat);
        }
        formatter.setExceptionOutputType(config.exceptionOutputType);
        formatter.setPrintDetails(config.printDetails);
        config.recordDelimiter.ifPresent(arg_0 -> ((JsonFormatter)formatter).setRecordDelimiter(arg_0));
        String zoneId = config.zoneId;
        if (!zoneId.equals("default")) {
            formatter.setZoneId(zoneId);
        }
        return new RuntimeValue(Optional.of(formatter));
    }

    private void addEcsFieldOverrides(JsonLogConfig.JsonConfig config) {
        EnumMap keyOverrides = PropertyValues.stringToEnumMap(StructuredFormatter.Key.class, (String)config.keyOverrides.orElse(null));
        keyOverrides.putIfAbsent(StructuredFormatter.Key.TIMESTAMP, "@timestamp");
        keyOverrides.putIfAbsent(StructuredFormatter.Key.LOGGER_NAME, "log.logger");
        keyOverrides.putIfAbsent(StructuredFormatter.Key.LEVEL, "log.level");
        keyOverrides.putIfAbsent(StructuredFormatter.Key.PROCESS_ID, "process.pid");
        keyOverrides.putIfAbsent(StructuredFormatter.Key.PROCESS_NAME, "process.name");
        keyOverrides.putIfAbsent(StructuredFormatter.Key.THREAD_NAME, "process.thread.name");
        keyOverrides.putIfAbsent(StructuredFormatter.Key.THREAD_ID, "process.thread.id");
        keyOverrides.putIfAbsent(StructuredFormatter.Key.HOST_NAME, "host.hostname");
        keyOverrides.putIfAbsent(StructuredFormatter.Key.SEQUENCE, "event.sequence");
        keyOverrides.putIfAbsent(StructuredFormatter.Key.EXCEPTION_MESSAGE, "error.message");
        keyOverrides.putIfAbsent(StructuredFormatter.Key.STACK_TRACE, "error.stack_trace");
        config.keyOverrides = Optional.of(PropertyValues.mapToString((EnumMap)keyOverrides));
        config.additionalField.computeIfAbsent("ecs.version", k -> this.buildFieldConfig("1.12.2", AdditionalFieldConfig.Type.STRING));
        config.additionalField.computeIfAbsent("data_stream.type", k -> this.buildFieldConfig("logs", AdditionalFieldConfig.Type.STRING));
        Config quarkusConfig = ConfigProvider.getConfig();
        quarkusConfig.getOptionalValue("quarkus.application.name", String.class).ifPresent(s -> config.additionalField.computeIfAbsent("service.name", k -> this.buildFieldConfig((String)s, AdditionalFieldConfig.Type.STRING)));
        quarkusConfig.getOptionalValue("quarkus.application.version", String.class).ifPresent(s -> config.additionalField.computeIfAbsent("service.version", k -> this.buildFieldConfig((String)s, AdditionalFieldConfig.Type.STRING)));
        quarkusConfig.getOptionalValue("quarkus.profile", String.class).ifPresent(s -> config.additionalField.computeIfAbsent("service.environment", k -> this.buildFieldConfig((String)s, AdditionalFieldConfig.Type.STRING)));
        Set excludedKeys = config.excludedKeys.orElseGet(HashSet::new);
        excludedKeys.add(StructuredFormatter.Key.LOGGER_CLASS_NAME.getKey());
        excludedKeys.add(StructuredFormatter.Key.RECORD.getKey());
        config.excludedKeys = Optional.of(excludedKeys);
    }

    private AdditionalFieldConfig buildFieldConfig(String value, AdditionalFieldConfig.Type type) {
        AdditionalFieldConfig field = new AdditionalFieldConfig();
        field.type = type;
        field.value = value;
        return field;
    }
}

