/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.reactivemessaging.deployment;

import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.quarkus.smallrye.reactivemessaging.deployment.ReactiveMessagingDotNames;
import io.quarkus.smallrye.reactivemessaging.runtime.QuarkusMediatorConfiguration;
import io.quarkus.smallrye.reactivemessaging.runtime.QuarkusParameterDescriptor;
import io.quarkus.smallrye.reactivemessaging.runtime.ReactiveMessagingConfiguration;
import io.quarkus.smallrye.reactivemessaging.runtime.TypeInfo;
import io.smallrye.reactive.messaging.MethodParameterDescriptor;
import io.smallrye.reactive.messaging.Shape;
import io.smallrye.reactive.messaging.annotations.Merge;
import io.smallrye.reactive.messaging.providers.MediatorConfigurationSupport;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.microprofile.reactive.messaging.Acknowledgment;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;

public final class QuarkusMediatorConfigurationUtil {
    private QuarkusMediatorConfigurationUtil() {
    }

    public static QuarkusMediatorConfiguration create(final MethodInfo methodInfo, boolean isSuspendMethod, BeanInfo bean, RecorderContext recorderContext, ClassLoader cl, boolean strict, ReactiveMessagingConfiguration.ExecutionMode executionMode) {
        JandexGenericTypeAssignable genericReturnTypeAssignable;
        Class returnTypeClass;
        Class[] parameterTypeClasses;
        if (isSuspendMethod) {
            parameterTypeClasses = new Class[methodInfo.parametersCount() - 1];
            for (i = 0; i < methodInfo.parametersCount() - 1; ++i) {
                parameterTypeClasses[i] = QuarkusMediatorConfigurationUtil.load(methodInfo.parameterType(i).name().toString(), cl);
            }
            returnTypeClass = CompletionStage.class;
            genericReturnTypeAssignable = new JandexGenericTypeAssignable(QuarkusMediatorConfigurationUtil.determineReturnTypeOfSuspendMethod(methodInfo), cl);
        } else {
            parameterTypeClasses = new Class[methodInfo.parametersCount()];
            for (i = 0; i < methodInfo.parametersCount(); ++i) {
                parameterTypeClasses[i] = QuarkusMediatorConfigurationUtil.load(methodInfo.parameterType(i).name().toString(), cl);
            }
            returnTypeClass = QuarkusMediatorConfigurationUtil.load(methodInfo.returnType().name().toString(), cl);
            genericReturnTypeAssignable = new ReturnTypeGenericTypeAssignable(methodInfo, cl);
        }
        QuarkusMediatorConfiguration configuration = new QuarkusMediatorConfiguration();
        ArrayList<TypeInfo> gen = new ArrayList<TypeInfo>();
        for (int i = 0; i < methodInfo.parameterTypes().size(); ++i) {
            TypeInfo ti = new TypeInfo();
            org.jboss.jandex.Type type = (org.jboss.jandex.Type)methodInfo.parameterTypes().get(i);
            ti.setName(recorderContext.classProxy(type.name().toString()));
            List<Object> inner = new ArrayList();
            if (type.kind() == Type.Kind.PARAMETERIZED_TYPE) {
                inner = type.asParameterizedType().arguments().stream().map(t -> recorderContext.classProxy(t.name().toString())).collect(Collectors.toList());
            }
            ti.setGenerics(inner);
            gen.add(ti);
        }
        QuarkusParameterDescriptor descriptor = new QuarkusParameterDescriptor(gen);
        configuration.setParameterDescriptor((MethodParameterDescriptor)descriptor);
        QuarkusMediatorConfigurationUtil.handleKeyedMulti(methodInfo, recorderContext, configuration);
        MediatorConfigurationSupport mediatorConfigurationSupport = new MediatorConfigurationSupport(QuarkusMediatorConfigurationUtil.fullMethodName(methodInfo), returnTypeClass, parameterTypeClasses, (MediatorConfigurationSupport.GenericTypeAssignable)genericReturnTypeAssignable, (MediatorConfigurationSupport.GenericTypeAssignable)(methodInfo.parameterTypes().isEmpty() ? new AlwaysInvalidIndexGenericTypeAssignable() : new MethodParamGenericTypeAssignable(methodInfo, 0, cl)));
        if (strict) {
            mediatorConfigurationSupport.strict();
        }
        configuration.setBeanId(bean.getIdentifier());
        configuration.setMethodName(methodInfo.name());
        String returnTypeName = returnTypeClass.getName();
        configuration.setReturnType(recorderContext.classProxy(returnTypeName));
        ArrayList<String> incomingValues = new ArrayList<String>(QuarkusMediatorConfigurationUtil.getValues(methodInfo, ReactiveMessagingDotNames.INCOMING));
        incomingValues.addAll(QuarkusMediatorConfigurationUtil.getIncomingValues(methodInfo));
        configuration.setIncomings(incomingValues);
        ArrayList<String> outgoingValues = new ArrayList<String>(QuarkusMediatorConfigurationUtil.getValues(methodInfo, ReactiveMessagingDotNames.OUTGOING));
        outgoingValues.addAll(QuarkusMediatorConfigurationUtil.getOutgoingValues(methodInfo));
        configuration.setOutgoings(outgoingValues);
        Shape shape = mediatorConfigurationSupport.determineShape(incomingValues, outgoingValues);
        configuration.setShape(shape);
        Acknowledgment.Strategy acknowledgment = mediatorConfigurationSupport.processSuppliedAcknowledgement(incomingValues, () -> {
            AnnotationInstance instance = methodInfo.annotation(ReactiveMessagingDotNames.ACKNOWLEDGMENT);
            if (instance != null) {
                return Acknowledgment.Strategy.valueOf((String)instance.value().asEnum());
            }
            return null;
        });
        configuration.setAcknowledgment(acknowledgment);
        MediatorConfigurationSupport.ValidationOutput validationOutput = mediatorConfigurationSupport.validate(shape, acknowledgment);
        configuration.setProduction(validationOutput.getProduction());
        configuration.setConsumption(validationOutput.getConsumption());
        configuration.setIngestedPayloadType(validationOutput.getIngestedPayloadType());
        configuration.setUseBuilderTypes(validationOutput.getUseBuilderTypes());
        configuration.setUseReactiveStreams(validationOutput.getUseReactiveStreams());
        if (acknowledgment == null) {
            acknowledgment = mediatorConfigurationSupport.processDefaultAcknowledgement(shape, validationOutput.getConsumption(), validationOutput.getProduction());
            configuration.setAcknowledgment(acknowledgment);
        }
        configuration.setMerge(mediatorConfigurationSupport.processMerge(incomingValues, (Supplier)new Supplier<Merge.Mode>(){

            @Override
            public Merge.Mode get() {
                AnnotationInstance instance = methodInfo.annotation(ReactiveMessagingDotNames.MERGE);
                if (instance != null) {
                    AnnotationValue value = instance.value();
                    if (value == null) {
                        return Merge.Mode.MERGE;
                    }
                    return Merge.Mode.valueOf((String)value.asEnum());
                }
                return null;
            }
        }));
        configuration.setBroadcastValue(mediatorConfigurationSupport.processBroadcast(outgoingValues, (Supplier)new Supplier<Integer>(){

            @Override
            public Integer get() {
                AnnotationInstance instance = methodInfo.annotation(ReactiveMessagingDotNames.BROADCAST);
                if (instance != null) {
                    AnnotationValue value = instance.value();
                    if (value == null) {
                        return 0;
                    }
                    return value.asInt();
                }
                return null;
            }
        }));
        configuration.setHasTargetedOutput(mediatorConfigurationSupport.processTargetedOutput());
        if (!QuarkusMediatorConfigurationUtil.hasBlockingAnnotation(methodInfo) && !QuarkusMediatorConfigurationUtil.hasNonBlockingAnnotation(methodInfo) && QuarkusMediatorConfigurationUtil.hasBlockingPayloadSignature(methodInfo)) {
            switch (executionMode) {
                case WORKER: {
                    configuration.setBlocking(true);
                    configuration.setBlockingExecutionOrdered(true);
                    break;
                }
                case VIRTUAL_THREAD: {
                    configuration.setBlocking(true);
                    configuration.setWorkerPoolName("<virtual-thread>");
                    break;
                }
            }
        }
        AnnotationInstance blockingAnnotation = methodInfo.annotation(ReactiveMessagingDotNames.BLOCKING);
        AnnotationInstance smallryeBlockingAnnotation = methodInfo.annotation(ReactiveMessagingDotNames.SMALLRYE_BLOCKING);
        AnnotationInstance transactionalAnnotation = methodInfo.annotation(ReactiveMessagingDotNames.TRANSACTIONAL);
        AnnotationInstance runOnVirtualThreadAnnotation = methodInfo.annotation(ReactiveMessagingDotNames.RUN_ON_VIRTUAL_THREAD);
        AnnotationInstance runOnVirtualThreadClassAnnotation = methodInfo.declaringClass().declaredAnnotation(ReactiveMessagingDotNames.RUN_ON_VIRTUAL_THREAD);
        if (blockingAnnotation != null || smallryeBlockingAnnotation != null || transactionalAnnotation != null || runOnVirtualThreadAnnotation != null) {
            mediatorConfigurationSupport.validateBlocking(validationOutput);
            configuration.setBlocking(true);
            if (blockingAnnotation != null) {
                String poolName;
                AnnotationValue ordered = blockingAnnotation.value("ordered");
                if (runOnVirtualThreadAnnotation != null || runOnVirtualThreadClassAnnotation != null) {
                    if (ordered != null && ordered.asBoolean()) {
                        throw new ConfigurationException("The method `" + methodInfo.name() + "` is using `@RunOnVirtualThread` but explicitly set as `@Blocking(ordered = true)`");
                    }
                    configuration.setBlockingExecutionOrdered(false);
                    configuration.setWorkerPoolName("<virtual-thread>");
                } else {
                    configuration.setBlockingExecutionOrdered(ordered == null || ordered.asBoolean());
                }
                if (blockingAnnotation.value() != null && !(poolName = blockingAnnotation.value().asString()).equals("<no-value>")) {
                    configuration.setWorkerPoolName(poolName);
                }
            } else if (runOnVirtualThreadAnnotation != null || runOnVirtualThreadClassAnnotation != null) {
                configuration.setBlockingExecutionOrdered(false);
                configuration.setWorkerPoolName("<virtual-thread>");
            } else {
                configuration.setBlockingExecutionOrdered(true);
            }
        }
        return configuration;
    }

    private static void handleKeyedMulti(MethodInfo methodInfo, RecorderContext recorderContext, QuarkusMediatorConfiguration configuration) {
        if (methodInfo.parametersCount() == 1) {
            MethodParameterInfo info = (MethodParameterInfo)methodInfo.parameters().get(0);
            AnnotationInstance annotation = info.annotation(ReactiveMessagingDotNames.KEYED);
            if (annotation != null) {
                if (methodInfo.annotation(ReactiveMessagingDotNames.INCOMING) == null && methodInfo.annotation(ReactiveMessagingDotNames.INCOMINGS) == null) {
                    throw new ConfigurationException("The method `" + methodInfo.name() + "` is using `@Keyed` but is not annotated with `@Incoming`");
                }
                if (info.type().kind() != Type.Kind.PARAMETERIZED_TYPE || !info.type().asParameterizedType().name().equals((Object)ReactiveMessagingDotNames.KEYED_MULTI)) {
                    throw new ConfigurationException("The method `" + methodInfo.name() + "` is using `@Keyed` but the annotated parameter is not a `KeyedMulti`");
                }
                Class extractor = recorderContext.classProxy(annotation.value().asClass().name().toString());
                configuration.setKeyed(extractor);
            }
            if (info.type().kind() == Type.Kind.PARAMETERIZED_TYPE && info.type().asParameterizedType().name().equals((Object)ReactiveMessagingDotNames.KEYED_MULTI)) {
                List args = info.type().asParameterizedType().arguments();
                configuration.setKeyType((Type)recorderContext.classProxy(((org.jboss.jandex.Type)args.get(0)).name().toString()));
                configuration.setValueType((Type)recorderContext.classProxy(((org.jboss.jandex.Type)args.get(1)).name().toString()));
            }
        }
    }

    private static org.jboss.jandex.Type determineReturnTypeOfSuspendMethod(MethodInfo methodInfo) {
        org.jboss.jandex.Type lastParamType = methodInfo.parameterType(methodInfo.parametersCount() - 1);
        if (lastParamType.kind() != Type.Kind.PARAMETERIZED_TYPE) {
            throw new IllegalStateException("Something went wrong during parameter type resolution - expected " + lastParamType + " to be a Continuation with a generic type");
        }
        if ((lastParamType = (org.jboss.jandex.Type)lastParamType.asParameterizedType().arguments().get(0)).kind() != Type.Kind.WILDCARD_TYPE) {
            throw new IllegalStateException("Something went wrong during parameter type resolution - expected " + lastParamType + " to be a Continuation with a generic type");
        }
        if ((lastParamType = lastParamType.asWildcardType().superBound()).name().equals((Object)ReactiveMessagingDotNames.KOTLIN_UNIT)) {
            lastParamType = org.jboss.jandex.Type.create((DotName)ReactiveMessagingDotNames.VOID_CLASS, (Type.Kind)Type.Kind.CLASS);
        }
        lastParamType = ParameterizedType.create((DotName)ReactiveMessagingDotNames.COMPLETION_STAGE, (org.jboss.jandex.Type[])new org.jboss.jandex.Type[]{lastParamType}, (org.jboss.jandex.Type)org.jboss.jandex.Type.create((DotName)ReactiveMessagingDotNames.COMPLETION_STAGE, (Type.Kind)Type.Kind.CLASS));
        return lastParamType;
    }

    private static Class<?> load(String className, ClassLoader cl) {
        switch (className) {
            case "boolean": {
                return Boolean.TYPE;
            }
            case "byte": {
                return Byte.TYPE;
            }
            case "short": {
                return Short.TYPE;
            }
            case "int": {
                return Integer.TYPE;
            }
            case "long": {
                return Long.TYPE;
            }
            case "float": {
                return Float.TYPE;
            }
            case "double": {
                return Double.TYPE;
            }
            case "char": {
                return Character.TYPE;
            }
            case "void": {
                return Void.TYPE;
            }
        }
        try {
            return Class.forName(className, false, cl);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    private static String getValue(MethodInfo methodInfo, DotName dotName) {
        AnnotationInstance annotationInstance = methodInfo.annotation(dotName);
        String value = null;
        if (annotationInstance != null) {
            if (annotationInstance.value() != null) {
                value = annotationInstance.value().asString();
            }
            if (value == null || value.isEmpty()) {
                throw new IllegalArgumentException("@" + dotName.withoutPackagePrefix() + " value cannot be blank. Offending method is: " + QuarkusMediatorConfigurationUtil.fullMethodName(methodInfo));
            }
        }
        return value;
    }

    private static List<String> getValues(MethodInfo methodInfo, DotName dotName) {
        return methodInfo.annotations().stream().filter(ai -> ai.name().equals((Object)dotName)).map(ai -> ai.value().asString()).collect(Collectors.toList());
    }

    private static List<String> getIncomingValues(MethodInfo methodInfo) {
        return methodInfo.annotations().stream().filter(ai -> ai.name().equals((Object)ReactiveMessagingDotNames.INCOMINGS)).flatMap(incomings -> Arrays.stream(incomings.value().asNestedArray())).map(incoming -> incoming.value().asString()).collect(Collectors.toList());
    }

    private static List<String> getOutgoingValues(MethodInfo methodInfo) {
        return methodInfo.annotations().stream().filter(ai -> ai.name().equals((Object)ReactiveMessagingDotNames.OUTGOINGS)).flatMap(outgoings -> Arrays.stream(outgoings.value().asNestedArray())).map(outgoing -> outgoing.value().asString()).collect(Collectors.toList());
    }

    private static String fullMethodName(MethodInfo methodInfo) {
        return methodInfo.declaringClass() + "#" + methodInfo.name();
    }

    private static boolean hasNonBlockingAnnotation(MethodInfo method) {
        return method.hasAnnotation(ReactiveMessagingDotNames.NON_BLOCKING);
    }

    public static boolean hasBlockingAnnotation(MethodInfo method) {
        return method.hasAnnotation(ReactiveMessagingDotNames.BLOCKING) || method.hasAnnotation(ReactiveMessagingDotNames.SMALLRYE_BLOCKING) || method.hasAnnotation(ReactiveMessagingDotNames.RUN_ON_VIRTUAL_THREAD) || method.hasAnnotation(ReactiveMessagingDotNames.TRANSACTIONAL);
    }

    private static boolean hasBlockingPayloadSignature(MethodInfo methodInfo) {
        return !ReactiveMessagingDotNames.UNI.equals((Object)methodInfo.returnType().name()) && !ReactiveMessagingDotNames.MULTI.equals((Object)methodInfo.returnType().name()) && !ReactiveMessagingDotNames.COMPLETION_STAGE.equals((Object)methodInfo.returnType().name());
    }

    private static class JandexGenericTypeAssignable
    implements MediatorConfigurationSupport.GenericTypeAssignable {
        private final ClassLoader classLoader;
        private final org.jboss.jandex.Type type;

        public JandexGenericTypeAssignable(org.jboss.jandex.Type type, ClassLoader classLoader) {
            this.classLoader = classLoader;
            this.type = type;
        }

        public MediatorConfigurationSupport.GenericTypeAssignable.Result check(Class<?> target, int index) {
            if (this.type.kind() != Type.Kind.PARAMETERIZED_TYPE) {
                return MediatorConfigurationSupport.GenericTypeAssignable.Result.NotGeneric;
            }
            List arguments = this.type.asParameterizedType().arguments();
            if (arguments.size() >= index + 1) {
                Class<?> argumentClass = QuarkusMediatorConfigurationUtil.load(((org.jboss.jandex.Type)arguments.get(index)).name().toString(), this.classLoader);
                return target.isAssignableFrom(argumentClass) ? MediatorConfigurationSupport.GenericTypeAssignable.Result.Assignable : MediatorConfigurationSupport.GenericTypeAssignable.Result.NotAssignable;
            }
            return MediatorConfigurationSupport.GenericTypeAssignable.Result.InvalidIndex;
        }

        public Type getType(int index) {
            org.jboss.jandex.Type t = this.extract(this.type, index);
            if (t != null) {
                return QuarkusMediatorConfigurationUtil.load(t.name().toString(), this.classLoader);
            }
            return null;
        }

        private org.jboss.jandex.Type extract(org.jboss.jandex.Type type, int index) {
            if (type.kind() != Type.Kind.PARAMETERIZED_TYPE) {
                return null;
            }
            List arguments = type.asParameterizedType().arguments();
            if (arguments.size() >= index + 1) {
                org.jboss.jandex.Type result = (org.jboss.jandex.Type)arguments.get(index);
                if (result.kind() == Type.Kind.WILDCARD_TYPE) {
                    return null;
                }
                return result;
            }
            return null;
        }

        public Type getType(int index, int subIndex) {
            org.jboss.jandex.Type t;
            org.jboss.jandex.Type generic = this.extract(this.type, index);
            if (generic != null && (t = this.extract(generic, subIndex)) != null) {
                return QuarkusMediatorConfigurationUtil.load(t.name().toString(), this.classLoader);
            }
            return null;
        }
    }

    public static class ReturnTypeGenericTypeAssignable
    extends JandexGenericTypeAssignable {
        public ReturnTypeGenericTypeAssignable(MethodInfo method, ClassLoader classLoader) {
            super(method.returnType(), classLoader);
        }
    }

    public static class AlwaysInvalidIndexGenericTypeAssignable
    implements MediatorConfigurationSupport.GenericTypeAssignable {
        public MediatorConfigurationSupport.GenericTypeAssignable.Result check(Class<?> target, int index) {
            return MediatorConfigurationSupport.GenericTypeAssignable.Result.InvalidIndex;
        }

        public Type getType(int index) {
            return null;
        }

        public Type getType(int index, int subIndex) {
            return null;
        }
    }

    public static class MethodParamGenericTypeAssignable
    extends JandexGenericTypeAssignable {
        public MethodParamGenericTypeAssignable(MethodInfo method, int paramIndex, ClassLoader classLoader) {
            super(MethodParamGenericTypeAssignable.getGenericParameterType(method, paramIndex), classLoader);
        }

        public MethodParamGenericTypeAssignable(org.jboss.jandex.Type type, ClassLoader classLoader) {
            super(type, classLoader);
        }

        private static org.jboss.jandex.Type getGenericParameterType(MethodInfo method, int paramIndex) {
            List parameters = method.parameterTypes();
            if (parameters.size() < paramIndex + 1) {
                throw new IllegalArgumentException("Method " + method + " only has " + parameters.size() + " so parameter with index " + paramIndex + " cannot be retrieved");
            }
            return (org.jboss.jandex.Type)parameters.get(paramIndex);
        }
    }
}

