/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.pulsar;

import io.quarkus.pulsar.QuarkusPulsarKeyStoreAuthentication;
import io.quarkus.tls.TlsConfiguration;
import io.quarkus.tls.TlsConfigurationRegistry;
import io.smallrye.reactive.messaging.ClientCustomizer;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.KeyStoreOptionsBase;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PemTrustOptions;
import io.vertx.core.net.SSLOptions;
import io.vertx.core.net.TrustOptions;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.io.ByteArrayInputStream;
import java.util.Optional;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.ClientBuilder;
import org.apache.pulsar.client.impl.auth.AuthenticationTls;
import org.eclipse.microprofile.config.Config;
import org.jboss.logging.Logger;

@ApplicationScoped
public class PulsarClientConfigCustomizer
implements ClientCustomizer<ClientBuilder> {
    private static final Logger log = Logger.getLogger(PulsarClientConfigCustomizer.class);
    @Inject
    TlsConfigurationRegistry tlsRegistry;

    /*
     * Enabled aggressive block sorting
     */
    public ClientBuilder customize(String channel, Config channelConfig, ClientBuilder builder) {
        Optional tlsConfigName = channelConfig.getOptionalValue("tls-configuration-name", String.class);
        if (!tlsConfigName.isPresent()) return builder;
        String tlsConfig = (String)tlsConfigName.get();
        Optional maybeTlsConfig = this.tlsRegistry.get(tlsConfig);
        if (!maybeTlsConfig.isPresent()) return builder;
        TlsConfiguration configuration = (TlsConfiguration)maybeTlsConfig.get();
        SSLOptions sslOptions = configuration.getSSLOptions();
        builder.tlsCiphers(sslOptions.getEnabledCipherSuites());
        builder.tlsProtocols(sslOptions.getEnabledSecureTransportProtocols());
        builder.allowTlsInsecureConnection(false);
        KeyCertOptions keyStoreOptions = configuration.getKeyStoreOptions();
        TrustOptions trustStoreOptions = configuration.getTrustStoreOptions();
        if (keyStoreOptions instanceof PemKeyCertOptions) {
            PemKeyCertOptions keyCertOptions = (PemKeyCertOptions)keyStoreOptions;
            if (trustStoreOptions instanceof PemTrustOptions) {
                PemTrustOptions trustCertOptions = (PemTrustOptions)trustStoreOptions;
                Buffer trust = trustCertOptions.getCertValues().stream().collect(Buffer::buffer, Buffer::appendBuffer, Buffer::appendBuffer);
                builder.authentication((Authentication)new AuthenticationTls(() -> new ByteArrayInputStream(keyCertOptions.getCertValue().getBytes()), () -> new ByteArrayInputStream(keyCertOptions.getKeyValue().getBytes()), () -> new ByteArrayInputStream(trust.getBytes())));
                log.debugf("Configured PulsarClientConfiguration for channel %s with TLS configuration %s", (Object)channel, (Object)tlsConfig);
                return builder;
            }
        }
        if (keyStoreOptions instanceof KeyStoreOptionsBase && trustStoreOptions instanceof KeyStoreOptionsBase) {
            builder.useKeyStoreTls(false);
            builder.authentication((Authentication)new QuarkusPulsarKeyStoreAuthentication(configuration));
            log.debugf("Configured PulsarClientConfiguration for channel %s with TLS configuration %s", (Object)channel, (Object)tlsConfig);
            return builder;
        }
        log.warnf("Unsupported TLS configuration for channel %s with TLS configuration %s", (Object)channel, (Object)tlsConfig);
        return builder;
    }
}

