/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.reactivemessaging.runtime;

import io.smallrye.mutiny.Multi;
import io.smallrye.reactive.messaging.PublisherDecorator;
import io.smallrye.reactive.messaging.SubscriberDecorator;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Optional;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.context.ThreadContext;
import org.eclipse.microprofile.reactive.messaging.Message;

@ApplicationScoped
public class ConnectorContextPropagationDecorator
implements PublisherDecorator,
SubscriberDecorator {
    private final ThreadContext tc;

    @Inject
    public ConnectorContextPropagationDecorator(@ConfigProperty(name="quarkus.messaging.connector-context-propagation") Optional<List<String>> propagation) {
        this.tc = ThreadContext.builder().propagated(propagation.map(l -> (String[])l.toArray(String[]::new)).orElse(ThreadContext.NONE)).cleared(new String[]{"Remaining"}).build();
    }

    public Multi<? extends Message<?>> decorate(Multi<? extends Message<?>> publisher, List<String> channelName, boolean isConnector) {
        if (isConnector) {
            return publisher.emitOn(this.tc.currentContextExecutor());
        }
        return publisher;
    }

    public int getPriority() {
        return -100;
    }
}

