/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime.binder.vertx;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.quarkus.micrometer.runtime.binder.HttpBinderConfiguration;
import io.quarkus.micrometer.runtime.binder.vertx.VertxClientMetrics;
import io.quarkus.micrometer.runtime.binder.vertx.VertxEventBusMetrics;
import io.quarkus.micrometer.runtime.binder.vertx.VertxHttpClientMetrics;
import io.quarkus.micrometer.runtime.binder.vertx.VertxHttpServerMetrics;
import io.quarkus.micrometer.runtime.binder.vertx.VertxPoolMetrics;
import io.quarkus.micrometer.runtime.binder.vertx.VertxTcpClientMetrics;
import io.quarkus.micrometer.runtime.binder.vertx.VertxTcpServerMetrics;
import io.quarkus.micrometer.runtime.binder.vertx.VertxUdpMetrics;
import io.quarkus.micrometer.runtime.export.exemplars.OpenTelemetryContextUnwrapper;
import io.quarkus.vertx.http.runtime.ExtendedQuarkusVertxHttpMetrics;
import io.vertx.core.VertxOptions;
import io.vertx.core.datagram.DatagramSocketOptions;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.impl.NoStackTraceException;
import io.vertx.core.metrics.MetricsOptions;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.VertxMetricsFactory;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.core.spi.metrics.DatagramSocketMetrics;
import io.vertx.core.spi.metrics.EventBusMetrics;
import io.vertx.core.spi.metrics.HttpClientMetrics;
import io.vertx.core.spi.metrics.HttpServerMetrics;
import io.vertx.core.spi.metrics.PoolMetrics;
import io.vertx.core.spi.metrics.TCPMetrics;
import io.vertx.core.spi.metrics.VertxMetrics;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.jboss.logging.Logger;

public class VertxMeterBinderAdapter
extends MetricsOptions
implements VertxMetricsFactory,
VertxMetrics,
ExtendedQuarkusVertxHttpMetrics {
    private static final Logger log = Logger.getLogger(VertxMeterBinderAdapter.class);
    public static final String METRIC_NAME_SEPARATOR = "|";
    private HttpBinderConfiguration httpBinderConfiguration;
    private OpenTelemetryContextUnwrapper openTelemetryContextUnwrapper;

    void initBinder(HttpBinderConfiguration httpBinderConfiguration, OpenTelemetryContextUnwrapper openTelemetryContextUnwrapper) {
        this.openTelemetryContextUnwrapper = openTelemetryContextUnwrapper;
        this.httpBinderConfiguration = httpBinderConfiguration;
    }

    public boolean isEnabled() {
        return true;
    }

    public VertxMetricsFactory getFactory() {
        return this;
    }

    public VertxMetrics metrics(VertxOptions vertxOptions) {
        return this;
    }

    public MetricsOptions newOptions() {
        return this;
    }

    public HttpServerMetrics<?, ?, ?> createHttpServerMetrics(HttpServerOptions options, SocketAddress localAddress) {
        if (this.httpBinderConfiguration == null) {
            throw new NoStackTraceException("HttpBinderConfiguration was not found");
        }
        if (this.openTelemetryContextUnwrapper == null) {
            throw new NoStackTraceException("OpenTelemetryContextUnwrapper was not found");
        }
        if (this.httpBinderConfiguration.isServerEnabled()) {
            log.debugf("Create HttpServerMetrics with options %s and address %s", (Object)options, (Object)localAddress);
            return new VertxHttpServerMetrics((MeterRegistry)Metrics.globalRegistry, this.httpBinderConfiguration, this.openTelemetryContextUnwrapper);
        }
        return null;
    }

    public HttpClientMetrics<?, ?, ?, ?> createHttpClientMetrics(HttpClientOptions options) {
        if (this.httpBinderConfiguration == null) {
            return null;
        }
        if (this.httpBinderConfiguration.isClientEnabled()) {
            if (options.getMetricsName() == null || options.getMetricsName().trim().isEmpty()) {
                return null;
            }
            String clientName = this.extractClientName(options.getMetricsName());
            if (clientName != null) {
                return new VertxHttpClientMetrics((MeterRegistry)Metrics.globalRegistry, "http.client", Tags.of((Tag[])new Tag[]{Tag.of((String)"clientName", (String)clientName)}), this.httpBinderConfiguration);
            }
            return new VertxHttpClientMetrics((MeterRegistry)Metrics.globalRegistry, "http.client", Tags.of((Tag[])new Tag[]{Tag.of((String)"clientName", (String)"<default>")}), this.httpBinderConfiguration);
        }
        return null;
    }

    public TCPMetrics<?> createNetServerMetrics(NetServerOptions options, SocketAddress localAddress) {
        return new VertxTcpServerMetrics((MeterRegistry)Metrics.globalRegistry, "tcp", Tags.of((Tag[])new Tag[]{Tag.of((String)"port", (String)Integer.toString(localAddress.port())), Tag.of((String)"host", (String)options.getHost()), Tag.of((String)"address", (String)VertxTcpServerMetrics.toString(localAddress))}));
    }

    public TCPMetrics<?> createNetClientMetrics(NetClientOptions options) {
        if (options.getMetricsName() == null || options.getMetricsName().trim().isEmpty()) {
            return null;
        }
        String prefix = this.extractPrefix(options.getMetricsName());
        String clientName = this.extractClientName(options.getMetricsName());
        if (clientName != null) {
            return new VertxTcpClientMetrics((MeterRegistry)Metrics.globalRegistry, prefix, Tags.of((Tag[])new Tag[]{Tag.of((String)"clientName", (String)clientName)}));
        }
        return new VertxTcpClientMetrics((MeterRegistry)Metrics.globalRegistry, prefix, Tags.of((Tag[])new Tag[]{Tag.of((String)"clientName", (String)"<default>")}));
    }

    public ClientMetrics<?, ?, ?, ?> createClientMetrics(SocketAddress remoteAddress, String type, String namespace) {
        String prefix = this.extractPrefix(namespace);
        String clientName = this.extractClientName(namespace);
        if (clientName != null) {
            return new VertxClientMetrics((MeterRegistry)Metrics.globalRegistry, prefix, Tags.of((Tag[])new Tag[]{Tag.of((String)"clientName", (String)clientName), Tag.of((String)"clientType", (String)type)}));
        }
        return new VertxClientMetrics((MeterRegistry)Metrics.globalRegistry, prefix, Tags.of((Iterable)Tags.of((Tag[])new Tag[]{Tag.of((String)"clientName", (String)"<default>"), Tag.of((String)"clientType", (String)type)})));
    }

    public PoolMetrics<?> createPoolMetrics(String poolType, String poolName, int maxPoolSize) {
        return new VertxPoolMetrics((MeterRegistry)Metrics.globalRegistry, poolType, poolName, maxPoolSize);
    }

    public DatagramSocketMetrics createDatagramSocketMetrics(DatagramSocketOptions options) {
        return new VertxUdpMetrics((MeterRegistry)Metrics.globalRegistry, "udp", Tags.of((String)"protocol", (String)"udp"));
    }

    public EventBusMetrics<?> createEventBusMetrics() {
        return new VertxEventBusMetrics((MeterRegistry)Metrics.globalRegistry, Tags.empty());
    }

    private String extractPrefix(String mn) {
        if (mn.contains(METRIC_NAME_SEPARATOR)) {
            return mn.substring(0, mn.indexOf(METRIC_NAME_SEPARATOR));
        }
        return mn;
    }

    private String extractClientName(String mn) {
        if (mn.contains(METRIC_NAME_SEPARATOR)) {
            return mn.substring(mn.indexOf(METRIC_NAME_SEPARATOR) + 1);
        }
        return null;
    }

    public ExtendedQuarkusVertxHttpMetrics.ConnectionTracker getHttpConnectionTracker() {
        return new ExtendedQuarkusVertxHttpMetrics.ConnectionTracker(){
            private final Counter counter = Counter.builder((String)"vertx.http.connections.rejected").description("Number of rejected HTTP connections").register((MeterRegistry)Metrics.globalRegistry);

            public void onConnectionRejected() {
                this.counter.increment();
            }

            public void initialize(final int maxConnections, final AtomicInteger current) {
                Gauge.builder((String)"vertx.http.connections.current", (Supplier)new Supplier<Number>(){

                    @Override
                    public Number get() {
                        return current.get();
                    }
                }).description("Current number of active HTTP connections").register((MeterRegistry)Metrics.globalRegistry);
                Gauge.builder((String)"vertx.http.connections.max", (Supplier)new Supplier<Number>(){

                    @Override
                    public Number get() {
                        return maxConnections;
                    }
                }).description("Max number of HTTP connections").register((MeterRegistry)Metrics.globalRegistry);
            }
        };
    }
}

