/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime.binder.vertx;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.quarkus.micrometer.runtime.binder.HttpBinderConfiguration;
import io.quarkus.micrometer.runtime.binder.HttpCommonTags;
import io.quarkus.micrometer.runtime.binder.RequestMetricInfo;
import io.quarkus.micrometer.runtime.binder.vertx.EventTiming;
import io.quarkus.micrometer.runtime.binder.vertx.NetworkMetrics;
import io.quarkus.micrometer.runtime.binder.vertx.VertxTcpClientMetrics;
import io.vertx.core.http.WebSocket;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.core.spi.metrics.HttpClientMetrics;
import io.vertx.core.spi.observability.HttpRequest;
import io.vertx.core.spi.observability.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;

class VertxHttpClientMetrics
extends VertxTcpClientMetrics
implements HttpClientMetrics<RequestTracker, String, LongTaskTimer.Sample, EventTiming> {
    private final LongAdder queue = new LongAdder();
    private final LongAdder pending = new LongAdder();
    private final Timer queueDelay;
    private final Map<String, LongAdder> webSockets = new ConcurrentHashMap<String, LongAdder>();
    private final HttpBinderConfiguration config;

    VertxHttpClientMetrics(MeterRegistry registry, String prefix, Tags tags, HttpBinderConfiguration httpBinderConfiguration) {
        super(registry, prefix, tags);
        this.config = httpBinderConfiguration;
        this.queueDelay = Timer.builder((String)"http.client.queue.delay").description("Time spent in the waiting queue before being processed").tags((Iterable)tags).register(registry);
        Gauge.builder((String)"http.client.queue.size", (Supplier)new Supplier<Number>(){

            @Override
            public Number get() {
                return VertxHttpClientMetrics.this.queue.doubleValue();
            }
        }).description("Number of pending elements in the waiting queue").tags((Iterable)tags).strongReference(true).register(registry);
        Gauge.builder((String)"http.client.pending", (Supplier)new Supplier<Number>(){

            @Override
            public Number get() {
                return VertxHttpClientMetrics.this.pending.longValue();
            }
        }).description("Number of requests waiting for a response");
    }

    public ClientMetrics<RequestTracker, EventTiming, HttpRequest, HttpResponse> createEndpointMetrics(SocketAddress remoteAddress, int maxPoolSize) {
        final String remote = NetworkMetrics.toString(remoteAddress);
        return new ClientMetrics<RequestTracker, EventTiming, HttpRequest, HttpResponse>(){

            public EventTiming enqueueRequest() {
                VertxHttpClientMetrics.this.queue.increment();
                return new EventTiming(VertxHttpClientMetrics.this.queueDelay);
            }

            public void dequeueRequest(EventTiming event) {
                VertxHttpClientMetrics.this.queue.decrement();
                event.end();
            }

            public RequestTracker requestBegin(String uri, HttpRequest request) {
                RequestTracker handler = new RequestTracker(VertxHttpClientMetrics.this.tags, remote, request.uri(), request.method().name());
                String path = handler.getNormalizedUriPath(VertxHttpClientMetrics.this.config.getServerMatchPatterns(), VertxHttpClientMetrics.this.config.getServerIgnorePatterns());
                if (path != null) {
                    VertxHttpClientMetrics.this.pending.increment();
                    handler.timer = new EventTiming(null);
                    return handler;
                }
                return null;
            }

            public void requestEnd(RequestTracker tracker, long bytesWritten) {
                if (tracker == null) {
                    return;
                }
                if (tracker.requestEnded()) {
                    VertxHttpClientMetrics.this.pending.decrement();
                }
            }

            public void requestReset(RequestTracker tracker) {
                if (tracker == null) {
                    return;
                }
                VertxHttpClientMetrics.this.pending.decrement();
                tracker.requestReset();
            }

            public void responseBegin(RequestTracker tracker, HttpResponse response) {
                if (tracker == null) {
                    return;
                }
                tracker.response = response;
            }

            public void responseEnd(RequestTracker tracker, long bytesRead) {
                if (tracker == null) {
                    return;
                }
                if (tracker.responseEnded()) {
                    VertxHttpClientMetrics.this.pending.decrement();
                }
                long duration = tracker.timer.end();
                Tags list = tracker.tags.and(new Tag[]{HttpCommonTags.status(tracker.response.statusCode())}).and(new Tag[]{HttpCommonTags.outcome(tracker.response.statusCode())});
                Timer.builder((String)VertxHttpClientMetrics.this.config.getHttpClientRequestsName()).description("Response times").tags((Iterable)list).register(VertxHttpClientMetrics.this.registry).record(duration, TimeUnit.NANOSECONDS);
            }
        };
    }

    public String connected(WebSocket webSocket) {
        final String remote = webSocket.remoteAddress().toString();
        this.webSockets.computeIfAbsent(remote, new Function<String, LongAdder>(){

            @Override
            public LongAdder apply(String s) {
                LongAdder count = new LongAdder();
                Gauge.builder((String)VertxHttpClientMetrics.this.config.getHttpClientWebSocketConnectionsName(), count::longValue).description("The number of active web socket connections").tags((Iterable)VertxHttpClientMetrics.this.tags.and("address", remote)).register(VertxHttpClientMetrics.this.registry);
                return count;
            }
        }).increment();
        return remote;
    }

    public void disconnected(String remote) {
        LongAdder adder = this.webSockets.get(remote);
        if (adder != null) {
            adder.decrement();
            if (adder.longValue() == 0L) {
                this.webSockets.remove(remote);
            }
        }
    }

    public static class RequestTracker
    extends RequestMetricInfo {
        private final Tags tags;
        private final String path;
        private EventTiming timer;
        HttpResponse response;
        private boolean responseEnded;
        private boolean requestEnded;
        private boolean reset;

        RequestTracker(Tags origin, String address, String path, String method) {
            this.path = path;
            this.tags = origin.and(new Tag[]{Tag.of((String)"address", (String)address), HttpCommonTags.method(method), HttpCommonTags.uri(path, -1)});
        }

        void requestReset() {
            this.reset = true;
        }

        boolean requestEnded() {
            this.requestEnded = true;
            return !this.reset && this.responseEnded;
        }

        boolean responseEnded() {
            this.responseEnded = true;
            return !this.reset && this.requestEnded;
        }

        public String getNormalizedUriPath(Map<Pattern, String> serverMatchPatterns, List<Pattern> serverIgnorePatterns) {
            return super.getNormalizedUriPath(serverMatchPatterns, serverIgnorePatterns, this.path);
        }
    }
}

