/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.client.runtime;

import io.quarkus.oidc.client.OidcClient;
import io.quarkus.oidc.client.OidcClientConfig;
import io.quarkus.oidc.client.OidcClientException;
import io.quarkus.oidc.client.Tokens;
import io.quarkus.oidc.common.runtime.OidcCommonConfig;
import io.quarkus.oidc.common.runtime.OidcCommonUtils;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.groups.UniOnItem;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.JsonObject;
import io.vertx.mutiny.core.MultiMap;
import io.vertx.mutiny.core.buffer.Buffer;
import io.vertx.mutiny.ext.web.client.HttpRequest;
import io.vertx.mutiny.ext.web.client.HttpResponse;
import io.vertx.mutiny.ext.web.client.WebClient;
import java.io.IOException;
import java.net.ConnectException;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.time.Instant;
import java.util.Base64;
import java.util.Map;
import java.util.function.Supplier;
import org.eclipse.microprofile.jwt.Claims;
import org.jboss.logging.Logger;

public class OidcClientImpl
implements OidcClient {
    private static final Logger LOG = Logger.getLogger(OidcClientImpl.class);
    private static final String AUTHORIZATION_HEADER = String.valueOf(HttpHeaders.AUTHORIZATION);
    private final WebClient client;
    private final String tokenRequestUri;
    private final String tokenRevokeUri;
    private final MultiMap tokenGrantParams;
    private final MultiMap commonRefreshGrantParams;
    private final String grantType;
    private final String clientSecretBasicAuthScheme;
    private final Key clientJwtKey;
    private final OidcClientConfig oidcConfig;
    private volatile boolean closed;

    public OidcClientImpl(WebClient client, String tokenRequestUri, String tokenRevokeUri, String grantType, MultiMap tokenGrantParams, MultiMap commonRefreshGrantParams, OidcClientConfig oidcClientConfig) {
        this.client = client;
        this.tokenRequestUri = tokenRequestUri;
        this.tokenRevokeUri = tokenRevokeUri;
        this.tokenGrantParams = tokenGrantParams;
        this.commonRefreshGrantParams = commonRefreshGrantParams;
        this.grantType = grantType;
        this.oidcConfig = oidcClientConfig;
        this.clientSecretBasicAuthScheme = OidcCommonUtils.initClientSecretBasicAuth((OidcCommonConfig)oidcClientConfig);
        this.clientJwtKey = OidcCommonUtils.initClientJwtKey((OidcCommonConfig)oidcClientConfig);
    }

    @Override
    public Uni<Tokens> getTokens(Map<String, String> additionalGrantParameters) {
        this.checkClosed();
        if (this.tokenGrantParams == null) {
            throw new OidcClientException("Only 'refresh_token' grant is supported, please call OidcClient#refreshTokens method instead");
        }
        return this.getJsonResponse(this.tokenGrantParams, additionalGrantParameters, false);
    }

    @Override
    public Uni<Tokens> refreshTokens(String refreshToken, Map<String, String> additionalGrantParameters) {
        this.checkClosed();
        if (refreshToken == null) {
            throw new OidcClientException("Refresh token is null");
        }
        MultiMap refreshGrantParams = OidcClientImpl.copyMultiMap(this.commonRefreshGrantParams);
        refreshGrantParams.add("refresh_token", refreshToken);
        return this.getJsonResponse(refreshGrantParams, additionalGrantParameters, true);
    }

    @Override
    public Uni<Boolean> revokeAccessToken(String accessToken, Map<String, String> additionalParameters) {
        this.checkClosed();
        if (accessToken == null) {
            throw new OidcClientException("Access token is null");
        }
        if (this.tokenRevokeUri != null) {
            MultiMap tokenRevokeParams = new MultiMap(io.vertx.core.MultiMap.caseInsensitiveMultiMap());
            tokenRevokeParams.set("token", accessToken);
            return this.postRequest((HttpRequest<Buffer>)this.client.postAbs(this.tokenRevokeUri), tokenRevokeParams, additionalParameters, false).transform(resp -> this.toRevokeResponse((HttpResponse<Buffer>)resp));
        }
        LOG.debugf("%s OidcClient can not revoke the access token because the revocation endpoint URL is not set", new Object[0]);
        return Uni.createFrom().item((Object)false);
    }

    private Boolean toRevokeResponse(HttpResponse<Buffer> resp) {
        return resp.statusCode() != 503;
    }

    private Uni<Tokens> getJsonResponse(final MultiMap formBody, final Map<String, String> additionalGrantParameters, final boolean refresh) {
        return Uni.createFrom().deferred((Supplier)new Supplier<Uni<? extends Tokens>>(){

            @Override
            public Uni<Tokens> get() {
                return OidcClientImpl.this.postRequest((HttpRequest<Buffer>)OidcClientImpl.this.client.postAbs(OidcClientImpl.this.tokenRequestUri), formBody, additionalGrantParameters, refresh).transform(resp -> OidcClientImpl.this.emitGrantTokens((HttpResponse<Buffer>)resp, refresh));
            }
        });
    }

    private UniOnItem<HttpResponse<Buffer>> postRequest(HttpRequest<Buffer> request, MultiMap formBody, Map<String, String> additionalGrantParameters, boolean refresh) {
        MultiMap body = formBody;
        request.putHeader(HttpHeaders.CONTENT_TYPE.toString(), HttpHeaders.APPLICATION_X_WWW_FORM_URLENCODED.toString());
        if (this.oidcConfig.headers != null) {
            for (Map.Entry<String, String> entry : this.oidcConfig.headers.entrySet()) {
                request.putHeader(entry.getKey(), entry.getValue());
            }
        }
        if (this.clientSecretBasicAuthScheme != null) {
            request.putHeader(AUTHORIZATION_HEADER, this.clientSecretBasicAuthScheme);
        } else if (this.clientJwtKey != null) {
            body = !refresh ? OidcClientImpl.copyMultiMap(body) : body;
            String jwt = OidcCommonUtils.signJwtWithKey((OidcCommonConfig)this.oidcConfig, (String)this.tokenRequestUri, (Key)this.clientJwtKey);
            if (OidcCommonUtils.isClientSecretPostJwtAuthRequired((OidcCommonConfig.Credentials)this.oidcConfig.credentials)) {
                body.add("client_id", (String)this.oidcConfig.clientId.get());
                body.add("client_secret", jwt);
            } else {
                body.add("client_assertion_type", "urn:ietf:params:oauth:client-assertion-type:jwt-bearer");
                body.add("client_assertion", jwt);
            }
        } else if (OidcCommonUtils.isClientSecretPostAuthRequired((OidcCommonConfig.Credentials)this.oidcConfig.credentials)) {
            body = !refresh ? OidcClientImpl.copyMultiMap(body) : body;
            body.set("client_id", (String)this.oidcConfig.clientId.get());
            body.set("client_secret", OidcCommonUtils.clientSecret((OidcCommonConfig.Credentials)this.oidcConfig.credentials));
        } else {
            body = !refresh ? OidcClientImpl.copyMultiMap(body) : body;
            body = OidcClientImpl.copyMultiMap(body).set("client_id", (String)this.oidcConfig.clientId.get());
        }
        if (!additionalGrantParameters.isEmpty()) {
            body = OidcClientImpl.copyMultiMap(body);
            for (Map.Entry entry : additionalGrantParameters.entrySet()) {
                body.add((String)entry.getKey(), (String)entry.getValue());
            }
        }
        Uni response = request.sendBuffer(OidcCommonUtils.encodeForm((MultiMap)body)).onFailure(ConnectException.class).retry().atMost((long)this.oidcConfig.connectionRetryCount).onFailure().transform(t -> {
            LOG.warn((Object)"OIDC Server is not available:", t.getCause() != null ? t.getCause() : t);
            return new OidcClientException("OIDC Server is not available");
        });
        return response.onItem();
    }

    private Tokens emitGrantTokens(HttpResponse<Buffer> resp, boolean refresh) {
        if (resp.statusCode() == 200) {
            LOG.debugf("%s OidcClient has %s the tokens", (Object)this.oidcConfig.getId().get(), (Object)(refresh ? "refreshed" : "acquired"));
            JsonObject json = resp.bodyAsJsonObject();
            String accessToken = json.getString(this.oidcConfig.grant.accessTokenProperty);
            Long accessTokenExpiresAt = this.getExpiresAtValue(accessToken, json.getValue(this.oidcConfig.grant.expiresInProperty));
            String refreshToken = json.getString(this.oidcConfig.grant.refreshTokenProperty);
            Long refreshTokenExpiresAt = this.getExpiresAtValue(refreshToken, json.getValue(this.oidcConfig.grant.refreshExpiresInProperty));
            return new Tokens(accessToken, accessTokenExpiresAt, this.oidcConfig.refreshTokenTimeSkew.orElse(null), refreshToken, refreshTokenExpiresAt, json);
        }
        String errorMessage = resp.bodyAsString();
        LOG.debugf("%s OidcClient has failed to complete the %s grant request:  status: %d, error message: %s", new Object[]{this.oidcConfig.getId().get(), refresh ? "refresh_token" : this.grantType, resp.statusCode(), errorMessage});
        throw new OidcClientException(errorMessage);
    }

    private Long getExpiresAtValue(String token, Object expiresInValue) {
        if (expiresInValue != null) {
            long tokenExpiresIn = expiresInValue instanceof Number ? ((Number)expiresInValue).longValue() : Long.parseLong(expiresInValue.toString());
            return this.oidcConfig.absoluteExpiresIn ? tokenExpiresIn : Instant.now().getEpochSecond() + tokenExpiresIn;
        }
        return token != null ? OidcClientImpl.getExpiresJwtClaim(token) : null;
    }

    private static Long getExpiresJwtClaim(String token) {
        JsonObject claims = OidcClientImpl.decodeJwtToken(token);
        if (claims != null) {
            try {
                return claims.getLong(Claims.exp.name());
            }
            catch (IllegalArgumentException ex) {
                LOG.debug((Object)"JWT expiry claim can not be converted to Long");
            }
        }
        return null;
    }

    private static JsonObject decodeJwtToken(String accessToken) {
        block4: {
            String[] parts = accessToken.split("\\.");
            if (parts.length == 3) {
                try {
                    return new JsonObject(new String(Base64.getUrlDecoder().decode(parts[1]), StandardCharsets.UTF_8));
                }
                catch (IllegalArgumentException ex) {
                    LOG.debug((Object)"JWT token can not be decoded using the Base64Url encoding scheme");
                    break block4;
                }
                catch (DecodeException ex) {
                    LOG.debug((Object)"JWT token can not be decoded");
                    break block4;
                }
            }
            LOG.debug((Object)"Access token is not formatted as the encoded JWT token");
        }
        return null;
    }

    private static MultiMap copyMultiMap(MultiMap oldMap) {
        MultiMap newMap = new MultiMap(io.vertx.core.MultiMap.caseInsensitiveMultiMap());
        newMap.addAll(oldMap);
        return newMap;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.client.close();
            this.closed = true;
        }
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("OidcClient " + this.oidcConfig.getId().get() + " is closed");
        }
    }
}

