/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.common.runtime;

import io.quarkus.oidc.common.runtime.OidcCommonConfig;
import io.quarkus.runtime.annotations.ConfigDocMapKey;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigItem;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

@ConfigGroup
public class OidcClientCommonConfig
extends OidcCommonConfig {
    @ConfigItem
    public Optional<String> tokenPath = Optional.empty();
    @ConfigItem
    public Optional<String> revokePath = Optional.empty();
    @ConfigItem
    public Optional<String> clientId = Optional.empty();
    @ConfigItem
    public Optional<String> clientName = Optional.empty();
    @ConfigItem
    public Credentials credentials = new Credentials();

    public Optional<String> getTokenPath() {
        return this.tokenPath;
    }

    public void setTokenPath(String tokenPath) {
        this.tokenPath = Optional.of(tokenPath);
    }

    public Optional<String> getRevokePath() {
        return this.revokePath;
    }

    public void setRevokePath(String revokePath) {
        this.revokePath = Optional.of(revokePath);
    }

    public Optional<String> getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = Optional.of(clientId);
    }

    public Optional<String> getClientName() {
        return this.clientName;
    }

    public void setClientName(String clientName) {
        this.clientName = Optional.of(clientName);
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public void setCredentials(Credentials credentials) {
        this.credentials = credentials;
    }

    @ConfigGroup
    public static class Credentials {
        @ConfigItem
        public Optional<String> secret = Optional.empty();
        @ConfigItem
        public Secret clientSecret = new Secret();
        @ConfigItem
        public Jwt jwt = new Jwt();

        public Optional<String> getSecret() {
            return this.secret;
        }

        public void setSecret(String secret) {
            this.secret = Optional.of(secret);
        }

        public Secret getClientSecret() {
            return this.clientSecret;
        }

        public void setClientSecret(Secret clientSecret) {
            this.clientSecret = clientSecret;
        }

        public Jwt getJwt() {
            return this.jwt;
        }

        public void setJwt(Jwt jwt) {
            this.jwt = jwt;
        }

        @ConfigGroup
        public static class Secret {
            @ConfigItem
            public Optional<String> value = Optional.empty();
            @ConfigItem
            public Provider provider = new Provider();
            @ConfigItem
            public Optional<Method> method = Optional.empty();

            public Optional<String> getValue() {
                return this.value;
            }

            public void setValue(String value) {
                this.value = Optional.of(value);
            }

            public Optional<Method> getMethod() {
                return this.method;
            }

            public void setMethod(Method method) {
                this.method = Optional.of(method);
            }

            public Provider getSecretProvider() {
                return this.provider;
            }

            public void setSecretProvider(Provider secretProvider) {
                this.provider = secretProvider;
            }

            public static enum Method {
                BASIC,
                POST,
                POST_JWT,
                QUERY;

            }
        }

        @ConfigGroup
        public static class Jwt {
            @ConfigItem(defaultValue="client")
            public Source source = Source.CLIENT;
            @ConfigItem
            public Optional<String> secret = Optional.empty();
            @ConfigItem
            public Provider secretProvider = new Provider();
            @ConfigItem
            public Optional<String> key = Optional.empty();
            @ConfigItem
            public Optional<String> keyFile = Optional.empty();
            @ConfigItem
            public Optional<String> keyStoreFile = Optional.empty();
            @ConfigItem
            public Optional<String> keyStorePassword;
            @ConfigItem
            public Optional<String> keyId = Optional.empty();
            @ConfigItem
            public Optional<String> keyPassword;
            @ConfigItem
            public Optional<String> audience = Optional.empty();
            @ConfigItem
            public Optional<String> tokenKeyId = Optional.empty();
            @ConfigItem
            public Optional<String> issuer = Optional.empty();
            @ConfigItem
            public Optional<String> subject = Optional.empty();
            @ConfigItem
            @ConfigDocMapKey(value="claim-name")
            public Map<String, String> claims = new HashMap<String, String>();
            @ConfigItem
            public Optional<String> signatureAlgorithm = Optional.empty();
            @ConfigItem(defaultValue="10")
            public int lifespan = 10;
            @ConfigItem(defaultValue="false")
            public boolean assertion = false;

            public Optional<String> getSecret() {
                return this.secret;
            }

            public void setSecret(String secret) {
                this.secret = Optional.of(secret);
            }

            public int getLifespan() {
                return this.lifespan;
            }

            public void setLifespan(int lifespan) {
                this.lifespan = lifespan;
            }

            public Optional<String> getTokenKeyId() {
                return this.tokenKeyId;
            }

            public void setTokenKeyId(String tokenKeyId) {
                this.tokenKeyId = Optional.of(tokenKeyId);
            }

            public Provider getSecretProvider() {
                return this.secretProvider;
            }

            public void setSecretProvider(Provider secretProvider) {
                this.secretProvider = secretProvider;
            }

            public Optional<String> getSignatureAlgorithm() {
                return this.signatureAlgorithm;
            }

            public void setSignatureAlgorithm(String signatureAlgorithm) {
                this.signatureAlgorithm = Optional.of(signatureAlgorithm);
            }

            public Optional<String> getAudience() {
                return this.audience;
            }

            public void setAudience(String audience) {
                this.audience = Optional.of(audience);
            }

            public Optional<String> getKey() {
                return this.key;
            }

            public void setKey(String key) {
                this.key = Optional.of(key);
            }

            public Optional<String> getKeyFile() {
                return this.keyFile;
            }

            public void setKeyFile(String keyFile) {
                this.keyFile = Optional.of(keyFile);
            }

            public Map<String, String> getClaims() {
                return this.claims;
            }

            public void setClaims(Map<String, String> claims) {
                this.claims = claims;
            }

            public Source getSource() {
                return this.source;
            }

            public void setSource(Source source) {
                this.source = source;
            }

            public boolean isAssertion() {
                return this.assertion;
            }

            public void setAssertion(boolean assertion) {
                this.assertion = assertion;
            }

            public static enum Source {
                CLIENT,
                BEARER;

            }
        }

        @ConfigGroup
        public static class Provider {
            @ConfigItem
            public Optional<String> name = Optional.empty();
            @ConfigItem
            public Optional<String> keyringName = Optional.empty();
            @ConfigItem
            public Optional<String> key = Optional.empty();

            public Optional<String> getName() {
                return this.name;
            }

            public void setName(String name) {
                this.name = Optional.of(name);
            }

            public Optional<String> getKeyringName() {
                return this.keyringName;
            }

            public void setKeyringName(String keyringName) {
                this.keyringName = Optional.of(keyringName);
            }

            public Optional<String> getKey() {
                return this.key;
            }

            public void setKey(String key) {
                this.key = Optional.of(key);
            }
        }
    }
}

