/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.common.runtime;

import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigItem;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Optional;
import java.util.OptionalInt;

@ConfigGroup
public class OidcCommonConfig {
    @ConfigItem
    public Optional<String> authServerUrl = Optional.empty();
    @ConfigItem(defaultValueDocumentation="true")
    public Optional<Boolean> discoveryEnabled = Optional.empty();
    @ConfigItem
    public Optional<String> registrationPath = Optional.empty();
    @ConfigItem
    public Optional<Duration> connectionDelay = Optional.empty();
    @ConfigItem(defaultValue="3")
    public int connectionRetryCount = 3;
    @ConfigItem(defaultValue="10s")
    public Duration connectionTimeout = Duration.ofSeconds(10L);
    @ConfigItem(defaultValue="false")
    public boolean useBlockingDnsLookup;
    @ConfigItem
    public OptionalInt maxPoolSize = OptionalInt.empty();
    @ConfigItem
    public Proxy proxy = new Proxy();
    @ConfigItem
    public Tls tls = new Tls();

    public Optional<Duration> getConnectionDelay() {
        return this.connectionDelay;
    }

    public void setConnectionDelay(Duration connectionDelay) {
        this.connectionDelay = Optional.of(connectionDelay);
    }

    public Optional<String> getAuthServerUrl() {
        return this.authServerUrl;
    }

    public void setAuthServerUrl(String authServerUrl) {
        this.authServerUrl = Optional.of(authServerUrl);
    }

    public Optional<String> getRegistrationPath() {
        return this.registrationPath;
    }

    public void setRegistrationPath(String registrationPath) {
        this.registrationPath = Optional.of(registrationPath);
    }

    public Optional<Boolean> isDiscoveryEnabled() {
        return this.discoveryEnabled;
    }

    public void setDiscoveryEnabled(boolean enabled) {
        this.discoveryEnabled = Optional.of(enabled);
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public Duration getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(Duration connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public OptionalInt getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = OptionalInt.of(maxPoolSize);
    }

    public Optional<Boolean> getDiscoveryEnabled() {
        return this.discoveryEnabled;
    }

    public void setDiscoveryEnabled(Boolean discoveryEnabled) {
        this.discoveryEnabled = Optional.of(discoveryEnabled);
    }

    @ConfigGroup
    public static class Proxy {
        @ConfigItem
        public Optional<String> host = Optional.empty();
        @ConfigItem(defaultValue="80")
        public int port = 80;
        @ConfigItem
        public Optional<String> username = Optional.empty();
        @ConfigItem
        public Optional<String> password = Optional.empty();
    }

    @ConfigGroup
    public static class Tls {
        @ConfigItem
        Optional<String> tlsConfigurationName = Optional.empty();
        @Deprecated
        @ConfigItem
        public Optional<Verification> verification = Optional.empty();
        @Deprecated
        @ConfigItem
        public Optional<Path> keyStoreFile = Optional.empty();
        @Deprecated
        @ConfigItem
        public Optional<String> keyStoreFileType = Optional.empty();
        @Deprecated
        @ConfigItem
        public Optional<String> keyStoreProvider;
        @Deprecated
        @ConfigItem
        public Optional<String> keyStorePassword;
        @Deprecated
        @ConfigItem
        public Optional<String> keyStoreKeyAlias = Optional.empty();
        @Deprecated
        @ConfigItem
        public Optional<String> keyStoreKeyPassword = Optional.empty();
        @Deprecated
        @ConfigItem
        public Optional<Path> trustStoreFile = Optional.empty();
        @Deprecated
        @ConfigItem
        public Optional<String> trustStorePassword = Optional.empty();
        @Deprecated
        @ConfigItem
        public Optional<String> trustStoreCertAlias = Optional.empty();
        @Deprecated
        @ConfigItem
        public Optional<String> trustStoreFileType = Optional.empty();
        @Deprecated
        @ConfigItem
        public Optional<String> trustStoreProvider;

        public Optional<Verification> getVerification() {
            return this.verification;
        }

        public void setVerification(Verification verification) {
            this.verification = Optional.of(verification);
        }

        public Optional<Path> getTrustStoreFile() {
            return this.trustStoreFile;
        }

        public void setTrustStoreFile(Path trustStoreFile) {
            this.trustStoreFile = Optional.of(trustStoreFile);
        }

        public Optional<String> getTrustStorePassword() {
            return this.trustStorePassword;
        }

        public void setTrustStorePassword(String trustStorePassword) {
            this.trustStorePassword = Optional.of(trustStorePassword);
        }

        public Optional<String> getTrustStoreCertAlias() {
            return this.trustStoreCertAlias;
        }

        public void setTrustStoreCertAlias(String trustStoreCertAlias) {
            this.trustStoreCertAlias = Optional.of(trustStoreCertAlias);
        }

        public Optional<String> getKeyStoreProvider() {
            return this.keyStoreProvider;
        }

        public void setKeyStoreProvider(String keyStoreProvider) {
            this.keyStoreProvider = Optional.of(keyStoreProvider);
        }

        public Optional<String> getTrustStoreProvider() {
            return this.trustStoreProvider;
        }

        public void setTrustStoreProvider(String trustStoreProvider) {
            this.trustStoreProvider = Optional.of(trustStoreProvider);
        }

        public static enum Verification {
            REQUIRED,
            CERTIFICATE_VALIDATION,
            NONE;

        }
    }
}

