/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.deployment.devservices.keycloak;

import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.dev.devservices.GlobalDevServicesConfig;
import io.quarkus.devservices.keycloak.KeycloakDevServicesConfig;
import io.quarkus.devservices.keycloak.KeycloakDevServicesRequiredBuildItem;
import io.quarkus.oidc.deployment.OidcBuildStep;
import java.util.HashMap;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;

@BuildSteps(onlyIfNot={IsNormal.class}, onlyIf={OidcBuildStep.IsEnabled.class, GlobalDevServicesConfig.Enabled.class})
public class KeycloakDevServiceRequiredBuildStep {
    private static final Logger LOG = Logger.getLogger(KeycloakDevServiceRequiredBuildStep.class);
    private static final String CONFIG_PREFIX = "quarkus.oidc.";
    private static final String TENANT_ENABLED_CONFIG_KEY = "quarkus.oidc.tenant-enabled";
    private static final String APPLICATION_TYPE_CONFIG_KEY = "quarkus.oidc.application-type";
    private static final String CLIENT_ID_CONFIG_KEY = "quarkus.oidc.client-id";
    private static final String CLIENT_SECRET_CONFIG_KEY = "quarkus.oidc.credentials.secret";

    @BuildStep
    KeycloakDevServicesRequiredBuildItem requireKeycloakDevService(KeycloakDevServicesConfig config) {
        if (!KeycloakDevServiceRequiredBuildStep.isOidcTenantEnabled() && !config.startWithDisabledTenant()) {
            LOG.debug((Object)"Not starting Dev Services for Keycloak as 'quarkus.oidc.tenant.enabled' is false");
            return null;
        }
        return KeycloakDevServicesRequiredBuildItem.of(ctx -> {
            HashMap<String, String> configProperties = new HashMap<String, String>();
            configProperties.put("quarkus.oidc.auth-server-url", ctx.authServerInternalUrl());
            configProperties.put(APPLICATION_TYPE_CONFIG_KEY, KeycloakDevServiceRequiredBuildStep.getOidcApplicationType());
            if (config.createClient()) {
                configProperties.put(CLIENT_ID_CONFIG_KEY, ctx.oidcClientId());
                configProperties.put(CLIENT_SECRET_CONFIG_KEY, ctx.oidcClientSecret());
            }
            return configProperties;
        }, (String)"quarkus.oidc.auth-server-url", (String[])new String[0]);
    }

    private static boolean isOidcTenantEnabled() {
        return ConfigProvider.getConfig().getOptionalValue(TENANT_ENABLED_CONFIG_KEY, Boolean.class).orElse(true);
    }

    private static String getOidcApplicationType() {
        return ConfigProvider.getConfig().getOptionalValue(APPLICATION_TYPE_CONFIG_KEY, String.class).orElse("service");
    }
}

