/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.oidc.OIDCException;
import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.runtime.JwkSetRefreshHandler;
import io.quarkus.oidc.runtime.OidcConfig;
import io.quarkus.oidc.runtime.TenantConfigBean;
import io.quarkus.oidc.runtime.TenantConfigContext;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.subscription.UniEmitter;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.ProxyOptions;
import io.vertx.ext.auth.JWTOptions;
import io.vertx.ext.auth.PubSecKeyOptions;
import io.vertx.ext.auth.oauth2.OAuth2Auth;
import io.vertx.ext.auth.oauth2.OAuth2ClientOptions;
import io.vertx.ext.auth.oauth2.impl.OAuth2AuthProviderImpl;
import io.vertx.ext.auth.oauth2.providers.KeycloakAuth;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletionException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.logging.Logger;

@Recorder
public class OidcRecorder {
    private static final Logger LOG = Logger.getLogger(OidcRecorder.class);

    public Supplier<TenantConfigBean> setup(OidcConfig config, Supplier<Vertx> vertx) {
        final Vertx vertxValue = vertx.get();
        final HashMap<String, TenantConfigContext> tenantsConfig = new HashMap<String, TenantConfigContext>();
        for (Map.Entry<String, OidcTenantConfig> tenant : config.namedTenants.entrySet()) {
            if (config.defaultTenant.getTenantId().isPresent() && tenant.getKey().equals(config.defaultTenant.getTenantId().get())) {
                throw new OIDCException("tenant-id '" + tenant.getKey() + "' duplicates the default tenant-id");
            }
            if (tenant.getValue().getTenantId().isPresent() && !tenant.getKey().equals(tenant.getValue().getTenantId().get())) {
                throw new OIDCException("Configuration has 2 different tenant-id values: '" + tenant.getKey() + "' and '" + tenant.getValue().getTenantId().get() + "'");
            }
            tenantsConfig.put(tenant.getKey(), this.createTenantContext(vertxValue, tenant.getValue(), tenant.getKey()));
        }
        final TenantConfigContext tenantContext = this.createTenantContext(vertxValue, config.defaultTenant, "Default");
        return new Supplier<TenantConfigBean>(){

            @Override
            public TenantConfigBean get() {
                return new TenantConfigBean(tenantsConfig, tenantContext, new Function<OidcTenantConfig, TenantConfigContext>(){

                    @Override
                    public TenantConfigContext apply(OidcTenantConfig config) {
                        return OidcRecorder.this.createTenantContext(vertxValue, config, config.getTenantId().get());
                    }
                });
            }
        };
    }

    private TenantConfigContext createTenantContext(Vertx vertx, OidcTenantConfig oidcConfig, String tenantId) {
        long connectionRetryCount;
        if (!oidcConfig.tenantId.isPresent()) {
            oidcConfig.tenantId = Optional.of(tenantId);
        }
        if (!oidcConfig.tenantEnabled) {
            LOG.debugf("%s tenant configuration is disabled", (Object)tenantId);
            return new TenantConfigContext(null, oidcConfig);
        }
        OAuth2ClientOptions options = new OAuth2ClientOptions();
        if (oidcConfig.getClientId().isPresent()) {
            options.setClientID(oidcConfig.getClientId().get());
        }
        if (oidcConfig.getToken().issuer.isPresent()) {
            options.setValidateIssuer(false);
        }
        if (oidcConfig.getToken().getLifespanGrace().isPresent()) {
            io.vertx.ext.jwt.JWTOptions jwtOptions = new io.vertx.ext.jwt.JWTOptions();
            jwtOptions.setLeeway(oidcConfig.getToken().getLifespanGrace().getAsInt());
            options.setJWTOptions((JWTOptions)jwtOptions);
        }
        if (oidcConfig.getPublicKey().isPresent()) {
            return OidcRecorder.createdTenantContextFromPublicKey(options, oidcConfig);
        }
        if (!oidcConfig.getAuthServerUrl().isPresent() || !oidcConfig.getClientId().isPresent()) {
            throw new ConfigurationException("Both 'auth-server-url' and 'client-id' or alternatively 'public-key' must be configured when the quarkus-oidc extension is enabled");
        }
        String authServerUrl = oidcConfig.getAuthServerUrl().get();
        if (authServerUrl.endsWith("/")) {
            authServerUrl = authServerUrl.substring(0, authServerUrl.length() - 1);
        }
        options.setSite(authServerUrl);
        if (!oidcConfig.discoveryEnabled) {
            if (OidcTenantConfig.ApplicationType.WEB_APP.equals((Object)oidcConfig.applicationType)) {
                if (!oidcConfig.authorizationPath.isPresent() || !oidcConfig.tokenPath.isPresent()) {
                    throw new OIDCException("'web-app' applications must have 'authorization-path' and 'token-path' properties set when the discovery is disabled.");
                }
                if (oidcConfig.getAuthorizationPath().isPresent()) {
                    options.setAuthorizationPath(authServerUrl + OidcRecorder.prependSlash(oidcConfig.getAuthorizationPath().get()));
                }
                if (oidcConfig.getTokenPath().isPresent()) {
                    options.setTokenPath(authServerUrl + OidcRecorder.prependSlash(oidcConfig.getTokenPath().get()));
                }
                if (oidcConfig.getUserInfoPath().isPresent()) {
                    options.setUserInfoPath(authServerUrl + OidcRecorder.prependSlash(oidcConfig.getUserInfoPath().get()));
                }
            }
            if (!oidcConfig.jwksPath.isPresent() && !oidcConfig.introspectionPath.isPresent()) {
                throw new OIDCException("Either 'jwks-path' or 'introspection-path' properties must be set when the discovery is disabled.");
            }
            if (oidcConfig.getIntrospectionPath().isPresent()) {
                options.setIntrospectionPath(authServerUrl + OidcRecorder.prependSlash(oidcConfig.getIntrospectionPath().get()));
            }
            if (oidcConfig.getJwksPath().isPresent()) {
                options.setJwkPath(authServerUrl + OidcRecorder.prependSlash(oidcConfig.getJwksPath().get()));
            }
        }
        OidcTenantConfig.Credentials creds = oidcConfig.getCredentials();
        if (creds.secret.isPresent() && creds.clientSecret.value.isPresent()) {
            throw new ConfigurationException("'credentials.secret' and 'credentials.client-secret' properties are mutually exclusive");
        }
        if ((creds.secret.isPresent() || creds.clientSecret.value.isPresent()) && creds.jwt.secret.isPresent()) {
            throw new ConfigurationException("Use only 'credentials.secret' or 'credentials.client-secret' or 'credentials.jwt.secret' property");
        }
        if (OidcTenantConfig.ApplicationType.SERVICE.equals((Object)oidcConfig.applicationType)) {
            if (oidcConfig.token.refreshExpired) {
                throw new RuntimeException("The 'token.refresh-expired' property can only be enabled for " + (Object)((Object)OidcTenantConfig.ApplicationType.WEB_APP) + " application types");
            }
            if (oidcConfig.logout.path.isPresent()) {
                throw new RuntimeException("The 'logout.path' property can only be enabled for " + (Object)((Object)OidcTenantConfig.ApplicationType.WEB_APP) + " application types");
            }
            if (oidcConfig.roles.source.isPresent() && oidcConfig.roles.source.get() != OidcTenantConfig.Roles.Source.accesstoken) {
                throw new RuntimeException("The 'roles.source' property can only be set to 'accesstoken' for " + (Object)((Object)OidcTenantConfig.ApplicationType.SERVICE) + " application types");
            }
        }
        if (creds.secret.isPresent() || creds.clientSecret.value.isPresent() && creds.clientSecret.method.orElseGet(() -> OidcTenantConfig.Credentials.Secret.Method.BASIC) == OidcTenantConfig.Credentials.Secret.Method.BASIC) {
            options.setClientSecret(creds.secret.orElseGet(() -> creds.clientSecret.value.get()));
        } else {
            options.setClientSecretParameterName(null);
        }
        Optional<ProxyOptions> proxyOpt = OidcRecorder.toProxyOptions(oidcConfig.getProxy());
        if (proxyOpt.isPresent()) {
            options.setProxyOptions(proxyOpt.get());
        }
        if (oidcConfig.tls.verification == OidcTenantConfig.Tls.Verification.NONE) {
            options.setTrustAll(true);
            options.setVerifyHost(false);
        }
        long connectionDelayInSecs = oidcConfig.getConnectionDelay().isPresent() ? oidcConfig.getConnectionDelay().get().toMillis() / 1000L : 0L;
        long l = connectionRetryCount = connectionDelayInSecs > 1L ? connectionDelayInSecs / 2L : 1L;
        if (connectionRetryCount > 1L) {
            LOG.infof("Connecting to IDP for up to %d times every 2 seconds", (Object)connectionRetryCount);
        }
        OAuth2Auth auth = null;
        for (long i = 0L; i < connectionRetryCount; ++i) {
            try {
                if (oidcConfig.discoveryEnabled) {
                    auth = OidcRecorder.discoverOidcEndpoints(vertx, options);
                    break;
                }
                auth = OidcRecorder.setOidcEndpoints(vertx, options);
                break;
            }
            catch (Throwable throwable) {
                while (throwable instanceof CompletionException && throwable.getCause() != null) {
                    throwable = throwable.getCause();
                }
                if (throwable instanceof OIDCException) {
                    if (i + 1L < connectionRetryCount) {
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    throw (OIDCException)throwable;
                }
                throw new OIDCException(throwable);
            }
        }
        String endSessionEndpoint = ((OAuth2AuthProviderImpl)OAuth2AuthProviderImpl.class.cast(auth)).getConfig().getLogoutPath();
        if (oidcConfig.logout.path.isPresent() && !oidcConfig.endSessionPath.isPresent() && endSessionEndpoint == null) {
            throw new RuntimeException("The application supports RP-Initiated Logout but the OpenID Provider does not advertise the end_session_endpoint");
        }
        auth.missingKeyHandler((Handler)new JwkSetRefreshHandler(auth, oidcConfig.token.forcedJwkRefreshInterval));
        return new TenantConfigContext(auth, oidcConfig);
    }

    private static String prependSlash(String path) {
        return !path.startsWith("/") ? "/" + path : path;
    }

    private static OAuth2Auth discoverOidcEndpoints(final Vertx vertx, final OAuth2ClientOptions options) {
        return (OAuth2Auth)Uni.createFrom().emitter((Consumer)new Consumer<UniEmitter<? super OAuth2Auth>>(){

            @Override
            public void accept(final UniEmitter<? super OAuth2Auth> uniEmitter) {
                KeycloakAuth.discover((Vertx)vertx, (OAuth2ClientOptions)options, (Handler)new Handler<AsyncResult<OAuth2Auth>>(){

                    public void handle(AsyncResult<OAuth2Auth> event) {
                        if (event.failed()) {
                            uniEmitter.fail((Throwable)OidcRecorder.toOidcException(event.cause()));
                        } else {
                            uniEmitter.complete(event.result());
                        }
                    }
                });
            }
        }).await().indefinitely();
    }

    private static OAuth2Auth setOidcEndpoints(final Vertx vertx, final OAuth2ClientOptions options) {
        if (options.getJwkPath() != null) {
            return (OAuth2Auth)Uni.createFrom().emitter((Consumer)new Consumer<UniEmitter<? super OAuth2Auth>>(){

                @Override
                public void accept(UniEmitter<? super OAuth2Auth> uniEmitter) {
                    OAuth2Auth auth = OAuth2Auth.create((Vertx)vertx, (OAuth2ClientOptions)options);
                    auth.loadJWK(res -> {
                        if (res.failed()) {
                            uniEmitter.fail((Throwable)OidcRecorder.toOidcException(res.cause()));
                        }
                        uniEmitter.complete((Object)auth);
                    });
                }
            }).await().indefinitely();
        }
        return OAuth2Auth.create((Vertx)vertx, (OAuth2ClientOptions)options);
    }

    private static TenantConfigContext createdTenantContextFromPublicKey(OAuth2ClientOptions options, OidcTenantConfig oidcConfig) {
        if (oidcConfig.applicationType == OidcTenantConfig.ApplicationType.WEB_APP) {
            throw new ConfigurationException("'public-key' property can only be used with the 'service' applications");
        }
        LOG.debug((Object)"'public-key' property for the local token verification is set, no connection to the OIDC server will be created");
        options.addPubSecKey(new PubSecKeyOptions().setAlgorithm("RS256").setPublicKey(oidcConfig.getPublicKey().get()));
        return new TenantConfigContext((OAuth2Auth)new OAuth2AuthProviderImpl(null, options), oidcConfig);
    }

    protected static OIDCException toOidcException(Throwable cause) {
        String message = "OIDC server is not available at the 'quarkus.oidc.auth-server-url' URL. Please make sure it is correct. Note it has to end with a realm value if you work with Keycloak, for example: 'https://localhost:8180/auth/realms/quarkus'";
        return new OIDCException("OIDC server is not available at the 'quarkus.oidc.auth-server-url' URL. Please make sure it is correct. Note it has to end with a realm value if you work with Keycloak, for example: 'https://localhost:8180/auth/realms/quarkus'", cause);
    }

    protected static Optional<ProxyOptions> toProxyOptions(OidcTenantConfig.Proxy proxyConfig) {
        if (!proxyConfig.host.isPresent()) {
            return Optional.empty();
        }
        JsonObject jsonOptions = new JsonObject();
        jsonOptions.put("host", proxyConfig.host.get());
        jsonOptions.put("port", Integer.valueOf(proxyConfig.port));
        if (proxyConfig.username.isPresent()) {
            jsonOptions.put("username", proxyConfig.username.get());
        }
        if (proxyConfig.password.isPresent()) {
            jsonOptions.put("password", proxyConfig.password.get());
        }
        return Optional.of(new ProxyOptions(jsonOptions));
    }
}

