/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.oidc.runtime.OidcTenantConfig;
import io.quarkus.runtime.annotations.ConfigDocMapKey;
import io.quarkus.runtime.annotations.ConfigDocSection;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.WithDefault;
import io.smallrye.config.WithDefaults;
import io.smallrye.config.WithParentName;
import io.smallrye.config.WithUnnamedKey;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;

@ConfigMapping(prefix="quarkus.oidc")
@ConfigRoot(phase=ConfigPhase.RUN_TIME)
public interface OidcConfig {
    public static final String DEFAULT_TENANT_KEY = "<default>";

    @ConfigDocMapKey(value="tenant")
    @WithParentName
    @WithUnnamedKey(value="<default>")
    @WithDefaults
    public @WithUnnamedKey(value="<default>") Map<String, OidcTenantConfig> namedTenants();

    @ConfigDocSection
    public TokenCache tokenCache();

    @WithDefault(value="false")
    public boolean resolveTenantsWithIssuer();

    public static OidcTenantConfig getDefaultTenant(OidcConfig config) {
        for (Map.Entry<String, OidcTenantConfig> tenant : config.namedTenants().entrySet()) {
            if (!DEFAULT_TENANT_KEY.equals(tenant.getKey())) continue;
            return tenant.getValue();
        }
        return null;
    }

    public static interface TokenCache {
        @WithDefault(value="0")
        public int maxSize();

        @WithDefault(value="3M")
        public Duration timeToLive();

        public Optional<Duration> cleanUpTimerInterval();
    }
}

