/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.oidc.AccessTokenCredential;
import io.quarkus.oidc.IdTokenCredential;
import io.quarkus.oidc.OIDCException;
import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.TokenIntrospection;
import io.quarkus.oidc.TokenIntrospectionCache;
import io.quarkus.oidc.UserInfo;
import io.quarkus.oidc.UserInfoCache;
import io.quarkus.oidc.runtime.BlockingTaskRunner;
import io.quarkus.oidc.runtime.DefaultTenantConfigResolver;
import io.quarkus.oidc.runtime.OidcUtils;
import io.quarkus.oidc.runtime.TenantConfigContext;
import io.quarkus.oidc.runtime.TokenAutoRefreshException;
import io.quarkus.oidc.runtime.TokenVerificationResult;
import io.quarkus.security.AuthenticationCompletionException;
import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.credential.Credential;
import io.quarkus.security.credential.TokenCredential;
import io.quarkus.security.identity.AuthenticationRequestContext;
import io.quarkus.security.identity.IdentityProvider;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.AuthenticationRequest;
import io.quarkus.security.identity.request.TokenAuthenticationRequest;
import io.quarkus.security.runtime.QuarkusSecurityIdentity;
import io.quarkus.security.spi.runtime.BlockingSecurityExecutor;
import io.quarkus.vertx.http.runtime.security.HttpSecurityUtils;
import io.smallrye.mutiny.Uni;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.context.ApplicationScoped;
import java.security.Principal;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.microprofile.jwt.Claims;
import org.jboss.logging.Logger;
import org.jose4j.lang.UnresolvableKeyException;

@ApplicationScoped
public class OidcIdentityProvider
implements IdentityProvider<TokenAuthenticationRequest> {
    private static final Logger LOG = Logger.getLogger(OidcIdentityProvider.class);
    static final String REFRESH_TOKEN_GRANT_RESPONSE = "refresh_token_grant_response";
    static final String NEW_AUTHENTICATION = "new_authentication";
    private static final Uni<TokenVerificationResult> NULL_CODE_ACCESS_TOKEN_UNI = Uni.createFrom().nullItem();
    protected final DefaultTenantConfigResolver tenantResolver;
    private final BlockingTaskRunner<Void> uniVoidOidcContext;
    private final BlockingTaskRunner<TokenIntrospection> getIntrospectionRequestContext;
    private final BlockingTaskRunner<UserInfo> getUserInfoRequestContext;

    OidcIdentityProvider(DefaultTenantConfigResolver tenantResolver, BlockingSecurityExecutor blockingExecutor) {
        this.tenantResolver = tenantResolver;
        this.uniVoidOidcContext = new BlockingTaskRunner(blockingExecutor);
        this.getIntrospectionRequestContext = new BlockingTaskRunner(blockingExecutor);
        this.getUserInfoRequestContext = new BlockingTaskRunner(blockingExecutor);
    }

    public Class<TokenAuthenticationRequest> getRequestType() {
        return TokenAuthenticationRequest.class;
    }

    public Uni<SecurityIdentity> authenticate(final TokenAuthenticationRequest request, AuthenticationRequestContext context) {
        if (!(request.getToken() instanceof AccessTokenCredential) && !(request.getToken() instanceof IdTokenCredential)) {
            return Uni.createFrom().nullItem();
        }
        LOG.debug((Object)"Starting creating SecurityIdentity");
        return this.resolveTenantConfigContext(request, context).onItem().transformToUni((Function)new Function<TenantConfigContext, Uni<? extends SecurityIdentity>>(){

            @Override
            public Uni<SecurityIdentity> apply(final TenantConfigContext tenantConfigContext) {
                return Uni.createFrom().deferred((Supplier)new Supplier<Uni<? extends SecurityIdentity>>(){

                    @Override
                    public Uni<SecurityIdentity> get() {
                        return OidcIdentityProvider.this.authenticate(request, OidcIdentityProvider.this.getRequestData(request), tenantConfigContext);
                    }
                });
            }
        });
    }

    protected Uni<TenantConfigContext> resolveTenantConfigContext(TokenAuthenticationRequest request, AuthenticationRequestContext context) {
        return this.tenantResolver.resolveContext(HttpSecurityUtils.getRoutingContextAttribute((AuthenticationRequest)request).put(AuthenticationRequestContext.class.getName(), (Object)context));
    }

    protected Map<String, Object> getRequestData(TokenAuthenticationRequest request) {
        return HttpSecurityUtils.getRoutingContextAttribute((AuthenticationRequest)request).data();
    }

    private Uni<SecurityIdentity> authenticate(TokenAuthenticationRequest request, Map<String, Object> requestData, TenantConfigContext resolvedContext) {
        if (resolvedContext.oidcConfig.authServerUrl.isPresent()) {
            return this.validateAllTokensWithOidcServer(requestData, request, resolvedContext);
        }
        if (resolvedContext.oidcConfig.getCertificateChain().trustStoreFile.isPresent()) {
            LOG.debug((Object)"Performing token verification with a public key inlined in the certificate chain");
            return OidcIdentityProvider.validateTokenWithoutOidcServer(request, resolvedContext);
        }
        if (resolvedContext.oidcConfig.publicKey.isPresent()) {
            LOG.debug((Object)"Performing token verification with a configured public key");
            return OidcIdentityProvider.validateTokenWithoutOidcServer(request, resolvedContext);
        }
        return Uni.createFrom().failure((Throwable)new OIDCException("Unexpected authentication request"));
    }

    private Uni<SecurityIdentity> validateAllTokensWithOidcServer(final Map<String, Object> requestData, final TokenAuthenticationRequest request, final TenantConfigContext resolvedContext) {
        if (resolvedContext.oidcConfig.token.verifyAccessTokenWithUserInfo.orElse(false).booleanValue() && this.isOpaqueAccessToken(requestData, request, resolvedContext)) {
            if (resolvedContext.oidcConfig.authentication.isUserInfoRequired().orElse(false).booleanValue()) {
                return this.getUserInfoUni(requestData, request, resolvedContext).onItemOrFailure().transformToUni((BiFunction)new BiFunction<UserInfo, Throwable, Uni<? extends SecurityIdentity>>(){

                    @Override
                    public Uni<SecurityIdentity> apply(UserInfo userInfo, Throwable t) {
                        if (t != null) {
                            return Uni.createFrom().failure((Throwable)new AuthenticationFailedException(t));
                        }
                        return OidcIdentityProvider.this.validateTokenWithUserInfoAndCreateIdentity(requestData, request, resolvedContext, userInfo);
                    }
                });
            }
            return this.validateTokenWithUserInfoAndCreateIdentity(requestData, request, resolvedContext, null);
        }
        Object primaryTokenUni = OidcIdentityProvider.isInternalIdToken(request) ? (requestData.get(NEW_AUTHENTICATION) == Boolean.TRUE ? Uni.createFrom().item((Object)new TokenVerificationResult(OidcUtils.decodeJwtContent(request.getToken().getToken()), null)) : this.verifySelfSignedTokenUni(resolvedContext, request.getToken().getToken())) : this.verifyTokenUni(requestData, resolvedContext, request.getToken(), OidcIdentityProvider.isIdToken(request), null);
        return this.getUserInfoAndCreateIdentity((Uni<TokenVerificationResult>)primaryTokenUni, requestData, request, resolvedContext);
    }

    private Uni<SecurityIdentity> validateTokenWithUserInfoAndCreateIdentity(final Map<String, Object> requestData, final TokenAuthenticationRequest request, final TenantConfigContext resolvedContext, final UserInfo userInfo) {
        Uni<TokenVerificationResult> codeAccessTokenUni = this.verifyCodeFlowAccessTokenUni(requestData, request, resolvedContext, userInfo);
        return codeAccessTokenUni.onItemOrFailure().transformToUni((BiFunction)new BiFunction<TokenVerificationResult, Throwable, Uni<? extends SecurityIdentity>>(){

            @Override
            public Uni<SecurityIdentity> apply(TokenVerificationResult codeAccessToken, Throwable t) {
                if (t != null) {
                    return Uni.createFrom().failure((Throwable)new AuthenticationFailedException(t));
                }
                if (codeAccessToken != null) {
                    requestData.put("code_flow_access_token_result", codeAccessToken);
                }
                Uni<TokenVerificationResult> tokenUni = OidcIdentityProvider.this.verifyTokenUni(requestData, resolvedContext, request.getToken(), false, userInfo);
                return tokenUni.onItemOrFailure().transformToUni((BiFunction)new BiFunction<TokenVerificationResult, Throwable, Uni<? extends SecurityIdentity>>(){

                    @Override
                    public Uni<SecurityIdentity> apply(TokenVerificationResult result, Throwable t) {
                        if (t != null) {
                            return Uni.createFrom().failure((Throwable)new AuthenticationFailedException(t));
                        }
                        return OidcIdentityProvider.this.createSecurityIdentityWithOidcServer(result, requestData, request, resolvedContext, userInfo);
                    }
                });
            }
        });
    }

    private Uni<SecurityIdentity> getUserInfoAndCreateIdentity(Uni<TokenVerificationResult> tokenUni, final Map<String, Object> requestData, final TokenAuthenticationRequest request, final TenantConfigContext resolvedContext) {
        return tokenUni.onItemOrFailure().transformToUni((BiFunction)new BiFunction<TokenVerificationResult, Throwable, Uni<? extends SecurityIdentity>>(){

            @Override
            public Uni<SecurityIdentity> apply(final TokenVerificationResult result, Throwable t) {
                if (t != null) {
                    return Uni.createFrom().failure((Throwable)new AuthenticationFailedException(t));
                }
                Uni<TokenVerificationResult> codeAccessTokenUni = OidcIdentityProvider.this.verifyCodeFlowAccessTokenUni(requestData, request, resolvedContext, null);
                return codeAccessTokenUni.onItemOrFailure().transformToUni((BiFunction)new BiFunction<TokenVerificationResult, Throwable, Uni<? extends SecurityIdentity>>(){

                    @Override
                    public Uni<SecurityIdentity> apply(TokenVerificationResult codeAccessTokenResult, Throwable t) {
                        if (t != null) {
                            return Uni.createFrom().failure(t instanceof AuthenticationFailedException ? t : new AuthenticationFailedException(t));
                        }
                        if (codeAccessTokenResult != null) {
                            if (OidcIdentityProvider.tokenAutoRefreshPrepared(codeAccessTokenResult, requestData, resolvedContext.oidcConfig)) {
                                return Uni.createFrom().failure((Throwable)new TokenAutoRefreshException(null));
                            }
                            requestData.put("code_flow_access_token_result", codeAccessTokenResult);
                        }
                        if (resolvedContext.oidcConfig.authentication.isUserInfoRequired().orElse(false).booleanValue()) {
                            return OidcIdentityProvider.this.getUserInfoUni(requestData, request, resolvedContext).onItemOrFailure().transformToUni((BiFunction)new BiFunction<UserInfo, Throwable, Uni<? extends SecurityIdentity>>(){

                                @Override
                                public Uni<SecurityIdentity> apply(UserInfo userInfo, Throwable t) {
                                    if (t != null) {
                                        return Uni.createFrom().failure((Throwable)new AuthenticationFailedException(t));
                                    }
                                    return OidcIdentityProvider.this.createSecurityIdentityWithOidcServer(result, requestData, request, resolvedContext, userInfo);
                                }
                            });
                        }
                        return OidcIdentityProvider.this.createSecurityIdentityWithOidcServer(result, requestData, request, resolvedContext, null);
                    }
                });
            }
        });
    }

    private boolean isOpaqueAccessToken(Map<String, Object> requestData, TokenAuthenticationRequest request, TenantConfigContext resolvedContext) {
        if (request.getToken() instanceof AccessTokenCredential) {
            return ((AccessTokenCredential)request.getToken()).isOpaque();
        }
        if (request.getToken() instanceof IdTokenCredential && (resolvedContext.oidcConfig.authentication.verifyAccessToken || resolvedContext.oidcConfig.roles.source.orElse(null) == OidcTenantConfig.Roles.Source.accesstoken)) {
            String codeAccessToken = (String)requestData.get("access_token");
            return OidcUtils.isOpaqueToken(codeAccessToken);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Uni<SecurityIdentity> createSecurityIdentityWithOidcServer(TokenVerificationResult result, Map<String, Object> requestData, TokenAuthenticationRequest request, TenantConfigContext resolvedContext, UserInfo userInfo) {
        String userName;
        QuarkusSecurityIdentity.Builder builder;
        block14: {
            TokenCredential tokenCred = request.getToken();
            JsonObject tokenJson = result.localVerificationResult;
            if (tokenJson == null) {
                tokenJson = OidcUtils.decodeJwtContent(tokenCred.getToken());
            }
            if (tokenJson != null) {
                try {
                    OidcUtils.validatePrimaryJwtTokenType(resolvedContext.oidcConfig.token, tokenJson);
                    if (userInfo != null && resolvedContext.oidcConfig.token.isSubjectRequired() && !tokenJson.getString(Claims.sub.name()).equals(userInfo.getString(Claims.sub.name()))) {
                        String errorMessage = String.format("Token and UserInfo do not have matching `sub` claims", new Object[0]);
                        return Uni.createFrom().failure((Throwable)new AuthenticationCompletionException(errorMessage));
                    }
                    JsonObject rolesJson = OidcIdentityProvider.getRolesJson(requestData, resolvedContext, tokenCred, tokenJson, userInfo);
                    QuarkusSecurityIdentity securityIdentity = OidcUtils.validateAndCreateIdentity(requestData, tokenCred, resolvedContext, tokenJson, rolesJson, userInfo, result.introspectionResult, request);
                    if (OidcIdentityProvider.isIdToken(request) && OidcIdentityProvider.tokenAutoRefreshPrepared(result, requestData, resolvedContext.oidcConfig)) {
                        return Uni.createFrom().failure((Throwable)new TokenAutoRefreshException((SecurityIdentity)securityIdentity));
                    }
                    return Uni.createFrom().item((Object)securityIdentity);
                }
                catch (Throwable ex) {
                    return Uni.createFrom().failure((Throwable)new AuthenticationFailedException(ex));
                }
            }
            if (OidcIdentityProvider.isIdToken(request) || tokenCred instanceof AccessTokenCredential && !((AccessTokenCredential)tokenCred).isOpaque()) {
                return Uni.createFrom().failure((Throwable)new AuthenticationFailedException("JWT token can not be converted to JSON"));
            }
            builder = QuarkusSecurityIdentity.builder();
            builder.addCredential((Credential)tokenCred);
            OidcUtils.setSecurityIdentityUserInfo(builder, userInfo);
            OidcUtils.setSecurityIdentityConfigMetadata(builder, resolvedContext);
            if (result.introspectionResult == null) {
                if (resolvedContext.oidcConfig.token.allowOpaqueTokenIntrospection && resolvedContext.oidcConfig.token.verifyAccessTokenWithUserInfo.orElse(false).booleanValue()) {
                    userName = resolvedContext.oidcConfig.token.principalClaim.isPresent() && userInfo != null ? userInfo.getString(resolvedContext.oidcConfig.token.principalClaim.get()) : "";
                    break block14;
                } else {
                    LOG.debug((Object)"Illegal state - token introspection result is not available.");
                    return Uni.createFrom().failure((Throwable)new AuthenticationFailedException());
                }
            }
            OidcUtils.setSecurityIdentityIntrospection(builder, result.introspectionResult);
            String principalName = result.introspectionResult.getUsername();
            if (principalName == null) {
                principalName = result.introspectionResult.getSubject();
            }
            userName = principalName != null ? principalName : "";
            Set<String> scopes = result.introspectionResult.getScopes();
            if (scopes != null) {
                builder.addRoles(scopes);
                OidcUtils.addTokenScopesAsPermissions(builder, scopes);
            }
        }
        builder.setPrincipal(new Principal(){

            @Override
            public String getName() {
                return userName != null ? userName : "";
            }
        });
        if (userInfo != null) {
            JsonObject rolesJson = new JsonObject(userInfo.getJsonObject().toString());
            OidcUtils.setSecurityIdentityRoles(builder, resolvedContext.oidcConfig, rolesJson);
            OidcUtils.setSecurityIdentityPermissions(builder, resolvedContext.oidcConfig, rolesJson);
        }
        OidcUtils.setTenantIdAttribute(builder, resolvedContext.oidcConfig);
        RoutingContext vertxContext = HttpSecurityUtils.getRoutingContextAttribute((AuthenticationRequest)request);
        OidcUtils.setBlockingApiAttribute(builder, vertxContext);
        OidcUtils.setRoutingContextAttribute(builder, vertxContext);
        QuarkusSecurityIdentity identity = builder.build();
        if (OidcIdentityProvider.isIdToken(request) && OidcIdentityProvider.tokenAutoRefreshPrepared(result, requestData, resolvedContext.oidcConfig)) {
            return Uni.createFrom().failure((Throwable)new TokenAutoRefreshException((SecurityIdentity)identity));
        }
        return Uni.createFrom().item((Object)identity);
    }

    private static boolean isInternalIdToken(TokenAuthenticationRequest request) {
        return OidcIdentityProvider.isIdToken(request) && ((IdTokenCredential)request.getToken()).isInternal();
    }

    private static boolean isIdToken(TokenAuthenticationRequest request) {
        return request.getToken() instanceof IdTokenCredential;
    }

    private static boolean tokenAutoRefreshPrepared(TokenVerificationResult result, Map<String, Object> requestData, OidcTenantConfig oidcConfig) {
        if (result != null && oidcConfig.token.refreshExpired && oidcConfig.token.getRefreshTokenTimeSkew().isPresent() && requestData.get(REFRESH_TOKEN_GRANT_RESPONSE) != Boolean.TRUE && requestData.get(NEW_AUTHENTICATION) != Boolean.TRUE) {
            Long expiry = null;
            if (result.localVerificationResult != null) {
                expiry = result.localVerificationResult.getLong(Claims.exp.name());
            } else if (result.introspectionResult != null) {
                expiry = result.introspectionResult.getLong("exp");
            }
            if (expiry != null) {
                long refreshTokenTimeSkew = oidcConfig.token.getRefreshTokenTimeSkew().get().getSeconds();
                long now = System.currentTimeMillis() / 1000L;
                return now + refreshTokenTimeSkew > expiry;
            }
        }
        return false;
    }

    private static JsonObject getRolesJson(Map<String, Object> requestData, TenantConfigContext resolvedContext, TokenCredential tokenCred, JsonObject tokenJson, UserInfo userInfo) {
        JsonObject rolesJson = tokenJson;
        if (resolvedContext.oidcConfig.roles.source.isPresent()) {
            if (resolvedContext.oidcConfig.roles.source.get() == OidcTenantConfig.Roles.Source.userinfo) {
                rolesJson = new JsonObject(userInfo.getJsonObject().toString());
            } else if (tokenCred instanceof IdTokenCredential && resolvedContext.oidcConfig.roles.source.get() == OidcTenantConfig.Roles.Source.accesstoken && (rolesJson = ((TokenVerificationResult)requestData.get((Object)"code_flow_access_token_result")).localVerificationResult) == null) {
                rolesJson = OidcUtils.decodeJwtContent((String)requestData.get("access_token"));
            }
        }
        return rolesJson;
    }

    private Uni<TokenVerificationResult> verifyCodeFlowAccessTokenUni(Map<String, Object> requestData, TokenAuthenticationRequest request, TenantConfigContext resolvedContext, UserInfo userInfo) {
        if (request.getToken() instanceof IdTokenCredential && (resolvedContext.oidcConfig.authentication.verifyAccessToken || resolvedContext.oidcConfig.roles.source.orElse(null) == OidcTenantConfig.Roles.Source.accesstoken)) {
            String codeAccessToken = (String)requestData.get("access_token");
            return this.verifyTokenUni(requestData, resolvedContext, new AccessTokenCredential(codeAccessToken), false, userInfo);
        }
        return NULL_CODE_ACCESS_TOKEN_UNI;
    }

    private Uni<TokenVerificationResult> verifyTokenUni(Map<String, Object> requestData, TenantConfigContext resolvedContext, TokenCredential tokenCred, boolean enforceAudienceVerification, UserInfo userInfo) {
        String token = tokenCred.getToken();
        if (OidcUtils.isOpaqueToken(token)) {
            if (!resolvedContext.oidcConfig.token.allowOpaqueTokenIntrospection) {
                LOG.debug((Object)"Token is opaque but the opaque token introspection is not allowed");
                throw new AuthenticationFailedException();
            }
            if (resolvedContext.oidcConfig.token.verifyAccessTokenWithUserInfo.orElse(false).booleanValue() && resolvedContext.provider.getMetadata().getIntrospectionUri() == null) {
                if (userInfo == null) {
                    return Uni.createFrom().failure((Throwable)new AuthenticationFailedException("Opaque access token verification failed as user info is null."));
                }
                return Uni.createFrom().item((Object)new TokenVerificationResult(null, null));
            }
            LOG.debug((Object)"Starting the opaque token introspection");
            return this.introspectTokenUni(resolvedContext, token, false);
        }
        if (resolvedContext.provider.getMetadata().getJsonWebKeySetUri() == null || resolvedContext.oidcConfig.token.requireJwtIntrospectionOnly) {
            LOG.debug((Object)"Starting the JWT token introspection");
            return this.introspectTokenUni(resolvedContext, token, false);
        }
        if (resolvedContext.oidcConfig.jwks.resolveEarly) {
            String nonce = (String)requestData.get("nonce");
            try {
                LOG.debug((Object)"Verifying the JWT token with the local JWK keys");
                return Uni.createFrom().item((Object)resolvedContext.provider.verifyJwtToken(token, enforceAudienceVerification, resolvedContext.oidcConfig.token.isSubjectRequired(), nonce));
            }
            catch (Throwable t) {
                if (t.getCause() instanceof UnresolvableKeyException) {
                    LOG.debug((Object)"No matching JWK key is found, refreshing and repeating the verification");
                    return this.refreshJwksAndVerifyTokenUni(resolvedContext, token, enforceAudienceVerification, resolvedContext.oidcConfig.token.isSubjectRequired(), nonce);
                }
                LOG.debugf("Token verification has failed: %s", (Object)t.getMessage());
                return Uni.createFrom().failure(t);
            }
        }
        String nonce = (String)requestData.get("nonce");
        return this.resolveJwksAndVerifyTokenUni(resolvedContext, tokenCred, enforceAudienceVerification, resolvedContext.oidcConfig.token.isSubjectRequired(), nonce);
    }

    private Uni<TokenVerificationResult> verifySelfSignedTokenUni(TenantConfigContext resolvedContext, String token) {
        try {
            return Uni.createFrom().item((Object)resolvedContext.provider.verifySelfSignedJwtToken(token));
        }
        catch (Throwable t) {
            return Uni.createFrom().failure(t);
        }
    }

    private Uni<TokenVerificationResult> refreshJwksAndVerifyTokenUni(TenantConfigContext resolvedContext, String token, boolean enforceAudienceVerification, boolean subjectRequired, String nonce) {
        return resolvedContext.provider.refreshJwksAndVerifyJwtToken(token, enforceAudienceVerification, subjectRequired, nonce).onFailure(f -> OidcIdentityProvider.fallbackToIntrospectionIfNoMatchingKey(f, resolvedContext)).recoverWithUni(f -> this.introspectTokenUni(resolvedContext, token, true));
    }

    private Uni<TokenVerificationResult> resolveJwksAndVerifyTokenUni(TenantConfigContext resolvedContext, TokenCredential tokenCred, boolean enforceAudienceVerification, boolean subjectRequired, String nonce) {
        return resolvedContext.provider.getKeyResolverAndVerifyJwtToken(tokenCred, enforceAudienceVerification, subjectRequired, nonce, tokenCred instanceof IdTokenCredential).onFailure(f -> OidcIdentityProvider.fallbackToIntrospectionIfNoMatchingKey(f, resolvedContext)).recoverWithUni(f -> this.introspectTokenUni(resolvedContext, tokenCred.getToken(), true));
    }

    private static boolean fallbackToIntrospectionIfNoMatchingKey(Throwable f, TenantConfigContext resolvedContext) {
        if (!(f.getCause() instanceof UnresolvableKeyException)) {
            LOG.debug((Object)"Local JWT token verification has failed, skipping the token introspection");
            return false;
        }
        if (!resolvedContext.oidcConfig.token.allowJwtIntrospection) {
            LOG.debug((Object)"JWT token does not have a matching verification key but JWT token introspection is disabled");
            return false;
        }
        LOG.debug((Object)"Local JWT token verification has failed, attempting the token introspection");
        return true;
    }

    private Uni<TokenVerificationResult> introspectTokenUni(final TenantConfigContext resolvedContext, final String token, final boolean fallbackFromJwkMatch) {
        TokenIntrospectionCache tokenIntrospectionCache = this.tenantResolver.getTokenIntrospectionCache();
        Object tokenIntrospectionUni = tokenIntrospectionCache == null ? null : tokenIntrospectionCache.getIntrospection(token, resolvedContext.oidcConfig, this.getIntrospectionRequestContext);
        tokenIntrospectionUni = tokenIntrospectionUni == null ? this.newTokenIntrospectionUni(resolvedContext, token, fallbackFromJwkMatch) : tokenIntrospectionUni.onItem().ifNull().switchTo((Supplier)new Supplier<Uni<? extends TokenIntrospection>>(){

            @Override
            public Uni<TokenIntrospection> get() {
                return OidcIdentityProvider.this.newTokenIntrospectionUni(resolvedContext, token, fallbackFromJwkMatch);
            }
        });
        return tokenIntrospectionUni.onItem().transform(t -> new TokenVerificationResult(null, (TokenIntrospection)t));
    }

    private Uni<TokenIntrospection> newTokenIntrospectionUni(final TenantConfigContext resolvedContext, final String token, boolean fallbackFromJwkMatch) {
        Uni<TokenIntrospection> tokenIntrospectionUni = resolvedContext.provider.introspectToken(token, fallbackFromJwkMatch);
        if (this.tenantResolver.getTokenIntrospectionCache() == null || !resolvedContext.oidcConfig.allowTokenIntrospectionCache) {
            return tokenIntrospectionUni;
        }
        return tokenIntrospectionUni.call(new Function<TokenIntrospection, Uni<?>>(){

            @Override
            public Uni<?> apply(TokenIntrospection introspection) {
                return OidcIdentityProvider.this.tenantResolver.getTokenIntrospectionCache().addIntrospection(token, introspection, resolvedContext.oidcConfig, OidcIdentityProvider.this.uniVoidOidcContext);
            }
        });
    }

    private static Uni<SecurityIdentity> validateTokenWithoutOidcServer(TokenAuthenticationRequest request, TenantConfigContext resolvedContext) {
        try {
            TokenVerificationResult result = resolvedContext.provider.verifyJwtToken(request.getToken().getToken(), resolvedContext.oidcConfig.token.subjectRequired, false, null);
            return Uni.createFrom().item((Object)OidcUtils.validateAndCreateIdentity(Map.of(), request.getToken(), resolvedContext, result.localVerificationResult, result.localVerificationResult, null, null, request));
        }
        catch (Throwable t) {
            return Uni.createFrom().failure((Throwable)new AuthenticationFailedException(t));
        }
    }

    private Uni<UserInfo> getUserInfoUni(Map<String, Object> requestData, TokenAuthenticationRequest request, final TenantConfigContext resolvedContext) {
        JsonObject userInfo;
        if (OidcIdentityProvider.isInternalIdToken(request) && resolvedContext.oidcConfig.cacheUserInfoInIdtoken && (userInfo = OidcUtils.decodeJwtContent(request.getToken().getToken()).getJsonObject("userinfo")) != null) {
            return Uni.createFrom().item((Object)new UserInfo(userInfo.encode()));
        }
        LOG.debug((Object)"Requesting UserInfo");
        String contextAccessToken = (String)requestData.get("access_token");
        final String accessToken = contextAccessToken != null ? contextAccessToken : request.getToken().getToken();
        UserInfoCache userInfoCache = this.tenantResolver.getUserInfoCache();
        Object userInfoUni = userInfoCache == null ? null : userInfoCache.getUserInfo(accessToken, resolvedContext.oidcConfig, this.getUserInfoRequestContext);
        userInfoUni = userInfoUni == null ? this.newUserInfoUni(resolvedContext, accessToken) : userInfoUni.onItem().ifNull().switchTo((Supplier)new Supplier<Uni<? extends UserInfo>>(){

            @Override
            public Uni<UserInfo> get() {
                return OidcIdentityProvider.this.newUserInfoUni(resolvedContext, accessToken);
            }
        });
        return userInfoUni;
    }

    private Uni<UserInfo> newUserInfoUni(final TenantConfigContext resolvedContext, final String accessToken) {
        Uni<UserInfo> userInfoUni = resolvedContext.provider.getUserInfo(accessToken);
        if (this.tenantResolver.getUserInfoCache() == null || !resolvedContext.oidcConfig.allowUserInfoCache || resolvedContext.oidcConfig.cacheUserInfoInIdtoken) {
            return userInfoUni;
        }
        return userInfoUni.call(new Function<UserInfo, Uni<?>>(){

            @Override
            public Uni<?> apply(UserInfo userInfo) {
                return OidcIdentityProvider.this.tenantResolver.getUserInfoCache().addUserInfo(accessToken, userInfo, resolvedContext.oidcConfig, OidcIdentityProvider.this.uniVoidOidcContext);
            }
        });
    }
}

