/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.events.GlobalEventEmitterProvider;
import io.opentelemetry.context.ContextStorage;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdkBuilder;
import io.quarkus.arc.SyntheticCreationalContext;
import io.quarkus.opentelemetry.runtime.AutoConfiguredOpenTelemetrySdkBuilderCustomizer;
import io.quarkus.opentelemetry.runtime.QuarkusContextStorage;
import io.quarkus.opentelemetry.runtime.config.runtime.OTelRuntimeConfig;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.runtime.configuration.DurationConverter;
import io.smallrye.config.SmallRyeConfig;
import io.vertx.core.Vertx;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.util.TypeLiteral;
import java.lang.annotation.Annotation;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.spi.Converter;

@Recorder
public class OpenTelemetryRecorder {
    public static final String OPEN_TELEMETRY_DRIVER = "io.opentelemetry.instrumentation.jdbc.OpenTelemetryDriver";

    public void resetGlobalOpenTelemetryForDevMode() {
        GlobalOpenTelemetry.resetForTest();
        GlobalEventEmitterProvider.resetForTest();
    }

    public void eagerlyCreateContextStorage() {
        ContextStorage.get();
    }

    public void storeVertxOnContextStorage(Supplier<Vertx> vertx) {
        QuarkusContextStorage.vertx = vertx.get();
    }

    public Function<SyntheticCreationalContext<OpenTelemetry>, OpenTelemetry> opentelemetryBean(final OTelRuntimeConfig oTelRuntimeConfig) {
        return new Function<SyntheticCreationalContext<OpenTelemetry>, OpenTelemetry>(){

            @Override
            public OpenTelemetry apply(SyntheticCreationalContext<OpenTelemetry> context) {
                Instance builderCustomizers = (Instance)context.getInjectedReference((TypeLiteral)new TypeLiteral<Instance<AutoConfiguredOpenTelemetrySdkBuilderCustomizer>>(){}, new Annotation[0]);
                Map<String, String> oTelConfigs = this.getOtelConfigs();
                if (oTelRuntimeConfig.sdkDisabled()) {
                    return AutoConfiguredOpenTelemetrySdk.builder().setResultAsGlobal().disableShutdownHook().addPropertiesSupplier(() -> oTelConfigs).build().getOpenTelemetrySdk();
                }
                AutoConfiguredOpenTelemetrySdkBuilder builder = AutoConfiguredOpenTelemetrySdk.builder().setResultAsGlobal().disableShutdownHook().addPropertiesSupplier(() -> oTelConfigs).setServiceClassLoader(Thread.currentThread().getContextClassLoader());
                for (AutoConfiguredOpenTelemetrySdkBuilderCustomizer customizer : builderCustomizers) {
                    customizer.customize(builder);
                }
                return builder.build().getOpenTelemetrySdk();
            }

            private Map<String, String> getOtelConfigs() {
                HashMap<String, String> oTelConfigs = new HashMap<String, String>();
                SmallRyeConfig config = (SmallRyeConfig)ConfigProvider.getConfig().unwrap(SmallRyeConfig.class);
                oTelConfigs.put("otel.java.global-autoconfigure.enabled", "true");
                HashMap<String, String> otel = new HashMap<String, String>();
                HashMap<String, String> quarkus = new HashMap<String, String>();
                for (String propertyName : config.getPropertyNames()) {
                    String value;
                    if (propertyName.startsWith("quarkus.otel.")) {
                        value = (String)config.getValue(propertyName, String.class);
                        if (propertyName.endsWith("timeout") || propertyName.endsWith("delay")) {
                            value = OTelDurationConverter.INSTANCE.convert(value);
                        }
                        quarkus.put(propertyName.substring(8), value);
                        continue;
                    }
                    if (!propertyName.startsWith("otel.") || (value = config.getConfigValue(propertyName)).getValue() == null) continue;
                    otel.put(propertyName, value.getValue());
                }
                if (oTelRuntimeConfig.mpCompatibility()) {
                    oTelConfigs.putAll(quarkus);
                    oTelConfigs.putAll(otel);
                } else {
                    oTelConfigs.putAll(otel);
                    oTelConfigs.putAll(quarkus);
                }
                return oTelConfigs;
            }
        };
    }

    private static class OTelDurationConverter
    implements Converter<String> {
        static OTelDurationConverter INSTANCE = new OTelDurationConverter();

        private OTelDurationConverter() {
        }

        public String convert(String value) throws IllegalArgumentException, NullPointerException {
            Duration duration;
            if (value == null) {
                throw new NullPointerException();
            }
            if (DurationConverter.DIGITS.asPredicate().test(value)) {
                return value;
            }
            try {
                duration = DurationConverter.parseDuration((String)value);
            }
            catch (Exception ignored) {
                return value;
            }
            if (duration == null) {
                return value;
            }
            try {
                return duration.toMillis() + "ms";
            }
            catch (Exception ignored) {
                return duration.toSeconds() + "s";
            }
        }
    }
}

