/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime.tracing.intrumentation.vertx;

import io.netty.handler.codec.http.HttpHeaders;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.quarkus.opentelemetry.runtime.QuarkusContextStorage;
import io.quarkus.opentelemetry.runtime.tracing.intrumentation.vertx.OpenTelemetryVertxTracer;
import io.vertx.core.MultiMap;
import io.vertx.core.http.impl.headers.HeadersAdaptor;
import io.vertx.core.http.impl.headers.HeadersMultiMap;
import io.vertx.core.spi.tracing.SpanKind;
import io.vertx.core.spi.tracing.TagExtractor;
import io.vertx.core.spi.tracing.VertxTracer;
import io.vertx.core.tracing.TracingPolicy;
import java.util.Map;
import java.util.function.BiConsumer;

public interface InstrumenterVertxTracer<REQ, RESP>
extends VertxTracer<OpenTelemetryVertxTracer.SpanOperation, OpenTelemetryVertxTracer.SpanOperation> {
    default public <R> OpenTelemetryVertxTracer.SpanOperation receiveRequest(io.vertx.core.Context context, SpanKind kind, TracingPolicy policy, R request, String operation, Iterable<Map.Entry<String, String>> headers, TagExtractor<R> tagExtractor) {
        Instrumenter<REQ, RESP> instrumenter = this.getReceiveRequestInstrumenter();
        Context parentContext = QuarkusContextStorage.getContext(context);
        if (parentContext == null) {
            parentContext = Context.current();
        }
        if (instrumenter.shouldStart(parentContext, request)) {
            Context spanContext = instrumenter.start(parentContext, request);
            Scope scope = QuarkusContextStorage.INSTANCE.attach(context, spanContext);
            return this.spanOperation(context, request, InstrumenterVertxTracer.toMultiMap(headers), spanContext, scope);
        }
        return null;
    }

    default public <R> void sendResponse(io.vertx.core.Context context, R response, OpenTelemetryVertxTracer.SpanOperation spanOperation, Throwable failure, TagExtractor<R> tagExtractor) {
        if (spanOperation == null) {
            return;
        }
        Scope scope = spanOperation.getScope();
        if (scope == null) {
            return;
        }
        Object request = spanOperation.getRequest();
        Instrumenter<REQ, RESP> instrumenter = this.getSendResponseInstrumenter();
        try (Scope scope2 = scope;){
            instrumenter.end(spanOperation.getSpanContext(), request, response, failure);
        }
    }

    default public <R> OpenTelemetryVertxTracer.SpanOperation sendRequest(io.vertx.core.Context context, SpanKind kind, TracingPolicy policy, R request, String operation, BiConsumer<String, String> headers, TagExtractor<R> tagExtractor) {
        Instrumenter<REQ, RESP> instrumenter = this.getSendRequestInstrumenter();
        Context parentContext = QuarkusContextStorage.getContext(context);
        if (parentContext == null) {
            parentContext = Context.current();
        }
        if (instrumenter.shouldStart(parentContext, request)) {
            Context spanContext = instrumenter.start(parentContext, this.writableHeaders(request, headers));
            Scope scope = new Scope(){

                public void close() {
                }
            };
            return this.spanOperation(context, request, InstrumenterVertxTracer.toMultiMap(headers), spanContext, scope);
        }
        return null;
    }

    default public <R> void receiveResponse(io.vertx.core.Context context, R response, OpenTelemetryVertxTracer.SpanOperation spanOperation, Throwable failure, TagExtractor<R> tagExtractor) {
        if (spanOperation == null) {
            return;
        }
        Scope scope = spanOperation.getScope();
        if (scope == null) {
            return;
        }
        Object request = spanOperation.getRequest();
        Instrumenter<REQ, RESP> instrumenter = this.getReceiveResponseInstrumenter();
        try (Scope scope2 = scope;){
            instrumenter.end(spanOperation.getSpanContext(), request, response, failure);
        }
    }

    public <R> boolean canHandle(R var1, TagExtractor<R> var2);

    public Instrumenter<REQ, RESP> getReceiveRequestInstrumenter();

    public Instrumenter<REQ, RESP> getSendResponseInstrumenter();

    public Instrumenter<REQ, RESP> getSendRequestInstrumenter();

    public Instrumenter<REQ, RESP> getReceiveResponseInstrumenter();

    default public OpenTelemetryVertxTracer.SpanOperation spanOperation(io.vertx.core.Context context, REQ request, MultiMap headers, Context spanContext, Scope scope) {
        return OpenTelemetryVertxTracer.SpanOperation.span(context, request, headers, spanContext, scope);
    }

    default public REQ writableHeaders(REQ request, BiConsumer<String, String> headers) {
        return request;
    }

    private static MultiMap toMultiMap(Iterable<Map.Entry<String, String>> headers) {
        MultiMap headersMultiMap;
        if (headers instanceof MultiMap) {
            headersMultiMap = (MultiMap)headers;
        } else {
            headersMultiMap = new HeadersMultiMap();
            for (Map.Entry<String, String> header : headers) {
                headersMultiMap.add(header.getKey(), header.getValue());
            }
        }
        return headersMultiMap;
    }

    private static MultiMap toMultiMap(final BiConsumer<String, String> headers) {
        return new HeadersAdaptor((HttpHeaders)new HeadersMultiMap()){

            public MultiMap set(String name, String value) {
                MultiMap result = super.set(name, value);
                headers.accept(name, value);
                return result;
            }
        };
    }
}

