/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.quartz.runtime;

import com.cronutils.mapper.CronMapper;
import com.cronutils.model.Cron;
import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinition;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.parser.CronParser;
import io.quarkus.quartz.runtime.QuarkusQuartzConnectionPoolProvider;
import io.quarkus.quartz.runtime.QuartzBuildTimeConfig;
import io.quarkus.quartz.runtime.QuartzExtensionPointConfig;
import io.quarkus.quartz.runtime.QuartzRuntimeConfig;
import io.quarkus.quartz.runtime.QuartzStartMode;
import io.quarkus.quartz.runtime.QuartzSupport;
import io.quarkus.runtime.StartupEvent;
import io.quarkus.scheduler.Scheduled;
import io.quarkus.scheduler.ScheduledExecution;
import io.quarkus.scheduler.SkippedExecution;
import io.quarkus.scheduler.Trigger;
import io.quarkus.scheduler.runtime.ScheduledInvoker;
import io.quarkus.scheduler.runtime.ScheduledMethodMetadata;
import io.quarkus.scheduler.runtime.SchedulerContext;
import io.quarkus.scheduler.runtime.SchedulerRuntimeConfig;
import io.quarkus.scheduler.runtime.SimpleScheduler;
import io.quarkus.scheduler.runtime.SkipConcurrentExecutionInvoker;
import java.lang.annotation.Annotation;
import java.time.Instant;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.annotation.PreDestroy;
import javax.annotation.Priority;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.BeforeDestroyed;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.inject.Singleton;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.eclipse.microprofile.config.Config;
import org.jboss.logging.Logger;
import org.quartz.CronScheduleBuilder;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.simpl.InitThreadContextClassLoadHelper;
import org.quartz.simpl.SimpleJobFactory;
import org.quartz.spi.JobFactory;
import org.quartz.spi.TriggerFiredBundle;

@Singleton
public class QuartzScheduler
implements io.quarkus.scheduler.Scheduler {
    private static final Logger LOGGER = Logger.getLogger((String)QuartzScheduler.class.getName());
    private static final String INVOKER_KEY = "invoker";
    private final Scheduler scheduler;
    private final boolean enabled;
    private final boolean startHalted;

    public QuartzScheduler(SchedulerContext context, QuartzSupport quartzSupport, Config config, SchedulerRuntimeConfig schedulerRuntimeConfig, Event<SkippedExecution> skippedExecutionEvent, Instance<Job> jobs, Instance<UserTransaction> userTransation) {
        boolean forceStart;
        this.enabled = schedulerRuntimeConfig.enabled;
        QuartzRuntimeConfig runtimeConfig = quartzSupport.getRuntimeConfig();
        QuartzScheduler.warnDeprecated(runtimeConfig);
        if (runtimeConfig.startMode != QuartzStartMode.NORMAL) {
            this.startHalted = runtimeConfig.startMode == QuartzStartMode.HALTED;
            forceStart = this.startHalted || runtimeConfig.startMode == QuartzStartMode.FORCED;
        } else {
            this.startHalted = false;
            forceStart = runtimeConfig.forceStart.orElse(false);
        }
        if (!this.enabled) {
            LOGGER.info((Object)"Quartz scheduler is disabled by config property and will not be started");
            this.scheduler = null;
        } else if (!forceStart && context.getScheduledMethods().isEmpty()) {
            LOGGER.info((Object)"No scheduled business methods found - Quartz scheduler will not be started");
            this.scheduler = null;
        } else {
            HashMap<String, ScheduledInvoker> invokers = new HashMap<String, ScheduledInvoker>();
            UserTransaction transaction = null;
            try {
                boolean manageTx = quartzSupport.getBuildTimeConfig().storeType.isNonManagedTxJobStore();
                if (manageTx && userTransation.isResolvable()) {
                    transaction = (UserTransaction)userTransation.get();
                }
                Properties props = this.getSchedulerConfigurationProperties(quartzSupport);
                StdSchedulerFactory schedulerFactory = new StdSchedulerFactory(props);
                this.scheduler = schedulerFactory.getScheduler();
                this.scheduler.setJobFactory((JobFactory)new InvokerJobFactory(invokers, jobs));
                CronType cronType = context.getCronType();
                CronDefinition def = CronDefinitionBuilder.instanceDefinitionFor((CronType)cronType);
                CronParser parser = new CronParser(def);
                if (transaction != null) {
                    transaction.begin();
                }
                for (ScheduledMethodMetadata method : context.getScheduledMethods()) {
                    int nameSequence = 0;
                    for (Scheduled scheduled : method.getSchedules()) {
                        JobDetail job;
                        CronScheduleBuilder scheduleBuilder;
                        String identity = scheduled.identity().trim();
                        if (identity.isEmpty()) {
                            identity = ++nameSequence + "_" + method.getInvokerClassName();
                        }
                        ScheduledInvoker invoker = context.createInvoker(method.getInvokerClassName());
                        if (scheduled.concurrentExecution() == Scheduled.ConcurrentExecution.SKIP) {
                            invoker = new SkipConcurrentExecutionInvoker(invoker, skippedExecutionEvent);
                        }
                        invokers.put(identity, invoker);
                        JobBuilder jobBuilder = JobBuilder.newJob(InvokerJob.class).withIdentity(identity, io.quarkus.scheduler.Scheduler.class.getName()).usingJobData(INVOKER_KEY, method.getInvokerClassName()).requestRecovery();
                        String cron = scheduled.cron().trim();
                        if (!cron.isEmpty()) {
                            if (SchedulerContext.isConfigValue((String)cron)) {
                                cron = (String)config.getValue(SchedulerContext.getConfigProperty((String)cron), String.class);
                            }
                            if (!CronType.QUARTZ.equals((Object)cronType)) {
                                Cron cronExpr = parser.parse(cron);
                                switch (cronType) {
                                    case UNIX: {
                                        cron = CronMapper.fromUnixToQuartz().map(cronExpr).asString();
                                        break;
                                    }
                                    case CRON4J: {
                                        cron = CronMapper.fromCron4jToQuartz().map(cronExpr).asString();
                                        break;
                                    }
                                }
                            }
                            scheduleBuilder = CronScheduleBuilder.cronSchedule((String)cron);
                        } else if (!scheduled.every().isEmpty()) {
                            scheduleBuilder = SimpleScheduleBuilder.simpleSchedule().withIntervalInMilliseconds(SimpleScheduler.parseDuration((Scheduled)scheduled, (String)scheduled.every(), (String)"every").toMillis()).repeatForever();
                        } else {
                            throw new IllegalArgumentException("Invalid schedule configuration: " + scheduled);
                        }
                        TriggerBuilder triggerBuilder = TriggerBuilder.newTrigger().withIdentity(identity + "_trigger", io.quarkus.scheduler.Scheduler.class.getName()).withSchedule((ScheduleBuilder)scheduleBuilder);
                        Long millisToAdd = null;
                        if (scheduled.delay() > 0L) {
                            millisToAdd = scheduled.delayUnit().toMillis(scheduled.delay());
                        } else if (!scheduled.delayed().isEmpty()) {
                            millisToAdd = Math.abs(SimpleScheduler.parseDuration((Scheduled)scheduled, (String)scheduled.delayed(), (String)"delayed").toMillis());
                        }
                        if (millisToAdd != null) {
                            triggerBuilder.startAt(new Date(Instant.now().plusMillis(millisToAdd).toEpochMilli()));
                        }
                        if (this.scheduler.checkExists((job = jobBuilder.build()).getKey())) continue;
                        this.scheduler.scheduleJob(job, triggerBuilder.build());
                        LOGGER.debugf("Scheduled business method %s with config %s", (Object)method.getMethodDescription(), (Object)scheduled);
                    }
                }
                if (transaction != null) {
                    transaction.commit();
                }
            }
            catch (Throwable e) {
                if (transaction != null) {
                    try {
                        transaction.rollback();
                    }
                    catch (SystemException ex) {
                        LOGGER.error((Object)"Unable to rollback transaction", (Throwable)ex);
                    }
                }
                throw new IllegalStateException("Unable to create Scheduler", e);
            }
        }
    }

    private static void warnDeprecated(QuartzRuntimeConfig runtimeConfig) {
        if (runtimeConfig.forceStart.isPresent()) {
            LOGGER.warn((Object)"`quarkus.quartz.force-start` is deprecated and will be removed in a future version - it is recommended to switch to `quarkus.quartz.start-mode`");
        }
    }

    @Produces
    @Singleton
    Scheduler produceQuartzScheduler() {
        if (this.scheduler == null) {
            throw new IllegalStateException("Quartz scheduler is either explicitly disabled through quarkus.scheduler.enabled=false or no @Scheduled methods were found. If you only need to schedule a job programmatically you can force the start of the scheduler via quarkus.quartz.force-start=true");
        }
        return this.scheduler;
    }

    public void pause() {
        if (!this.enabled) {
            LOGGER.warn((Object)"Quartz Scheduler is disabled and cannot be paused");
        } else {
            try {
                if (this.scheduler != null) {
                    this.scheduler.standby();
                }
            }
            catch (SchedulerException e) {
                LOGGER.warn((Object)"Unable to pause scheduler", (Throwable)e);
            }
        }
    }

    public void resume() {
        if (!this.enabled) {
            LOGGER.warn((Object)"Quartz Scheduler is disabled and cannot be resumed");
        } else {
            try {
                if (this.scheduler != null) {
                    this.scheduler.start();
                }
            }
            catch (SchedulerException e) {
                LOGGER.warn((Object)"Unable to resume scheduler", (Throwable)e);
            }
        }
    }

    public boolean isRunning() {
        if (!this.enabled || this.scheduler == null) {
            return false;
        }
        try {
            return !this.scheduler.isInStandbyMode();
        }
        catch (SchedulerException e) {
            throw new IllegalStateException("Could not evaluate standby mode", e);
        }
    }

    void start(@Observes @Priority(value=0) StartupEvent startupEvent) {
        if (this.scheduler == null || this.startHalted) {
            return;
        }
        try {
            this.scheduler.start();
        }
        catch (SchedulerException e) {
            throw new IllegalStateException("Unable to start Scheduler", e);
        }
    }

    void destroy(@Observes @BeforeDestroyed(value=ApplicationScoped.class) Object event) {
        if (this.scheduler != null) {
            try {
                this.scheduler.shutdown(true);
            }
            catch (SchedulerException e) {
                LOGGER.warnf("Unable to gracefully shutdown the scheduler", (Object)e);
            }
        }
    }

    @PreDestroy
    void destroy() {
        if (this.scheduler != null) {
            try {
                if (!this.scheduler.isShutdown()) {
                    this.scheduler.shutdown(false);
                }
            }
            catch (SchedulerException e) {
                LOGGER.warnf("Unable to shutdown the scheduler", (Object)e);
            }
        }
    }

    private Properties getSchedulerConfigurationProperties(QuartzSupport quartzSupport) {
        Properties props = new Properties();
        QuartzBuildTimeConfig buildTimeConfig = quartzSupport.getBuildTimeConfig();
        props.put("org.quartz.scheduler.instanceId", "AUTO");
        props.put("org.quartz.scheduler.skipUpdateCheck", "true");
        props.put("org.quartz.scheduler.instanceName", quartzSupport.getRuntimeConfig().instanceName);
        props.put("org.quartz.scheduler.wrapJobExecutionInUserTransaction", "false");
        props.put("org.quartz.scheduler.threadsInheritContextClassLoaderOfInitializer", "true");
        props.put("org.quartz.threadPool.class", "org.quartz.simpl.SimpleThreadPool");
        props.put("org.quartz.scheduler.classLoadHelper.class", InitThreadContextClassLoadHelper.class.getName());
        props.put("org.quartz.threadPool.threadCount", "" + quartzSupport.getRuntimeConfig().threadCount);
        props.put("org.quartz.threadPool.threadPriority", "" + quartzSupport.getRuntimeConfig().threadPriority);
        props.put("org.quartz.scheduler.rmi.export", "false");
        props.put("org.quartz.scheduler.rmi.proxy", "false");
        props.put("org.quartz.jobStore.class", buildTimeConfig.storeType.clazz);
        if (buildTimeConfig.storeType.isDbStore()) {
            String dataSource = buildTimeConfig.dataSourceName.orElse("QUARKUS_QUARTZ_DEFAULT_DATASOURCE");
            QuarkusQuartzConnectionPoolProvider.setDataSourceName(dataSource);
            props.put("org.quartz.jobStore.useProperties", "true");
            props.put("org.quartz.jobStore.misfireThreshold", "60000");
            props.put("org.quartz.jobStore.tablePrefix", buildTimeConfig.tablePrefix);
            props.put("org.quartz.jobStore.dataSource", dataSource);
            props.put("org.quartz.jobStore.driverDelegateClass", quartzSupport.getDriverDialect().get());
            props.put("org.quartz.dataSource." + dataSource + ".connectionProvider.class", QuarkusQuartzConnectionPoolProvider.class.getName());
            if (buildTimeConfig.clustered) {
                props.put("org.quartz.jobStore.isClustered", "true");
                props.put("org.quartz.jobStore.acquireTriggersWithinLock", "true");
                props.put("org.quartz.jobStore.clusterCheckinInterval", "" + quartzSupport.getBuildTimeConfig().clusterCheckinInterval);
            }
            if (buildTimeConfig.storeType.isNonManagedTxJobStore()) {
                props.put("org.quartz.jobStore.nonManagedTXDataSource", dataSource);
            }
        }
        props.putAll((Map<?, ?>)this.getAdditionalConfigurationProperties("org.quartz.plugin", buildTimeConfig.plugins));
        props.putAll((Map<?, ?>)this.getAdditionalConfigurationProperties("org.quartz.jobListener", buildTimeConfig.jobListeners));
        props.putAll((Map<?, ?>)this.getAdditionalConfigurationProperties("org.quartz.triggerListener", buildTimeConfig.triggerListeners));
        return props;
    }

    private Properties getAdditionalConfigurationProperties(String prefix, Map<String, QuartzExtensionPointConfig> config) {
        Properties props = new Properties();
        for (Map.Entry<String, QuartzExtensionPointConfig> configEntry : config.entrySet()) {
            props.put(String.format("%s.%s.class", prefix, configEntry.getKey()), configEntry.getValue().clazz);
            for (Map.Entry<String, String> propsEntry : configEntry.getValue().properties.entrySet()) {
                props.put(String.format("%s.%s.%s", prefix, configEntry.getKey(), propsEntry.getKey()), propsEntry.getValue());
            }
        }
        return props;
    }

    static class InvokerJobFactory
    extends SimpleJobFactory {
        final Map<String, ScheduledInvoker> invokers;
        final Instance<Job> jobs;

        InvokerJobFactory(Map<String, ScheduledInvoker> invokers, Instance<Job> jobs) {
            this.invokers = invokers;
            this.jobs = jobs;
        }

        public Job newJob(TriggerFiredBundle bundle, Scheduler Scheduler2) throws SchedulerException {
            Class jobClass = bundle.getJobDetail().getJobClass();
            if (jobClass.equals(InvokerJob.class)) {
                return new InvokerJob(this.invokers);
            }
            Instance instance = this.jobs.select(jobClass, new Annotation[0]);
            if (instance.isResolvable()) {
                return (Job)instance.get();
            }
            return super.newJob(bundle, Scheduler2);
        }
    }

    static class QuartzScheduledExecution
    implements ScheduledExecution {
        final QuartzTrigger trigger;

        public QuartzScheduledExecution(QuartzTrigger trigger) {
            this.trigger = trigger;
        }

        public Trigger getTrigger() {
            return this.trigger;
        }

        public Instant getFireTime() {
            return this.trigger.context.getScheduledFireTime().toInstant();
        }

        public Instant getScheduledFireTime() {
            return this.trigger.context.getFireTime().toInstant();
        }
    }

    static class QuartzTrigger
    implements Trigger {
        final JobExecutionContext context;

        public QuartzTrigger(JobExecutionContext context) {
            this.context = context;
        }

        public Instant getNextFireTime() {
            Date nextFireTime = this.context.getTrigger().getNextFireTime();
            return nextFireTime != null ? nextFireTime.toInstant() : null;
        }

        public Instant getPreviousFireTime() {
            Date previousFireTime = this.context.getTrigger().getPreviousFireTime();
            return previousFireTime != null ? previousFireTime.toInstant() : null;
        }

        public String getId() {
            return this.context.getTrigger().getKey().toString();
        }
    }

    static class InvokerJob
    implements Job {
        final Map<String, ScheduledInvoker> invokers;

        InvokerJob(Map<String, ScheduledInvoker> invokers) {
            this.invokers = invokers;
        }

        public void execute(JobExecutionContext context) {
            QuartzTrigger trigger = new QuartzTrigger(context);
            ScheduledInvoker scheduledInvoker = this.invokers.get(context.getJobDetail().getKey().getName());
            if (scheduledInvoker != null) {
                scheduledInvoker.invoke((Object)new QuartzScheduledExecution(trigger));
            }
        }
    }
}

