/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute.runtime.extensions;

import io.quarkus.qute.TemplateExtension;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.inject.Vetoed;

@Vetoed
@TemplateExtension
public class TimeTemplateExtensions {
    private static final Map<Key, DateTimeFormatter> FORMATTER_CACHE = new ConcurrentHashMap<Key, DateTimeFormatter>();

    static String format(TemporalAccessor temporal, String pattern) {
        return FORMATTER_CACHE.computeIfAbsent(new Key(pattern, null, null), TimeTemplateExtensions::formatterForKey).format(temporal);
    }

    static String format(TemporalAccessor temporal, String pattern, Locale locale) {
        return FORMATTER_CACHE.computeIfAbsent(new Key(pattern, locale, null), TimeTemplateExtensions::formatterForKey).format(temporal);
    }

    static String format(TemporalAccessor temporal, String pattern, Locale locale, ZoneId timeZone) {
        return FORMATTER_CACHE.computeIfAbsent(new Key(pattern, locale, timeZone), TimeTemplateExtensions::formatterForKey).format(temporal);
    }

    @TemplateExtension(namespace="time")
    static String format(Object dateTimeObject, String pattern) {
        return TimeTemplateExtensions.format(TimeTemplateExtensions.getFormattableObject(dateTimeObject, ZoneId.systemDefault()), pattern);
    }

    @TemplateExtension(namespace="time")
    static String format(Object dateTimeObject, String pattern, Locale locale) {
        return TimeTemplateExtensions.format(TimeTemplateExtensions.getFormattableObject(dateTimeObject, ZoneId.systemDefault()), pattern, locale);
    }

    @TemplateExtension(namespace="time")
    static String format(Object dateTimeObject, String pattern, Locale locale, ZoneId timeZone) {
        return TimeTemplateExtensions.format(TimeTemplateExtensions.getFormattableObject(dateTimeObject, timeZone), pattern, locale, timeZone);
    }

    private static TemporalAccessor getFormattableObject(Object value, ZoneId timeZone) {
        if (value instanceof TemporalAccessor) {
            return (TemporalAccessor)value;
        }
        if (value instanceof Date) {
            return LocalDateTime.ofInstant(((Date)value).toInstant(), timeZone);
        }
        if (value instanceof Calendar) {
            return LocalDateTime.ofInstant(((Calendar)value).toInstant(), timeZone);
        }
        if (value instanceof Number) {
            return LocalDateTime.ofInstant(Instant.ofEpochMilli(((Number)value).longValue()), timeZone);
        }
        throw new IllegalArgumentException("Not a formattable date/time object: " + value);
    }

    private static DateTimeFormatter formatterForKey(Key key) {
        DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder();
        builder.appendPattern(key.pattern);
        DateTimeFormatter formatter = key.locale != null ? builder.toFormatter(key.locale) : builder.toFormatter();
        return key.timeZone != null ? formatter.withZone(key.timeZone) : formatter;
    }

    static final class Key {
        private final String pattern;
        private final Locale locale;
        private final ZoneId timeZone;

        public Key(String pattern, Locale locale, ZoneId timeZone) {
            this.pattern = pattern;
            this.locale = locale;
            this.timeZone = timeZone;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.locale == null ? 0 : this.locale.hashCode());
            result = 31 * result + (this.pattern == null ? 0 : this.pattern.hashCode());
            result = 31 * result + (this.timeZone == null ? 0 : this.timeZone.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            return Objects.equals(this.locale, other.locale) && Objects.equals(this.pattern, other.pattern) && Objects.equals(this.timeZone, other.timeZone);
        }
    }
}

