/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.datasource.sortedset;

import io.quarkus.redis.datasource.RedisCommandExtraArguments;
import java.util.ArrayList;
import java.util.List;

public class ZAggregateArgs
implements RedisCommandExtraArguments {
    private final List<Double> weights = new ArrayList<Double>();
    private Aggregate aggregate;

    public ZAggregateArgs weights(double ... weights) {
        if (weights == null) {
            throw new IllegalArgumentException("`weights` cannot be `null`");
        }
        for (double weight : weights) {
            this.weights.add(weight);
        }
        return this;
    }

    public ZAggregateArgs aggregate(Aggregate aggregate) {
        this.aggregate = aggregate;
        return this;
    }

    public ZAggregateArgs sum() {
        this.aggregate = Aggregate.SUM;
        return this;
    }

    public ZAggregateArgs min() {
        this.aggregate = Aggregate.MIN;
        return this;
    }

    public ZAggregateArgs max() {
        this.aggregate = Aggregate.MAX;
        return this;
    }

    @Override
    public List<Object> toArgs() {
        ArrayList<Object> args = new ArrayList<Object>();
        if (!this.weights.isEmpty()) {
            args.add("WEIGHTS");
            for (double w : this.weights) {
                args.add(Double.toString(w));
            }
        }
        if (this.aggregate != null) {
            args.add("AGGREGATE");
            switch (this.aggregate) {
                case SUM: {
                    args.add("SUM");
                    break;
                }
                case MIN: {
                    args.add("MIN");
                    break;
                }
                case MAX: {
                    args.add("MAX");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Aggregation " + this.aggregate + " not supported");
                }
            }
        }
        return args;
    }

    public static enum Aggregate {
        SUM,
        MIN,
        MAX;

    }
}

