/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.redis.datasource.timeseries;

import io.smallrye.mutiny.helpers.ParameterValidation;

public interface Filter {
    public String toString();

    public static Filter withLabel(final String label, final Object value) {
        ParameterValidation.nonNull((Object)label, (String)"label");
        ParameterValidation.nonNull((Object)value, (String)"value");
        return new Filter(){

            @Override
            public String toString() {
                return label + "=" + value;
            }
        };
    }

    public static Filter withoutLabel(final String label, final String value) {
        ParameterValidation.nonNull((Object)label, (String)"label");
        ParameterValidation.nonNull((Object)value, (String)"value");
        return new Filter(){

            @Override
            public String toString() {
                return label + "!=" + value;
            }
        };
    }

    public static Filter withLabel(final String label) {
        ParameterValidation.nonNull((Object)label, (String)"label");
        return new Filter(){

            @Override
            public String toString() {
                return label + "=";
            }
        };
    }

    public static Filter withoutLabel(final String label) {
        ParameterValidation.nonNull((Object)label, (String)"label");
        return new Filter(){

            @Override
            public String toString() {
                return label + "!=";
            }
        };
    }

    public static Filter withLabelHavingValueFrom(final String label, final String ... values) {
        ParameterValidation.nonNull((Object)label, (String)"label");
        ParameterValidation.doesNotContainNull((Object[])values, (String)"values");
        return new Filter(){

            @Override
            public String toString() {
                return label + "=(" + String.join((CharSequence)",", values) + ")";
            }
        };
    }

    public static Filter withLabelNotHavingValueFrom(final String label, final String ... values) {
        ParameterValidation.nonNull((Object)label, (String)"label");
        ParameterValidation.doesNotContainNull((Object[])values, (String)"values");
        return new Filter(){

            @Override
            public String toString() {
                return label + "!=(" + String.join((CharSequence)",", values) + ")";
            }
        };
    }
}

