/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.jackson.runtime.serialisers;

import com.fasterxml.jackson.core.exc.StreamReadException;
import com.fasterxml.jackson.databind.DatabindException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.exc.InvalidDefinitionException;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import jakarta.inject.Inject;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ContextResolver;
import jakarta.ws.rs.ext.Providers;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.jboss.resteasy.reactive.common.util.StreamUtil;
import org.jboss.resteasy.reactive.server.jackson.JacksonBasicMessageBodyReader;
import org.jboss.resteasy.reactive.server.spi.ResteasyReactiveResourceInfo;
import org.jboss.resteasy.reactive.server.spi.ServerMessageBodyReader;
import org.jboss.resteasy.reactive.server.spi.ServerRequestContext;

public class FullyFeaturedServerJacksonMessageBodyReader
extends JacksonBasicMessageBodyReader
implements ServerMessageBodyReader<Object> {
    private final Providers providers;
    private final ConcurrentMap<ObjectMapper, ObjectReader> contextResolverMap = new ConcurrentHashMap<ObjectMapper, ObjectReader>();

    @Inject
    public FullyFeaturedServerJacksonMessageBodyReader(ObjectMapper mapper, Providers providers) {
        super(mapper);
        this.providers = providers;
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        try {
            return this.doReadFrom(type, genericType, mediaType, entityStream);
        }
        catch (InvalidDefinitionException | MismatchedInputException e) {
            throw e;
        }
        catch (StreamReadException | DatabindException e) {
            throw new WebApplicationException(e, Response.Status.BAD_REQUEST);
        }
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.isReadable(mediaType, type);
    }

    public boolean isReadable(Class<?> type, Type genericType, ResteasyReactiveResourceInfo lazyMethod, MediaType mediaType) {
        return this.isReadable(mediaType, type);
    }

    public Object readFrom(Class<Object> type, Type genericType, MediaType mediaType, ServerRequestContext context) throws WebApplicationException, IOException {
        return this.readFrom(type, genericType, null, mediaType, null, context.getInputStream());
    }

    private Object doReadFrom(Class<Object> type, Type genericType, MediaType responseMediaType, InputStream entityStream) throws IOException {
        if (StreamUtil.isEmpty((InputStream)entityStream)) {
            return null;
        }
        try {
            ObjectReader reader = this.getEffectiveReader(type, responseMediaType);
            return reader.forType(reader.getTypeFactory().constructType(genericType != null ? genericType : type)).readValue(entityStream);
        }
        catch (MismatchedInputException e) {
            if (this.isEmptyInputException(e)) {
                return null;
            }
            throw e;
        }
    }

    private boolean isEmptyInputException(MismatchedInputException e) {
        return e.getMessage().startsWith("No content");
    }

    private ObjectReader getEffectiveReader(Class<Object> type, MediaType responseMediaType) {
        ObjectMapper effectiveMapper = this.getObjectMapperFromContext(type, responseMediaType);
        if (effectiveMapper == null) {
            return this.getEffectiveReader();
        }
        return this.contextResolverMap.computeIfAbsent(effectiveMapper, new Function<ObjectMapper, ObjectReader>(){

            @Override
            public ObjectReader apply(ObjectMapper objectMapper) {
                return objectMapper.reader();
            }
        });
    }

    private ObjectMapper getObjectMapperFromContext(Class<Object> type, MediaType responseMediaType) {
        if (this.providers == null) {
            return null;
        }
        ContextResolver contextResolver = this.providers.getContextResolver(ObjectMapper.class, responseMediaType);
        if (contextResolver == null) {
            contextResolver = this.providers.getContextResolver(ObjectMapper.class, null);
        }
        if (contextResolver != null) {
            return (ObjectMapper)contextResolver.getContext(type);
        }
        return null;
    }
}

