/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.resteasy.runtime.JaxRsPermissionChecker;
import io.quarkus.security.UnauthorizedException;
import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.spi.runtime.AuthorizationController;
import io.quarkus.security.spi.runtime.AuthorizationFailureEvent;
import io.quarkus.security.spi.runtime.AuthorizationSuccessEvent;
import io.quarkus.security.spi.runtime.MethodDescription;
import io.quarkus.security.spi.runtime.SecurityCheck;
import io.quarkus.security.spi.runtime.SecurityCheckStorage;
import io.quarkus.security.spi.runtime.SecurityEvent;
import io.quarkus.vertx.http.runtime.CurrentVertxRequest;
import io.quarkus.vertx.http.runtime.security.EagerSecurityInterceptorStorage;
import io.quarkus.vertx.http.runtime.security.QuarkusHttpUser;
import io.vertx.ext.auth.User;
import io.vertx.ext.web.RoutingContext;
import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.function.Consumer;
import org.jboss.resteasy.core.ResourceMethodInvoker;
import org.jboss.resteasy.core.interception.jaxrs.PostMatchContainerRequestContext;
import org.jboss.resteasy.spi.ResourceFactory;

@Priority(value=1000)
@Provider
public class EagerSecurityFilter
implements ContainerRequestFilter {
    static final String SKIP_DEFAULT_CHECK = "io.quarkus.resteasy.runtime.EagerSecurityFilter#SKIP_DEFAULT_CHECK";
    private final EagerSecurityInterceptorStorage interceptorStorage;
    @Context
    ResourceInfo resourceInfo;
    @Inject
    CurrentVertxRequest currentVertxRequest;
    @Inject
    SecurityCheckStorage securityCheckStorage;
    @Inject
    CurrentIdentityAssociation identityAssociation;
    @Inject
    AuthorizationController authorizationController;
    @Inject
    JaxRsPermissionChecker jaxRsPermissionChecker;

    public EagerSecurityFilter() {
        InstanceHandle interceptorStorageHandle = Arc.container().instance(EagerSecurityInterceptorStorage.class, new Annotation[0]);
        this.interceptorStorage = interceptorStorageHandle.isAvailable() ? (EagerSecurityInterceptorStorage)interceptorStorageHandle.get() : null;
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        if (this.authorizationController.isAuthorizationEnabled()) {
            ResourceMethodDescription description = EagerSecurityFilter.createResourceMethodDescription(requestContext, this.resourceInfo);
            if (this.interceptorStorage != null) {
                this.applyEagerSecurityInterceptors(description);
            }
            if (this.jaxRsPermissionChecker.shouldRunPermissionChecks()) {
                this.jaxRsPermissionChecker.applyPermissionChecks();
            }
            this.applySecurityChecks(description);
        }
    }

    private void applySecurityChecks(ResourceMethodDescription resourceMethodDescription) {
        MethodDescription description = resourceMethodDescription.invokedMethodDesc();
        SecurityCheck check = this.securityCheckStorage.getSecurityCheck(description);
        if (check == null && resourceMethodDescription.fallbackMethodDesc() != null) {
            description = resourceMethodDescription.fallbackMethodDesc();
            check = this.securityCheckStorage.getSecurityCheck(description);
        }
        if (check == null && this.securityCheckStorage.getDefaultSecurityCheck() != null && this.routingContext().get(EagerSecurityFilter.class.getName()) == null && this.routingContext().get(SKIP_DEFAULT_CHECK) == null) {
            check = this.securityCheckStorage.getDefaultSecurityCheck();
        }
        if (check != null) {
            if (check.isPermitAll()) {
                SecurityIdentity identity;
                User user = this.routingContext().user();
                if (user instanceof QuarkusHttpUser) {
                    QuarkusHttpUser user2 = (QuarkusHttpUser)user;
                    identity = user2.getSecurityIdentity();
                } else {
                    identity = null;
                }
                this.fireEventOnAuthZSuccess(check, identity, description);
            } else {
                if (check.requiresMethodArguments()) {
                    if (this.identityAssociation.getIdentity().isAnonymous()) {
                        UnauthorizedException exception = new UnauthorizedException();
                        if (this.jaxRsPermissionChecker.getEventHelper().fireEventOnFailure()) {
                            this.fireEventOnAuthZFailure((Exception)exception, check, description);
                        }
                        throw exception;
                    }
                    return;
                }
                if (this.jaxRsPermissionChecker.getEventHelper().fireEventOnFailure()) {
                    try {
                        check.apply(this.identityAssociation.getIdentity(), description, null);
                    }
                    catch (Exception e) {
                        this.fireEventOnAuthZFailure(e, check, description);
                        throw e;
                    }
                } else {
                    check.apply(this.identityAssociation.getIdentity(), description, null);
                }
                this.fireEventOnAuthZSuccess(check, this.identityAssociation.getIdentity(), description);
            }
            this.routingContext().put(EagerSecurityFilter.class.getName(), (Object)this.resourceInfo.getResourceMethod());
        }
    }

    private void fireEventOnAuthZFailure(Exception exception, SecurityCheck check, MethodDescription description) {
        this.jaxRsPermissionChecker.getEventHelper().fireFailureEvent((SecurityEvent)new AuthorizationFailureEvent(this.identityAssociation.getIdentity(), (Throwable)exception, check.getClass().getName(), Map.of(RoutingContext.class.getName(), this.routingContext()), description));
    }

    private void fireEventOnAuthZSuccess(SecurityCheck check, SecurityIdentity securityIdentity, MethodDescription description) {
        if (this.jaxRsPermissionChecker.getEventHelper().fireEventOnSuccess()) {
            this.jaxRsPermissionChecker.getEventHelper().fireSuccessEvent((SecurityEvent)new AuthorizationSuccessEvent(securityIdentity, check.getClass().getName(), Map.of(RoutingContext.class.getName(), this.routingContext()), description));
        }
    }

    private RoutingContext routingContext() {
        return this.currentVertxRequest.getCurrent();
    }

    private void applyEagerSecurityInterceptors(ResourceMethodDescription description) {
        Consumer interceptor = this.interceptorStorage.getInterceptor(description.invokedMethodDesc());
        if (description.fallbackMethodDesc() != null && interceptor == null) {
            interceptor = this.interceptorStorage.getInterceptor(description.fallbackMethodDesc());
        }
        if (interceptor != null) {
            interceptor.accept(this.routingContext());
        }
    }

    private static Class<?> getScannableClass(ResourceMethodInvoker invoker) {
        ResourceFactory resourceFactory = EagerSecurityFilter.getResourceFactory(invoker);
        return resourceFactory == null ? null : resourceFactory.getScannableClass();
    }

    private static ResourceMethodDescription createResourceMethodDescription(ContainerRequestContext requestContext, ResourceInfo resourceInfo) {
        PostMatchContainerRequestContext postMatchRequestContext;
        Class<?> scannableClass;
        Method resourceMethod = resourceInfo.getResourceMethod();
        MethodDescription resourceInfoDesc = MethodDescription.ofMethod((Method)resourceMethod);
        if (requestContext instanceof PostMatchContainerRequestContext && (scannableClass = EagerSecurityFilter.getScannableClass((postMatchRequestContext = (PostMatchContainerRequestContext)requestContext).getResourceMethod())) != null && !resourceMethod.getDeclaringClass().equals(scannableClass)) {
            try {
                Method method = scannableClass.getMethod(resourceMethod.getName(), resourceMethod.getParameterTypes());
                MethodDescription scannableClassDesc = MethodDescription.ofMethod((Method)method);
                if (!scannableClassDesc.equals((Object)resourceInfoDesc)) {
                    return new ResourceMethodDescription(scannableClassDesc, resourceInfoDesc);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return new ResourceMethodDescription(resourceInfoDesc, null);
    }

    static native ResourceFactory getResourceFactory(ResourceMethodInvoker var0);

    private record ResourceMethodDescription(MethodDescription invokedMethodDesc, MethodDescription fallbackMethodDesc) {
    }
}

