/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.scheduler.common.runtime;

import io.quarkus.scheduler.ScheduledExecution;
import io.quarkus.scheduler.common.runtime.DelegateInvoker;
import io.quarkus.scheduler.common.runtime.ScheduledInvoker;
import io.quarkus.scheduler.spi.JobInstrumenter;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public class InstrumentedInvoker
extends DelegateInvoker {
    private final JobInstrumenter instrumenter;

    public InstrumentedInvoker(ScheduledInvoker delegate, JobInstrumenter instrumenter) {
        super(delegate);
        this.instrumenter = instrumenter;
    }

    @Override
    public CompletionStage<Void> invoke(final ScheduledExecution execution) throws Exception {
        return this.instrumenter.instrument(new JobInstrumenter.JobInstrumentationContext(){

            public CompletionStage<Void> executeJob() {
                try {
                    return InstrumentedInvoker.this.delegate.invoke(execution);
                }
                catch (Exception e) {
                    return CompletableFuture.failedFuture(e);
                }
            }

            public String getSpanName() {
                return execution.getTrigger().getId();
            }
        });
    }
}

