/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.scheduler.runtime.util;

import io.quarkus.scheduler.Scheduled;
import java.time.Duration;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;

public class SchedulerUtils {
    private static final String DELAYED = "delayed";
    private static final String EVERY = "every";

    private SchedulerUtils() {
    }

    public static long parseDelayedAsMillis(Scheduled scheduled) {
        return SchedulerUtils.parseDurationAsMillis(scheduled, scheduled.delayed(), DELAYED);
    }

    public static long parseEveryAsMillis(Scheduled scheduled) {
        return SchedulerUtils.parseDurationAsMillis(scheduled, scheduled.every(), EVERY);
    }

    public static String lookUpPropertyValue(String propertyValue) {
        String value = propertyValue.trim();
        if (!value.isEmpty() && SchedulerUtils.isConfigValue(value)) {
            value = (String)ConfigProviderResolver.instance().getConfig().getValue(SchedulerUtils.getConfigProperty(value), String.class);
        }
        return value;
    }

    public static boolean isConfigValue(String val) {
        return (val = val.trim()).startsWith("{") && val.endsWith("}");
    }

    private static String getConfigProperty(String val) {
        return val.substring(1, val.length() - 1);
    }

    private static long parseDurationAsMillis(Scheduled scheduled, String value, String memberName) {
        return Math.abs(SchedulerUtils.parseDuration(scheduled, value, memberName).toMillis());
    }

    private static Duration parseDuration(Scheduled scheduled, String value, String memberName) {
        if (Character.isDigit((value = SchedulerUtils.lookUpPropertyValue(value)).charAt(0))) {
            value = "PT" + value;
        }
        try {
            return Duration.parse(value);
        }
        catch (Exception e) {
            throw new IllegalStateException("Invalid " + memberName + "() expression on: " + scheduled, e);
        }
    }
}

