/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.webauthn;

import io.quarkus.runtime.BlockingOperationControl;
import io.quarkus.security.webauthn.WebAuthnUserProvider;
import io.quarkus.virtual.threads.VirtualThreadsRecorder;
import io.smallrye.common.annotation.Blocking;
import io.smallrye.common.annotation.NonBlocking;
import io.smallrye.common.annotation.RunOnVirtualThread;
import io.smallrye.mutiny.Uni;
import io.vertx.core.Future;
import io.vertx.ext.auth.webauthn.Authenticator;
import io.vertx.mutiny.core.Vertx;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Supplier;

@ApplicationScoped
public class WebAuthnAuthenticatorStorage {
    @Inject
    WebAuthnUserProvider userProvider;
    @Inject
    Vertx vertx;

    public Future<List<Authenticator>> fetcher(Authenticator query) {
        Uni res;
        if (query.getUserName() != null) {
            res = this.runPotentiallyBlocking(() -> this.userProvider.findWebAuthnCredentialsByUserName(query.getUserName()));
        } else if (query.getCredID() != null) {
            res = this.runPotentiallyBlocking(() -> this.userProvider.findWebAuthnCredentialsByCredID(query.getCredID()));
        } else {
            return Future.succeededFuture(Collections.emptyList());
        }
        return Future.fromCompletionStage((CompletionStage)res.subscribeAsCompletionStage());
    }

    private <T> Uni<T> runPotentiallyBlocking(Supplier<Uni<? extends T>> supplier) {
        if (BlockingOperationControl.isBlockingAllowed() || this.isNonBlocking(this.userProvider.getClass())) {
            return supplier.get();
        }
        if (this.isRunOnVirtualThread(this.userProvider.getClass())) {
            return Uni.createFrom().deferred(supplier).runSubscriptionOn((Executor)VirtualThreadsRecorder.getCurrent());
        }
        return this.vertx.executeBlocking(Uni.createFrom().deferred(supplier));
    }

    private boolean isNonBlocking(Class<?> klass) {
        do {
            if (klass.isAnnotationPresent(NonBlocking.class)) {
                return true;
            }
            if (klass.isAnnotationPresent(Blocking.class)) {
                return false;
            }
            if (!klass.isAnnotationPresent(RunOnVirtualThread.class)) continue;
            return false;
        } while ((klass = klass.getSuperclass()) != null);
        return true;
    }

    private boolean isRunOnVirtualThread(Class<?> klass) {
        do {
            if (klass.isAnnotationPresent(RunOnVirtualThread.class)) {
                return true;
            }
            if (klass.isAnnotationPresent(Blocking.class)) {
                return false;
            }
            if (!klass.isAnnotationPresent(NonBlocking.class)) continue;
            return false;
        } while ((klass = klass.getSuperclass()) != null);
        return false;
    }

    public Future<Void> updater(Authenticator authenticator) {
        return Future.fromCompletionStage((CompletionStage)this.runPotentiallyBlocking(() -> this.userProvider.updateOrStoreWebAuthnCredentials(authenticator)).subscribeAsCompletionStage());
    }
}

