/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.runtime;

import io.quarkus.security.ForbiddenException;
import io.quarkus.security.identity.AuthenticationRequestContext;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.SecurityIdentityAugmentor;
import io.quarkus.security.runtime.QuarkusPermission;
import io.quarkus.security.runtime.QuarkusSecurityIdentity;
import io.quarkus.security.spi.runtime.BlockingSecurityExecutor;
import io.smallrye.mutiny.Uni;
import java.security.Permission;
import java.util.function.Function;
import java.util.function.Predicate;

public final class QuarkusPermissionSecurityIdentityAugmentor
implements SecurityIdentityAugmentor {
    private static final Predicate<Throwable> NOT_A_FORBIDDEN_EXCEPTION = new Predicate<Throwable>(){

        @Override
        public boolean test(Throwable throwable) {
            return !(throwable instanceof ForbiddenException);
        }
    };
    private static final Function<Throwable, Throwable> WRAP_WITH_FORBIDDEN_EXCEPTION = new Function<Throwable, Throwable>(){

        @Override
        public Throwable apply(Throwable throwable) {
            return new ForbiddenException(throwable);
        }
    };
    private final BlockingSecurityExecutor blockingExecutor;

    QuarkusPermissionSecurityIdentityAugmentor(BlockingSecurityExecutor blockingExecutor) {
        this.blockingExecutor = blockingExecutor;
    }

    public Uni<SecurityIdentity> augment(final SecurityIdentity identity, AuthenticationRequestContext context) {
        if (identity.isAnonymous()) {
            return Uni.createFrom().item((Object)identity);
        }
        return Uni.createFrom().item((Object)QuarkusSecurityIdentity.builder(identity).addPermissionChecker(new Function<Permission, Uni<Boolean>>(){

            @Override
            public Uni<Boolean> apply(Permission requiredpermission) {
                if (requiredpermission instanceof QuarkusPermission) {
                    QuarkusPermission quarkusPermission = (QuarkusPermission)requiredpermission;
                    return quarkusPermission.isGranted(identity, QuarkusPermissionSecurityIdentityAugmentor.this.blockingExecutor).onFailure(NOT_A_FORBIDDEN_EXCEPTION).transform(WRAP_WITH_FORBIDDEN_EXCEPTION);
                }
                return Uni.createFrom().item((Object)false);
            }
        }).build());
    }
}

