/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.health.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ManagedContext;
import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.quarkus.vertx.core.runtime.BufferOutputStream;
import io.quarkus.vertx.http.runtime.security.QuarkusHttpUser;
import io.smallrye.health.SmallRyeHealth;
import io.smallrye.health.SmallRyeHealthReporter;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.MutinyHelper;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.JsonWriter;
import jakarta.json.JsonWriterFactory;
import jakarta.json.spi.JsonProvider;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.lang.annotation.Annotation;
import java.time.Instant;
import java.util.Collections;
import java.util.Map;

public abstract class SmallRyeHealthHandlerBase
implements Handler<RoutingContext> {
    static volatile boolean problemDetails = false;
    private static final Map<String, ?> JSON_CONFIG = Collections.singletonMap("jakarta.json.stream.JsonGenerator.prettyPrinting", true);
    private static final JsonProvider JSON_PROVIDER = JsonProvider.provider();
    private static final JsonWriterFactory JSON_WRITER_FACTORY = JSON_PROVIDER.createWriterFactory(JSON_CONFIG);

    protected abstract Uni<SmallRyeHealth> getHealth(SmallRyeHealthReporter var1, RoutingContext var2);

    public void handle(RoutingContext ctx) {
        ManagedContext requestContext = Arc.container().requestContext();
        if (requestContext.isActive()) {
            this.doHandle(ctx, null);
        } else {
            requestContext.activate();
            try {
                this.doHandle(ctx, requestContext);
            }
            catch (Exception e) {
                requestContext.terminate();
                throw e;
            }
        }
    }

    private void doHandle(RoutingContext ctx, ManagedContext requestContext) {
        QuarkusHttpUser user = (QuarkusHttpUser)ctx.user();
        if (user != null) {
            ((CurrentIdentityAssociation)Arc.container().instance(CurrentIdentityAssociation.class, new Annotation[0]).get()).setIdentity(user.getSecurityIdentity());
        }
        SmallRyeHealthReporter reporter = (SmallRyeHealthReporter)Arc.container().instance(SmallRyeHealthReporter.class, new Annotation[0]).get();
        Context context = Vertx.currentContext();
        Uni healthUni = this.getHealth(reporter, ctx);
        if (context != null) {
            healthUni = healthUni.emitOn(MutinyHelper.executor((Context)context));
        }
        healthUni.subscribe().with(health -> {
            if (requestContext != null) {
                requestContext.terminate();
            }
            HttpServerResponse resp = ctx.response();
            Buffer buffer = Buffer.buffer((int)256);
            if (health.isDown()) {
                resp.setStatusCode(503);
                if (problemDetails) {
                    resp.headers().set(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/problem+json");
                    try (BufferOutputStream outputStream = new BufferOutputStream(buffer);){
                        JsonObjectBuilder objectBuilder = JSON_PROVIDER.createObjectBuilder();
                        objectBuilder.add("type", "about:blank").add("status", 503).add("title", "Health Check Failed: " + ctx.normalizedPath()).add("detail", ctx.request().uri() + ", invoked at " + Instant.now()).add("instance", ctx.request().absoluteURI()).add("health", (JsonValue)health.getPayload());
                        JsonWriter writer = JSON_WRITER_FACTORY.createWriter((OutputStream)outputStream);
                        writer.writeObject(objectBuilder.build());
                        resp.end(buffer);
                        return;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
            }
            resp.headers().set(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/json; charset=UTF-8").set(HttpHeaders.CACHE_CONTROL, (CharSequence)"no-store");
            try (BufferOutputStream outputStream = new BufferOutputStream(buffer);){
                reporter.reportHealth((OutputStream)outputStream, health);
                resp.end(buffer);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }, failure -> {
            if (requestContext != null) {
                requestContext.terminate();
            }
        });
    }
}

