/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.metrics.deployment.jandex;

import io.quarkus.arc.deployment.TransformedAnnotationsBuildItem;
import io.quarkus.smallrye.metrics.deployment.SmallRyeMetricsDotNames;
import io.quarkus.smallrye.metrics.deployment.jandex.JandexAnnotationInfoAdapter;
import io.smallrye.metrics.elementdesc.MemberInfo;
import io.smallrye.metrics.elementdesc.MemberType;
import io.smallrye.metrics.elementdesc.RawMemberInfo;
import io.smallrye.metrics.elementdesc.adapter.MemberInfoAdapter;
import java.util.List;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.IndexView;

public class JandexMemberInfoAdapter
implements MemberInfoAdapter<AnnotationTarget> {
    private final IndexView indexView;
    private final TransformedAnnotationsBuildItem transformedAnnotations;

    public JandexMemberInfoAdapter(IndexView indexView, TransformedAnnotationsBuildItem transformedAnnotations) {
        this.indexView = indexView;
        this.transformedAnnotations = transformedAnnotations;
    }

    public MemberInfo convert(AnnotationTarget input) {
        String[] parameterTypeNames;
        List annotationInformation;
        String name;
        String declaringClassSimpleName;
        String declaringClassName;
        AnnotationTarget.Kind kind = input.kind();
        MemberType memberType = kind.equals((Object)AnnotationTarget.Kind.FIELD) ? MemberType.FIELD : (input.asMethod().name().equals("<init>") ? MemberType.CONSTRUCTOR : MemberType.METHOD);
        JandexAnnotationInfoAdapter annotationInfoAdapter = new JandexAnnotationInfoAdapter(this.indexView);
        if (input.kind().equals((Object)AnnotationTarget.Kind.METHOD)) {
            declaringClassName = input.asMethod().declaringClass().name().toString();
            declaringClassSimpleName = input.asMethod().declaringClass().simpleName();
            name = input.asMethod().name();
            annotationInformation = this.transformedAnnotations.getAnnotations(input).stream().filter(SmallRyeMetricsDotNames::isMetricAnnotation).map(annotationInfoAdapter::convert).collect(Collectors.toList());
            parameterTypeNames = (String[])input.asMethod().parameterTypes().stream().map(type -> type.name().toString()).toArray(String[]::new);
        } else {
            declaringClassName = input.asField().declaringClass().name().toString();
            declaringClassSimpleName = input.asField().declaringClass().simpleName();
            name = input.asField().name();
            annotationInformation = this.transformedAnnotations.getAnnotations(input).stream().filter(SmallRyeMetricsDotNames::isMetricAnnotation).map(annotationInfoAdapter::convert).collect(Collectors.toList());
            parameterTypeNames = new String[]{};
        }
        return new RawMemberInfo(memberType, declaringClassName, declaringClassSimpleName, name, annotationInformation, parameterTypeNames);
    }
}

