/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.common;

import io.quarkus.deployment.pkg.steps.NativeImageBuildLocalContainerRunner;
import io.quarkus.deployment.util.ContainerRuntimeUtil;
import io.quarkus.test.common.ArtifactLauncher;
import io.quarkus.test.common.DefaultJarLauncher;
import io.quarkus.test.common.DockerContainerArtifactLauncher;
import io.quarkus.test.common.IntegrationTestStartedNotifier;
import io.quarkus.test.common.LauncherUtil;
import io.quarkus.test.common.ListeningAddress;
import io.quarkus.test.common.PropertyTestUtil;
import io.quarkus.test.common.http.TestHTTPResourceManager;
import io.smallrye.config.common.utils.StringUtil;
import java.io.IOException;
import java.net.ServerSocket;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.commons.lang3.RandomStringUtils;
import org.jboss.logging.Logger;

public class DefaultDockerContainerLauncher
implements DockerContainerArtifactLauncher {
    private static final Logger log = Logger.getLogger(DefaultDockerContainerLauncher.class);
    private int httpPort;
    private int httpsPort;
    private long waitTimeSeconds;
    private String testProfile;
    private List<String> argLine;
    private Map<String, String> env;
    private ArtifactLauncher.InitContext.DevServicesLaunchResult devServicesLaunchResult;
    private String containerImage;
    private boolean pullRequired;
    private Map<Integer, Integer> additionalExposedPorts;
    private Map<String, String> volumeMounts;
    private Map<String, String> labels;
    private final Map<String, String> systemProps = new HashMap<String, String>();
    private boolean isSsl;
    private final String containerName = "quarkus-integration-test-" + RandomStringUtils.insecure().next(5, true, false);
    private String containerRuntimeBinaryName;
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();
    private Optional<String> entryPoint;
    private List<String> programArgs;

    @Override
    public void init(DockerContainerArtifactLauncher.DockerInitContext initContext) {
        this.httpPort = initContext.httpPort();
        this.httpsPort = initContext.httpsPort();
        this.waitTimeSeconds = initContext.waitTime().getSeconds();
        this.testProfile = initContext.testProfile();
        this.argLine = initContext.argLine();
        this.env = initContext.env();
        this.devServicesLaunchResult = initContext.getDevServicesLaunchResult();
        this.containerImage = initContext.containerImage();
        this.pullRequired = initContext.pullRequired();
        this.additionalExposedPorts = initContext.additionalExposedPorts();
        this.volumeMounts = initContext.volumeMounts();
        this.labels = initContext.labels();
        this.entryPoint = initContext.entryPoint();
        this.programArgs = initContext.programArgs();
    }

    @Override
    public ArtifactLauncher.LaunchResult runToCompletion(String[] args) {
        throw new UnsupportedOperationException("not implemented for docker yet");
    }

    @Override
    public void start() throws IOException {
        ContainerRuntimeUtil.ContainerRuntime containerRuntime = ContainerRuntimeUtil.detectContainerRuntime();
        this.containerRuntimeBinaryName = containerRuntime.getExecutableName();
        if (this.pullRequired) {
            log.infof("Pulling container image '%s'", (Object)this.containerImage);
            try {
                int pullResult = new ProcessBuilder(new String[0]).redirectError(ProcessBuilder.Redirect.DISCARD).redirectOutput(ProcessBuilder.Redirect.DISCARD).command(this.containerRuntimeBinaryName, "pull", this.containerImage).start().waitFor();
                if (pullResult > 0) {
                    throw new RuntimeException("Pulling container image '" + this.containerImage + "' completed unsuccessfully");
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Unable to pull container image '" + this.containerImage + "'", e);
            }
        }
        System.setProperty("test.url", TestHTTPResourceManager.getUri());
        if (this.httpPort == 0) {
            this.httpPort = this.getRandomPort();
        }
        if (this.httpsPort == 0) {
            this.httpsPort = this.getRandomPort();
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.containerRuntimeBinaryName);
        args.add("run");
        if (!this.argLine.isEmpty()) {
            args.addAll(this.argLine);
        }
        args.add("--name");
        args.add(this.containerName);
        args.add("-i");
        args.add("--rm");
        if (!this.volumeMounts.isEmpty()) {
            args.addAll(NativeImageBuildLocalContainerRunner.getVolumeAccessArguments((ContainerRuntimeUtil.ContainerRuntime)containerRuntime));
        }
        args.add("-p");
        args.add(this.httpPort + ":" + this.httpPort);
        args.add("-p");
        args.add(this.httpsPort + ":" + this.httpsPort);
        if (this.entryPoint.isPresent()) {
            args.add("--entrypoint");
            args.add(this.entryPoint.get());
        }
        for (Map.Entry<Integer, Integer> entry : this.additionalExposedPorts.entrySet()) {
            args.add("-p");
            args.add(entry.getKey() + ":" + entry.getValue());
        }
        for (Map.Entry<Object, Object> entry : this.volumeMounts.entrySet()) {
            NativeImageBuildLocalContainerRunner.addVolumeParameter((String)((String)entry.getKey()), (String)((String)entry.getValue()), args, (ContainerRuntimeUtil.ContainerRuntime)containerRuntime);
        }
        if (this.devServicesLaunchResult.networkId() != null) {
            args.add("--net=" + this.devServicesLaunchResult.networkId());
        }
        args.addAll(this.toEnvVar("quarkus.log.category.\"io.quarkus\".level", "INFO"));
        if (DefaultJarLauncher.HTTP_PRESENT) {
            args.addAll(this.toEnvVar("quarkus.http.port", "" + this.httpPort));
            args.addAll(this.toEnvVar("quarkus.http.ssl-port", "" + this.httpsPort));
            args.addAll(this.toEnvVar("test.url", TestHTTPResourceManager.getUri()));
        }
        if (this.testProfile != null) {
            args.addAll(this.toEnvVar("quarkus.profile", this.testProfile));
        }
        for (Map.Entry<Object, Object> entry : this.systemProps.entrySet()) {
            args.addAll(this.toEnvVar((String)entry.getKey(), (String)entry.getValue()));
        }
        for (Map.Entry<Object, Object> entry : this.env.entrySet()) {
            args.addAll(DefaultDockerContainerLauncher.envAsLaunchArg((String)entry.getKey(), (String)entry.getValue()));
        }
        for (Map.Entry<Object, Object> entry : this.labels.entrySet()) {
            args.add("--label");
            args.add((String)entry.getKey() + "=" + (String)entry.getValue());
        }
        args.add(this.containerImage);
        args.addAll(this.programArgs);
        Path logFile = PropertyTestUtil.getLogFilePath();
        try {
            Files.deleteIfExists(logFile);
            Files.createDirectories(logFile.getParent(), new FileAttribute[0]);
        }
        catch (FileSystemException fileSystemException) {
            log.warnf("Log file %s deletion failed, could happen on Windows, we can carry on.", (Object)logFile);
        }
        log.infof("Executing \"%s\"", (Object)String.join((CharSequence)" ", args));
        Function<IntegrationTestStartedNotifier.Context, IntegrationTestStartedNotifier.Result> function = LauncherUtil.createStartedFunction();
        Process containerProcess = new ProcessBuilder(args).redirectErrorStream(true).redirectOutput(ProcessBuilder.Redirect.appendTo(logFile.toFile())).start();
        if (function != null) {
            IntegrationTestStartedNotifier.Result result = LauncherUtil.waitForStartedFunction(function, containerProcess, this.waitTimeSeconds, logFile);
            this.isSsl = result.isSsl();
        } else {
            log.info((Object)"Wait for server to start by capturing listening data...");
            ListeningAddress result = LauncherUtil.waitForCapturedListeningData(containerProcess, logFile, this.waitTimeSeconds);
            log.infof("Server started on port %s", (Object)result.getPort());
            LauncherUtil.updateConfigForPort(result.getPort());
            this.isSsl = result.isSsl();
        }
    }

    private int getRandomPort() throws IOException {
        try (ServerSocket socket = new ServerSocket(0);){
            int n = socket.getLocalPort();
            return n;
        }
    }

    @Override
    public boolean listensOnSsl() {
        return this.isSsl;
    }

    @Override
    public void includeAsSysProps(Map<String, String> systemProps) {
        this.systemProps.putAll(systemProps);
    }

    private static List<String> envAsLaunchArg(String name, String value) {
        return List.of("--env", String.format("%s=%s", name, value));
    }

    private List<String> toEnvVar(String property, String value) {
        if (property != null && !property.isEmpty()) {
            return DefaultDockerContainerLauncher.envAsLaunchArg(this.convertPropertyToEnvVar(property), value);
        }
        return Collections.emptyList();
    }

    private String convertPropertyToEnvVar(String property) {
        return StringUtil.replaceNonAlphanumericByUnderscores((String)property).toUpperCase();
    }

    @Override
    public void close() {
        log.info((Object)"Close the container");
        try {
            Process dockerStopProcess = new ProcessBuilder(this.containerRuntimeBinaryName, "stop", this.containerName).redirectError(ProcessBuilder.Redirect.DISCARD).redirectOutput(ProcessBuilder.Redirect.DISCARD).start();
            log.debug((Object)"Wait for container to stop");
            dockerStopProcess.waitFor(10L, TimeUnit.SECONDS);
        }
        catch (IOException | InterruptedException e) {
            log.errorf("Unable to stop container '%s'", (Object)this.containerName);
        }
        log.debug((Object)"Container stopped");
        this.executorService.shutdown();
    }
}

