/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.util.annotations;

import io.quarkus.test.util.annotations.AnnotationContainer;
import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.lang.reflect.AnnotatedElement;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.junit.platform.commons.util.Preconditions;

public final class AnnotationUtils {
    private AnnotationUtils() {
    }

    public static <A extends Annotation> Optional<AnnotationContainer<A>> findAnnotation(AnnotatedElement element, Class<A> annotationType) {
        Preconditions.notNull(annotationType, (String)"annotationType must not be null");
        boolean inherited = annotationType.isAnnotationPresent(Inherited.class);
        return AnnotationUtils.findAnnotation(element, annotationType, inherited, new HashSet<Annotation>());
    }

    private static <A extends Annotation> Optional<AnnotationContainer<A>> findAnnotation(AnnotatedElement element, Class<A> annotationType, boolean inherited, Set<Annotation> visited) {
        Preconditions.notNull(annotationType, (String)"annotationType must not be null");
        if (element == null) {
            return Optional.empty();
        }
        A annotation = element.getDeclaredAnnotation(annotationType);
        if (annotation != null) {
            return Optional.of(new AnnotationContainer<A>(element, annotation));
        }
        Optional<AnnotationContainer<A>> directMetaAnnotation = AnnotationUtils.findMetaAnnotation(annotationType, element.getDeclaredAnnotations(), inherited, visited);
        if (directMetaAnnotation.isPresent()) {
            return directMetaAnnotation;
        }
        if (element instanceof Class) {
            Optional<AnnotationContainer<A>> annotationOnSuperclass;
            Class superclass;
            Class clazz = (Class)element;
            for (Class<?> ifc : clazz.getInterfaces()) {
                Optional<AnnotationContainer<A>> annotationOnInterface;
                if (ifc == Annotation.class || !(annotationOnInterface = AnnotationUtils.findAnnotation(ifc, annotationType, inherited, visited)).isPresent()) continue;
                return annotationOnInterface;
            }
            if (inherited && (superclass = clazz.getSuperclass()) != null && superclass != Object.class && (annotationOnSuperclass = AnnotationUtils.findAnnotation(superclass, annotationType, inherited, visited)).isPresent()) {
                return annotationOnSuperclass;
            }
        }
        return AnnotationUtils.findMetaAnnotation(annotationType, element.getAnnotations(), inherited, visited);
    }

    private static <A extends Annotation> Optional<AnnotationContainer<A>> findMetaAnnotation(Class<A> annotationType, Annotation[] candidates, boolean inherited, Set<Annotation> visited) {
        for (Annotation candidateAnnotation : candidates) {
            Optional<AnnotationContainer<A>> metaAnnotation;
            Class<? extends Annotation> candidateAnnotationType = candidateAnnotation.annotationType();
            if (AnnotationUtils.isInJavaLangAnnotationPackage(candidateAnnotationType) || !visited.add(candidateAnnotation) || !(metaAnnotation = AnnotationUtils.findAnnotation(candidateAnnotationType, annotationType, inherited, visited)).isPresent()) continue;
            return metaAnnotation;
        }
        return Optional.empty();
    }

    private static boolean isInJavaLangAnnotationPackage(Class<? extends Annotation> annotationType) {
        return annotationType != null && annotationType.getName().startsWith("java.lang.annotation");
    }
}

