/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.common;

import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.CDI;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.jboss.logging.Logger;

public class TestInstantiator {
    private static final Logger log = Logger.getLogger(TestInstantiator.class);

    public static Object instantiateTest(Class<?> testClass, ClassLoader classLoader) {
        try {
            Class<?> actualTestClass = Class.forName(testClass.getName(), true, Thread.currentThread().getContextClassLoader());
            Class<?> delegate = Thread.currentThread().getContextClassLoader().loadClass("io.quarkus.test.common.TestInstantiator$Delegate");
            Method instantiate = delegate.getMethod("instantiate", Class.class);
            return instantiate.invoke(null, actualTestClass);
        }
        catch (Exception e) {
            log.warn((Object)"Failed to initialize test as a CDI bean, falling back to direct initialization", (Throwable)e);
            try {
                Constructor<?> ctor = testClass.getDeclaredConstructor(new Class[0]);
                ctor.setAccessible(true);
                return ctor.newInstance(new Object[0]);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public static class Delegate {
        public static Object instantiate(Class<?> clazz) {
            CDI cdi = CDI.current();
            Instance instance = cdi.select(clazz, new Annotation[0]);
            if (instance.isResolvable()) {
                return instance.get();
            }
            if (clazz.getTypeParameters().length > 0) {
                for (Instance.Handle handle : cdi.select(Object.class, new Annotation[0]).handles()) {
                    if (!clazz.equals(handle.getBean().getBeanClass())) continue;
                    return handle.get();
                }
            }
            throw new IllegalStateException("No bean: " + String.valueOf(clazz));
        }
    }
}

