/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.deployment.devmode;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import io.quarkus.vertx.http.deployment.devmode.NotFoundPageDisplayableEndpointBuildItem;
import io.quarkus.vertx.http.runtime.HttpBuildTimeConfig;
import io.quarkus.vertx.http.runtime.devmode.ArcEndpointRecorder;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;

public class ArcEndpointProcessor {
    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep(onlyIf={IsDevelopment.class})
    void registerRoutes(HttpBuildTimeConfig config, ArcEndpointRecorder recorder, BuildProducer<RouteBuildItem> routes, BuildProducer<NotFoundPageDisplayableEndpointBuildItem> displayableEndpoints) {
        String basePath = config.consolePath + "/arc";
        String beansPath = basePath + "/beans";
        String observersPath = basePath + "/observers";
        routes.produce((BuildItem)new RouteBuildItem(beansPath, (Handler<RoutingContext>)recorder.createBeansHandler()));
        routes.produce((BuildItem)new RouteBuildItem(observersPath, (Handler<RoutingContext>)recorder.createObserversHandler()));
        displayableEndpoints.produce((BuildItem)new NotFoundPageDisplayableEndpointBuildItem(beansPath));
        displayableEndpoints.produce((BuildItem)new NotFoundPageDisplayableEndpointBuildItem(observersPath));
    }
}

